/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.scale.ui;

import com.tridium.seriestransform.scale.BScaleFactor;
import com.tridium.seriestransform.scale.BScaleFactors;
import com.tridium.seriestransform.scale.ui.BScaleFactorsEditor;
import com.tridium.workbench.fieldeditors.BDialogFE;
import java.util.LinkedList;
import java.util.List;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:ScaleFactors"})})
public class BScaleFactorsFE
extends BDialogFE {
    public static final Type TYPE = Sys.loadType(BScaleFactorsFE.class);
    private static final Lexicon lex = Lexicon.make(BScaleFactorsFE.class);
    private static final String COL_FIELD = lex.getText("scalefactors.fieldname");
    private static final String COL_VALUE = lex.getText("scalefactors.value");
    private static final int FIELD = 0;
    private static final int VALUE = 1;
    private final BTable display;
    private BScaleFactors factors;
    private final List<Row> rows = new LinkedList<Row>();

    public Type getType() {
        return TYPE;
    }

    public BScaleFactorsFE() {
        this.display = new BTable((TableModel)new Model());
        BScrollPane scroll = new BScrollPane((BWidget)this.display);
        BConstrainedPane pane = new BConstrainedPane((BWidget)scroll);
        pane.setMinHeight(100.0);
        pane.setMinWidth(200.0);
        BGridPane main = new BGridPane(2);
        main.add(null, (BValue)pane);
        main.add(null, (BValue)this.getEditButton());
        this.setContent((BWidget)main);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BScaleFactor[] children;
        this.factors = (BScaleFactors)value;
        BPermissions permissions = this.factors.getPermissions(context);
        this.setReadonly(!permissions.hasOperatorWrite());
        this.rows.clear();
        for (BScaleFactor factor : children = (BScaleFactor[])this.factors.getChildren(BScaleFactor.class)) {
            factor.lease();
            Row row = new Row(factor.getInputFieldName(), factor.getFactor());
            this.rows.add(row);
        }
        this.display.getModel().updateTable();
        this.repaint();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return this.factors;
    }

    protected void doSetReadonly(boolean readonly) {
        this.getEditButton().setVisible(!readonly);
    }

    public void doEditPressed() {
        try {
            BScaleFactors scaleFactors = BScaleFactorsEditor.open((BWidget)this, this.factors);
            if (null != scaleFactors) {
                this.factors = scaleFactors;
                this.doLoadValue((BObject)this.factors, this.getCurrentContext());
                this.setModified();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Row {
        public String fieldName;
        public double value;

        public Row(String fieldName, double value) {
            this.fieldName = fieldName;
            this.value = value;
        }
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COL_FIELD;
                }
                case 1: {
                    return COL_VALUE;
                }
            }
            return null;
        }

        public int getRowCount() {
            return BScaleFactorsFE.this.rows.size();
        }

        public Object getValueAt(int row, int col) {
            if (row < BScaleFactorsFE.this.rows.size()) {
                Row data = (Row)BScaleFactorsFE.this.rows.get(row);
                switch (col) {
                    case 0: {
                        return data.fieldName;
                    }
                    case 1: {
                        return new Double(data.value);
                    }
                }
            }
            return null;
        }
    }
}

