/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.rollup.ui;

import com.tridium.seriestransform.rollup.BRollupInterval;
import com.tridium.seriestransform.rollup.BRollupIntervalEnum;
import com.tridium.workbench.fieldeditors.BRelTimeFE;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:RollupInterval"})})
@NiagaraAction(name="displayTimeFE")
public class BRollupIntervalFE
extends BWbFieldEditor {
    public static final Action displayTimeFE = BRollupIntervalFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BRollupIntervalFE.class);
    private static final String PROP_TIMEFE = "timeFE";
    private static final String PROP_SELECTOR = "selector";
    private final BGridPane display;
    private final BRelTimeFE timeFE = new BRelTimeFE();
    private final BListDropDown enumSelector = new BListDropDown();

    public void displayTimeFE() {
        this.invoke(displayTimeFE, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRollupIntervalFE() {
        int[] ordinals;
        BEnumRange range = BRollupIntervalEnum.custom.getRange();
        for (int ordinal : ordinals = range.getOrdinals()) {
            IntervalItem item = new IntervalItem(range.getDisplayTag(ordinal, null), BRollupIntervalEnum.make((int)ordinal));
            this.enumSelector.getList().addItem((Object)item);
        }
        this.linkTo((BComponent)this.enumSelector, (Slot)BDropDown.valueModified, (Slot)displayTimeFE);
        this.linkTo((BComponent)this.enumSelector, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.timeFE, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.display = new BGridPane(2);
        this.display.setColumnAlign(BHalign.left);
        this.display.add(PROP_SELECTOR, (BValue)this.enumSelector);
        this.display.add(PROP_TIMEFE, (BValue)new BNullWidget());
        this.setContent((BWidget)this.display);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BRollupInterval interval = (BRollupInterval)value;
        BPermissions permissions = interval.getPermissions(context);
        this.setReadonly(!permissions.hasOperatorWrite());
        BRelTime relTime = interval.getTime();
        BRollupIntervalEnum intervalEnum = interval.getDesc();
        BFacets facets = BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1));
        this.timeFE.loadValue((BObject)relTime, (Context)facets);
        this.setSelectorValue(intervalEnum);
    }

    private void setSelectorValue(BRollupIntervalEnum intervalEnum) {
        int itemCount = this.enumSelector.getList().getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            IntervalItem item = (IntervalItem)this.enumSelector.getList().getItem(i);
            if (item.getInterval().getOrdinal() != intervalEnum.getOrdinal()) continue;
            this.enumSelector.setSelectedIndex(i);
            break;
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BRollupInterval interval = (BRollupInterval)value;
        interval.lease();
        IntervalItem item = (IntervalItem)this.enumSelector.getSelectedItem();
        BRollupIntervalEnum intervalEnum = item.getInterval();
        interval.setDesc(intervalEnum);
        interval.setTime((BRelTime)this.timeFE.saveValue());
        return interval;
    }

    protected void doSetReadonly(boolean readonly) {
        this.timeFE.setEnabled(!readonly);
        this.enumSelector.setEnabled(!readonly);
    }

    public void doDisplayTimeFE() {
        IntervalItem item = (IntervalItem)this.enumSelector.getSelectedItem();
        BRollupIntervalEnum intervalEnum = item.getInterval();
        if (intervalEnum == BRollupIntervalEnum.custom) {
            this.display.set(PROP_TIMEFE, (BValue)this.timeFE);
        } else {
            this.display.set(PROP_TIMEFE, (BValue)new BNullWidget());
        }
        this.repaint();
    }

    static class IntervalItem {
        private final String label;
        private final BRollupIntervalEnum interval;

        public IntervalItem(String label, BRollupIntervalEnum interval) {
            this.label = label;
            this.interval = interval;
        }

        public String toString() {
            return this.label;
        }

        public String getLabel() {
            return this.label;
        }

        public BRollupIntervalEnum getTimeInterval() {
            return this.interval;
        }

        public BRollupIntervalEnum getInterval() {
            return this.interval;
        }
    }
}

