/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph.ui;

import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.seriestransform.graph.ui.BSchemaConfigItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BSchemaConfigEditor
extends BConfigEditor {
    public static final Type TYPE = Sys.loadType(BSchemaConfigEditor.class);
    protected List<BConfigItem> rows = new ArrayList<BConfigItem>();

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean doValidate() {
        HashSet<String> outputs = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        boolean valid = true;
        for (BConfigItem item : this.rows) {
            BSchemaConfigItem config = (BSchemaConfigItem)item;
            String outputColName = config.getOutputField();
            if (outputs.contains(outputColName)) {
                duplicates.add(outputColName);
                valid = false;
            } else {
                config.setDuplicateName(false);
            }
            outputs.add(outputColName);
        }
        for (String duplicate : duplicates) {
            for (BConfigItem item : this.rows) {
                BSchemaConfigItem config = (BSchemaConfigItem)item;
                String outputColName = config.getOutputField();
                if (!outputColName.equalsIgnoreCase(duplicate)) continue;
                config.setDuplicateName(true);
            }
        }
        return valid;
    }
}

