/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.filter.ui;

import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.fieldeditors.BStringFE;
import java.io.IOException;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="srcFieldChanged")
public class BFilterMatchConfig
extends BConfigItem {
    public static final Action srcFieldChanged = BFilterMatchConfig.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BFilterMatchConfig.class);
    private static final String PROP_EDITOR = "editor";
    private static final String PROP_OPERATION = "operation";
    private static final String PROP_SRC_INPUTS = "srcInputs";
    private static final String PROP_WARNING = "warning";
    private final BSeriesSchema srcSchema;
    private BGridPane content;
    private final BListDropDown inputFields = new BListDropDown();
    private final BListDropDown op = new BListDropDown();
    private BWbFieldEditor editor = new BStringFE();
    private boolean readonly;

    public void srcFieldChanged() {
        this.invoke(srcFieldChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFilterMatchConfig() {
        this.srcSchema = null;
    }

    public BFilterMatchConfig(BSeriesSchema schema) {
        this(schema, null, null, null, null);
    }

    public BFilterMatchConfig(BSeriesSchema schema, String selectedField, String selectedOp, String selectedType, String selectedValue) {
        this.srcSchema = schema;
        this.buildUI(selectedField, selectedOp, selectedType, selectedValue);
    }

    private void buildUI(String selectedField, String selectedOp, String selectedType, String selectedValue) {
        this.linkTo((BComponent)this.inputFields, (Slot)BDropDown.valueModified, (Slot)srcFieldChanged);
        this.linkTo((BComponent)this.inputFields, (Slot)BDropDown.valueModified, (Slot)modified);
        this.linkTo((BComponent)this.op, (Slot)BDropDown.valueModified, (Slot)modified);
        this.setSelectedInput(selectedField);
        this.setSelectedValue(selectedValue, selectedType);
        this.setSelectedOp(selectedOp);
        this.content = new BGridPane(4);
        this.content.add(PROP_WARNING, (BValue)this.statusIcon);
        this.content.add(PROP_SRC_INPUTS, (BValue)this.inputFields);
        this.content.add(PROP_OPERATION, (BValue)this.op);
        this.content.add(PROP_EDITOR, (BValue)this.editor);
        this.setCenter((BWidget)this.content);
    }

    private void setSelectedInput(String selectedField) {
        String[] fieldNames = this.srcSchema.getFieldNames();
        int selectedIndex = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            this.inputFields.getList().addItem((Object)fieldName);
            if (null == selectedField || !fieldName.equals(selectedField)) continue;
            selectedIndex = i;
        }
        this.inputFields.setSelectedIndex(selectedIndex);
    }

    private void setSelectedValue(String selectedValue, String selectedType) {
        String fieldName = this.inputFields.getSelectedItem().toString();
        this.editor = this.makeEditor(fieldName, selectedValue, selectedType);
    }

    private BWbFieldEditor makeEditor(String fieldName, String defaultValue, String selectedType) {
        BTypeSpec fieldType = this.srcSchema.getFieldType(fieldName);
        BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)fieldType.getInstance());
        this.linkTo((BComponent)editor, (Slot)BWbPlugin.setModified, (Slot)modified);
        BObject defaultInstance = fieldType.getInstance();
        String inferredType = defaultInstance.getType().toString();
        if (selectedType != null && !selectedType.equals(inferredType)) {
            BConfigEditor.log.warning("Type mismatch: " + selectedType + " is not " + inferredType);
        }
        if (null != defaultValue) {
            try {
                BObject decodedValue = ((BIEncodable)defaultInstance).decodeFromString(defaultValue);
                editor.loadValue(decodedValue);
            }
            catch (IOException e) {
                BConfigEditor.log.severe("Could not load value " + defaultValue + " for Bql Filter match");
            }
        } else {
            BFacets fieldFacets;
            BEnumRange range;
            if (defaultInstance instanceof BDynamicEnum && (range = (BEnumRange)(fieldFacets = this.srcSchema.getFieldFacets(fieldName)).get("range")).getOrdinals().length > 0) {
                defaultInstance = BDynamicEnum.make((int)range.getOrdinals()[0], (BEnumRange)range);
            }
            editor.loadValue(defaultInstance);
        }
        return editor;
    }

    private void setSelectedOp(String selectedOp) {
        int opIndex = 0;
        if (null != selectedOp) {
            int itemCount = this.op.getList().getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                String listOp = (String)this.op.getList().getItem(i);
                if (!listOp.equals(selectedOp)) continue;
                opIndex = i;
                break;
            }
        }
        this.op.setSelectedIndex(opIndex);
    }

    public void doSrcFieldChanged() {
        String fieldName = this.inputFields.getSelectedItem().toString();
        BTypeSpec fieldType = this.srcSchema.getFieldType(fieldName);
        if (fieldType.getTypeInfo().is(BNumber.TYPE)) {
            this.op.getList().setModel(BFilterMatchConfig.getComparableOpModel());
        } else if (fieldType.getTypeInfo().is(BString.TYPE)) {
            this.op.getList().setModel(BFilterMatchConfig.getStringOpModel());
        } else {
            this.op.getList().setModel(BFilterMatchConfig.getObjectOpModel());
        }
        this.editor = this.makeEditor(fieldName, null, null);
        if (null != this.content && null != this.content.get(PROP_EDITOR)) {
            this.content.set(PROP_EDITOR, (BValue)this.editor);
        }
        this.resize();
    }

    protected void resize() {
        if (this.getShell() instanceof BRoundedDialog) {
            BRoundedDialog dlg = (BRoundedDialog)this.getShell();
            Insets insets = UiEnv.get().getWindowInsets((BWindow)dlg);
            dlg.computePreferredSize();
            double h = dlg.getPreferredHeight() + insets.top + insets.bottom;
            double w = dlg.getPreferredWidth() + insets.left + insets.right;
            IRectGeom cur = dlg.getScreenBounds();
            dlg.setScreenBounds(cur.x(), cur.y(), w, h);
        }
    }

    public String saveMatch() throws Exception {
        String srcField = this.inputFields.getSelectedItem().toString();
        String opField = this.op.getSelectedItem().toString();
        BObject value = this.editor.saveValue();
        String valueField = value.toString();
        if (value instanceof BSimple) {
            valueField = value.getType() + " '" + ((BSimple)value).encodeToString() + "'";
        }
        return srcField + " " + opField + " " + valueField;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.inputFields.setEnabled(!readonly);
        this.op.setEnabled(!readonly);
        this.editor.setEnabled(!readonly);
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    private static ListModel getAllOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"!=");
        m.addItem((Object)"<");
        m.addItem((Object)"<=");
        m.addItem((Object)">");
        m.addItem((Object)">=");
        m.addItem((Object)"like");
        return m;
    }

    private static ListModel getStringOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"!=");
        m.addItem((Object)"like");
        return m;
    }

    private static ListModel getComparableOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"!=");
        m.addItem((Object)"<");
        m.addItem((Object)"<=");
        m.addItem((Object)">");
        m.addItem((Object)">=");
        return m;
    }

    private static ListModel getObjectOpModel() {
        DefaultListModel m = new DefaultListModel();
        m.addItem((Object)"=");
        m.addItem((Object)"!=");
        return m;
    }
}

