/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.binding.ui;

import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.SeriesColumn;
import com.tridium.seriestransform.binding.ui.BChartDescriptor;
import com.tridium.seriestransform.binding.ui.BindingUtil;
import com.tridium.seriestransform.functions.ui.BDescriptors;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.ui.Binder;
import java.util.LinkedList;
import javax.baja.chart.Series;
import javax.baja.chart.TableSeries;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BChartBindingCollection;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.collection.BITable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"chart:Chart"}), @AgentOn(types={"seriesTransform:TransformGraph"})})
@NiagaraProperties(value={@NiagaraProperty(name="query", type="BTransformQuery", defaultValue="new BTransformQuery()"), @NiagaraProperty(name="yAxesDescriptors", type="BDescriptors", defaultValue="new BDescriptors()"), @NiagaraProperty(name="xColumn", type="BColumnIdentifier", defaultValue="BColumnIdentifier.makeTableColumn(SeriesColumn.COL_TIMESTAMP)")})
@NiagaraAction(name="setTransformQuery")
public class BTransformChartBindingCollection
extends BChartBindingCollection {
    public static final Property query = BTransformChartBindingCollection.newProperty((int)0, (BValue)new BTransformQuery(), null);
    public static final Property yAxesDescriptors = BTransformChartBindingCollection.newProperty((int)0, (BValue)new BDescriptors(), null);
    public static final Property xColumn = BTransformChartBindingCollection.newProperty((int)0, (BValue)BColumnIdentifier.makeTableColumn((String)SeriesColumn.COL_TIMESTAMP), null);
    public static final Action setTransformQuery = BTransformChartBindingCollection.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTransformChartBindingCollection.class);
    private static final BColor[] DEFAULT_COLORS = new BColor[]{BColor.make((int)3882693), BColor.make((int)11808816), BColor.make((int)0x2AA22A), BColor.make((int)9468084), BColor.make((int)13866541), BColor.make((int)4959430), BColor.make((int)10337121), BColor.make((int)4547207), BColor.make((int)0x800000), BColor.make((int)3703188), BColor.make((int)6311032), BColor.make((int)128)};
    private static final Series[] EMPTY_SERIES = new Series[0];

    public BTransformQuery getQuery() {
        return (BTransformQuery)this.get(query);
    }

    public void setQuery(BTransformQuery v) {
        this.set(query, (BValue)v, null);
    }

    public BDescriptors getYAxesDescriptors() {
        return (BDescriptors)this.get(yAxesDescriptors);
    }

    public void setYAxesDescriptors(BDescriptors v) {
        this.set(yAxesDescriptors, (BValue)v, null);
    }

    public BColumnIdentifier getXColumn() {
        return (BColumnIdentifier)this.get(xColumn);
    }

    public void setXColumn(BColumnIdentifier v) {
        this.set(xColumn, (BValue)v, null);
    }

    public void setTransformQuery() {
        this.invoke(setTransformQuery, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTransformChartBindingCollection() {
        Slot slot = this.getSlot(seriesName.getName());
        if (null != slot) {
            this.setFlags(slot, 4);
        }
        if (null != (slot = this.getSlot(brush.getName()))) {
            this.setFlags(slot, 4);
        }
        if (null != (slot = this.getSlot(pen.getName()))) {
            this.setFlags(slot, 4);
        }
        this.linkTo((BComponent)this, (Slot)query, (Slot)setTransformQuery);
    }

    public Series[] createSeriesSet() {
        BObject bObject = this.get();
        if (!(bObject instanceof BITable)) {
            return EMPTY_SERIES;
        }
        BITable data = (BITable)bObject;
        LinkedList<TableSeries> seriesSet = new LinkedList<TableSeries>();
        BDescriptors descriptors = this.getYAxesDescriptors();
        BChartDescriptor[] children = (BChartDescriptor[])descriptors.getChildren(BChartDescriptor.class);
        int index = 0;
        for (BChartDescriptor desc : children) {
            String seriesName = desc.getSeriesName();
            BColumnIdentifier yId = desc.getYColumn();
            BColumnIdentifier xId = this.getXColumn();
            BPen pen = desc.getPen();
            BBrush brush = desc.getBrush();
            if (brush.equals((Object)BBrush.NULL)) {
                brush = index < DEFAULT_COLORS.length ? BBrush.makeSolid((BColor)DEFAULT_COLORS[index++]) : BBrush.makeSolid((BColor)BColor.getConstants()[index++]);
            }
            TableSeries tableSeries = new TableSeries(seriesName, data, xId, yId, brush, pen);
            seriesSet.add(tableSeries);
        }
        return seriesSet.toArray(new Series[seriesSet.size()]);
    }

    public BAxisSpec getYAxis(Series series) {
        return this.getYAxis();
    }

    public void doSetTransformQuery() {
        BTransformQuery transformQuery = this.getQuery();
        BOrd targetGraphOrd = transformQuery.getGraphOrd();
        if (null == targetGraphOrd || targetGraphOrd == BOrd.NULL) {
            return;
        }
        this.autoPopulateDescriptors(targetGraphOrd);
        BOrd baseBindingOrd = this.getOrd();
        BOrd ord = BindingUtil.makeTransformQuery(transformQuery, baseBindingOrd);
        this.setOrd(ord);
    }

    private void autoPopulateDescriptors(BOrd targetGraphOrd) {
        BWidget widget = this.getWidget();
        if (null != widget && !widget.isDesignTime()) {
            return;
        }
        Object[] children = this.getYAxesDescriptors().getChildren(BChartDescriptor.class);
        if (children.length > 0) {
            return;
        }
        Binder binder = this.getOurBinder();
        if (null == binder) {
            return;
        }
        BWidget owner = binder.getOwner();
        BWbShell wbShell = BWbShell.getWbShell((BWidget)owner);
        if (null == wbShell) {
            return;
        }
        BOrd activeOrd = wbShell.getActiveOrd();
        OrdQuery[] queries = activeOrd.parse();
        OrdQueryList myQueries = new OrdQueryList(queries);
        myQueries.shiftToSession(myQueries.size());
        BOrd base = BOrd.make((OrdQuery[])myQueries.toArray());
        targetGraphOrd = BOrd.make((String)("station:|" + targetGraphOrd.encodeToString()));
        targetGraphOrd = BOrd.make((BOrd)base, (BOrd)targetGraphOrd);
        BObject obj = targetGraphOrd.get();
        if (obj instanceof BTransformGraph) {
            String[] fieldNames;
            BTransformGraph graph = (BTransformGraph)obj;
            graph.lease(3);
            BSeriesSchema schema = graph.getSchema();
            for (String name : fieldNames = schema.getFieldNames()) {
                BTypeSpec fieldType = schema.getFieldType(name);
                if (!fieldType.getTypeInfo().is(BINumeric.TYPE) && !fieldType.getTypeInfo().is(BIBoolean.TYPE) && !fieldType.getTypeInfo().is(BIEnum.TYPE)) continue;
                BChartDescriptor cd = new BChartDescriptor();
                cd.setSeriesName(name);
                cd.setYColumn(BColumnIdentifier.makeTableColumn((String)name));
                this.getYAxesDescriptors().add(null, (BValue)cd);
            }
        }
    }

    private Binder getOurBinder() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            Binder binder = (Binder)p.fw(302, null, null, null, null);
            if (binder == null) continue;
            return binder;
        }
        return null;
    }

    public void started() {
        super.started();
        this.setTransformQuery();
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        boolean isGet;
        if (x == 308 && a instanceof HxOp && (isGet = ((HxOp)a).getRequest().getMethod().equals("GET"))) {
            return BBoolean.TRUE;
        }
        return super.fw(x, a, b, c, d);
    }
}

