/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.binding.ui;

import com.tridium.seriestransform.binding.ui.BChartDescriptor;
import com.tridium.seriestransform.binding.ui.BDescriptorEditor;
import com.tridium.seriestransform.functions.ui.BDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:Descriptors"})})
public class BDescriptorsFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BDescriptorsFE.class);
    private static final Lexicon lex = Lexicon.make(BDescriptorsFE.class);
    private static final String CN_NAME = lex.getText("seriesdescriptor.name");
    private static final String CN_Y_ID = lex.getText("seriesdescriptor.columnid");
    private static final String CN_BRUSH = lex.getText("seriesdescriptor.brush");
    private static final int COL_COUNT = 3;
    private static final int COL_NAME = 0;
    private static final int COL_Y_ID = 1;
    private static final int COL_BRUSH = 2;
    private static final BImage IMG_ADD = BImage.make((String)"module://seriesTransform/icons/add.png");
    private static final BImage IMG_DEL = BImage.make((String)"module://seriesTransform/icons/minus.png");
    private static final BImage IMG_EDIT = BImage.make((String)"module://seriesTransform/icons/ellipsis.png");
    private final List<BChartDescriptor> model = new ArrayList<BChartDescriptor>();
    private BDescriptors container;
    private final BTable collectionTable = new BTable((TableModel)new Model(), (TableController)new Controller());
    private final BButton add;
    private final BButton edit;
    private final BButton remove;

    public Type getType() {
        return TYPE;
    }

    public BDescriptorsFE() {
        this.collectionTable.setCellRenderer((TableCellRenderer)new Renderer());
        BScrollPane scroll = new BScrollPane((BWidget)this.collectionTable);
        BConstrainedPane pane = new BConstrainedPane((BWidget)scroll);
        pane.setMinHeight(100.0);
        pane.setMinWidth(250.0);
        BGridPane main = new BGridPane(2);
        BGridPane buttonPane = new BGridPane(1);
        this.add = this.makeButton(new AddDescriptorCmd((BWidget)this), null);
        this.edit = this.makeButton(new EditDescriptorCmd((BWidget)this), null);
        this.remove = this.makeButton(new RemoveDescriptorCmd((BWidget)this), null);
        buttonPane.add(null, (BValue)this.add);
        buttonPane.add(null, (BValue)this.edit);
        buttonPane.add(null, (BValue)this.remove);
        buttonPane.setValign(BValign.top);
        main.setValign(BValign.top);
        main.setHalign(BHalign.left);
        main.add(null, (BValue)pane);
        main.add(null, (BValue)buttonPane);
        this.setContent((BWidget)main);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.container = (BDescriptors)value;
        this.container.lease();
        BChartDescriptor[] children = (BChartDescriptor[])this.container.getChildren(BChartDescriptor.class);
        Arrays.asList(children).forEach(this.model::add);
        this.collectionTable.getModel().updateTable();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.container.lease();
        this.container.removeAll();
        for (BChartDescriptor desc : this.model) {
            this.container.add(null, (BValue)desc);
        }
        return this.container;
    }

    protected void doSetReadonly(boolean readonly) {
        this.collectionTable.setEnabled(!readonly);
        this.add.setEnabled(!readonly);
        this.edit.setEnabled(!readonly);
        this.remove.setEnabled(!readonly);
    }

    protected BButton makeButton(Command cmd, BColor fill) {
        BButton b = new BButton(cmd);
        b.setButtonStyle(BButtonStyle.toolBar);
        if (fill != null) {
            b.setBackground(fill.toBrush());
        }
        return b;
    }

    private static class Renderer
    extends TableCellRenderer {
        private Renderer() {
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.column == 2 && cell.value instanceof BBrush) {
                BBrush brush = (BBrush)cell.value;
                g.setBrush(brush);
                g.fillRect(2.0, 2.0, 14.0, cell.height - 5.0);
                g.setBrush(BBrush.makeSolid((BColor)BColor.black));
                g.strokeLine(2.0, 2.0, 16.0, 2.0);
                g.strokeLine(2.0, 2.0, 2.0, cell.height - 4.0);
                g.strokeLine(16.0, 2.0, 16.0, cell.height - 4.0);
                g.strokeLine(2.0, cell.height - 4.0, 16.0, cell.height - 4.0);
            } else {
                super.paintCell(g, cell);
            }
        }
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return CN_NAME;
                }
                case 1: {
                    return CN_Y_ID;
                }
                case 2: {
                    return CN_BRUSH;
                }
            }
            return "";
        }

        public int getRowCount() {
            return BDescriptorsFE.this.model.size();
        }

        public Object getValueAt(int row, int col) {
            if (row >= BDescriptorsFE.this.model.size()) {
                return null;
            }
            BChartDescriptor desc = (BChartDescriptor)((Object)BDescriptorsFE.this.model.get(row));
            switch (col) {
                case 0: {
                    return desc.getSeriesName();
                }
                case 1: {
                    return desc.getYColumn();
                }
                case 2: {
                    return desc.getBrush();
                }
            }
            return null;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BChartDescriptor desc = (BChartDescriptor)((Object)BDescriptorsFE.this.model.get(row));
            try {
                BDescriptorEditor.open((BWidget)this.getShell(), desc);
            }
            catch (CannotSaveException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class RemoveDescriptorCmd
    extends Command {
        public RemoveDescriptorCmd(BWidget owner) {
            super(owner, "");
        }

        public CommandArtifact doInvoke() throws Exception {
            TableSelection selection = BDescriptorsFE.this.collectionTable.getSelection();
            int row = selection.getRow();
            BDescriptorsFE.this.model.remove(row);
            BDescriptorsFE.this.setModified();
            BDescriptorsFE.this.collectionTable.getModel().updateTable();
            BDescriptorsFE.this.repaint();
            return null;
        }

        public BImage getIcon() {
            return IMG_DEL;
        }
    }

    private class EditDescriptorCmd
    extends Command {
        public EditDescriptorCmd(BWidget owner) {
            super(owner, "");
        }

        public CommandArtifact doInvoke() throws Exception {
            TableSelection selection = BDescriptorsFE.this.collectionTable.getSelection();
            int row = selection.getRow();
            BChartDescriptor desc = (BChartDescriptor)((Object)BDescriptorsFE.this.model.get(row));
            BDescriptorEditor.open((BWidget)this.getShell(), desc);
            BDescriptorsFE.this.setModified();
            return null;
        }

        public BImage getIcon() {
            return IMG_EDIT;
        }
    }

    private class AddDescriptorCmd
    extends Command {
        public AddDescriptorCmd(BWidget owner) {
            super(owner, "");
        }

        public CommandArtifact doInvoke() throws Exception {
            BChartDescriptor desc = BDescriptorEditor.open((BWidget)this.getShell(), null);
            BDescriptorsFE.this.model.add(desc);
            BDescriptorsFE.this.setModified();
            BDescriptorsFE.this.collectionTable.getModel().updateTable();
            BDescriptorsFE.this.repaint();
            return null;
        }

        public BImage getIcon() {
            return IMG_ADD;
        }
    }
}

