/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.binding.ui;

import com.tridium.seriestransform.binding.ui.BChartDescriptor;
import com.tridium.workbench.celltable.BLabeledCellTable;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BWbCellEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BDescriptorEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BDescriptorEditor.class);
    private static final Lexicon lex = Lexicon.make(BDescriptorEditor.class);
    private static final String EDITOR_TITLE = lex.getText("seriesdescriptor.title");
    private static final String CN_VALUE = lex.getText("seriesdescriptor.value");
    private static final String CN_PEN = lex.getText("seriesdescriptor.pen");
    private static final String CN_NAME = lex.getText("seriesdescriptor.name");
    private static final String CN_Y_ID = lex.getText("seriesdescriptor.columnid");
    private static final String CN_BRUSH = lex.getText("seriesdescriptor.brush");
    private final BWbCellEditor seriesCE;
    private final BWbCellEditor columnCE;
    private final BWbCellEditor brushCE;
    private final BWbCellEditor penCE;

    public Type getType() {
        return TYPE;
    }

    public static BChartDescriptor open(BWidget owner, BChartDescriptor desc) throws Exception {
        if (null == desc) {
            desc = new BChartDescriptor();
        }
        BDescriptorEditor de = new BDescriptorEditor();
        de.loadValue((BObject)desc);
        int result = BDialog.open((BWidget)owner, (String)EDITOR_TITLE, (Object)((Object)de), (int)3);
        if (result == 1) {
            return (BChartDescriptor)de.saveValue();
        }
        return null;
    }

    public BDescriptorEditor() {
        BLabeledCellTable lct = new BLabeledCellTable(new String[]{CN_VALUE});
        BChartDescriptor desc = new BChartDescriptor();
        this.seriesCE = BWbCellEditor.makeFor((BObject)BString.make((String)""));
        this.columnCE = BWbCellEditor.makeFor((BObject)desc.getYColumn());
        this.brushCE = BWbCellEditor.makeFor((BObject)desc.getBrush());
        this.penCE = BWbCellEditor.makeFor((BObject)desc.getPen());
        this.seriesCE.loadValue((BObject)BString.make((String)desc.getSeriesName()));
        this.columnCE.loadValue((BObject)desc.getYColumn());
        this.brushCE.loadValue((BObject)desc.getBrush());
        this.penCE.loadValue((BObject)desc.getPen());
        lct.addRow(CN_NAME, new BWbCellEditor[]{this.seriesCE});
        lct.addRow(CN_Y_ID, new BWbCellEditor[]{this.columnCE});
        lct.addRow(CN_BRUSH, new BWbCellEditor[]{this.brushCE});
        lct.addRow(CN_PEN, new BWbCellEditor[]{this.penCE});
        this.linkTo((BComponent)this.seriesCE, (Slot)setModified, (Slot)setModified);
        this.linkTo((BComponent)this.columnCE, (Slot)setModified, (Slot)setModified);
        this.linkTo((BComponent)this.brushCE, (Slot)setModified, (Slot)setModified);
        this.linkTo((BComponent)this.penCE, (Slot)setModified, (Slot)setModified);
        BConstrainedPane tablePane = new BConstrainedPane((BWidget)lct);
        tablePane.setMinHeight(150.0);
        tablePane.setMinWidth(300.0);
        this.setContent((BWidget)tablePane);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BChartDescriptor chartDesc = (BChartDescriptor)value;
        this.seriesCE.loadValue((BObject)BString.make((String)chartDesc.getSeriesName()));
        this.columnCE.loadValue((BObject)chartDesc.getYColumn());
        this.brushCE.loadValue((BObject)chartDesc.getBrush());
        this.penCE.loadValue((BObject)chartDesc.getPen());
    }

    protected BObject doSaveValue(BObject v, Context cx) throws Exception {
        if (!(v instanceof BChartDescriptor)) {
            throw new CannotSaveException();
        }
        BChartDescriptor desc = (BChartDescriptor)v;
        BString value = (BString)this.seriesCE.saveValue();
        desc.setSeriesName(value.getString());
        desc.setYColumn((BColumnIdentifier)this.columnCE.saveValue());
        desc.setBrush((BBrush)this.brushCE.saveValue());
        desc.setPen((BPen)this.penCE.saveValue());
        return desc;
    }
}

