/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import java.util.logging.Level;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;

public abstract class BWeatherProvider
extends BComponent {
    public static final Action updateSunStatus = BWeatherProvider.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BWeatherProvider.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weatherProvider.png");
    private Clock.Ticket updateSun = null;

    public void updateSunStatus() {
        this.invoke(updateSunStatus, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract void updateReport();

    public void clockChanged(BRelTime shift) {
        if (this.updateSun != null && !this.updateSun.isExpired()) {
            this.updateSun.cancel();
        }
        this.updateSunStatus();
    }

    public void doUpdateSunStatus() {
        BAbsTime now = BAbsTime.now();
        BWeatherReport report = (BWeatherReport)this.getParent();
        BCurrentConditions current = report.getCurrent();
        if (!current.getSunrise().equals((Object)current.getSunset())) {
            boolean newSunDown;
            boolean earlyMorning = now.isBefore(BAbsTime.make((BAbsTime)now, (BTime)current.getSunrise()));
            boolean lateEvening = now.isAfter(BAbsTime.make((BAbsTime)now, (BTime)current.getSunset()));
            boolean bl = newSunDown = earlyMorning || lateEvening;
            if (current.getSunDown().getValue() != newSunDown) {
                current.setSunDown(new BStatusBoolean(newSunDown));
            }
        } else {
            BWeatherService.log.log(Level.FINE, "Location " + report.getName() + " has no sunrise or sunset.");
        }
        if (this.updateSun == null || this.updateSun.isExpired()) {
            boolean sunset = false;
            boolean sunrise = false;
            if (BAbsTime.make((BAbsTime)now, (BTime)current.getSunset()).isAfter(now)) {
                sunset = true;
            }
            if (BAbsTime.make((BAbsTime)now, (BTime)current.getSunrise()).isAfter(now)) {
                sunrise = true;
            }
            if (sunrise && sunset) {
                BTime time = BTime.make((BRelTime)BRelTime.make((long)Math.min(current.getSunset().getTimeOfDayMillis(), current.getSunrise().getTimeOfDayMillis())));
                this.updateSun = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((BAbsTime)now, (BTime)time), (Action)updateSunStatus, null);
                BWeatherService.log.log(Level.FINE, "Scheduled sun status update for " + report.getName() + " at " + time);
            } else if (sunrise) {
                this.updateSun = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((BAbsTime)now, (BTime)current.getSunrise()), (Action)updateSunStatus, null);
                BWeatherService.log.log(Level.FINE, "Scheduled sun status update for " + report.getName() + " at " + current.getSunrise());
            } else if (sunset) {
                this.updateSun = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((BAbsTime)now, (BTime)current.getSunset()), (Action)updateSunStatus, null);
                BWeatherService.log.log(Level.FINE, "Scheduled sun status update for " + report.getName() + " at " + current.getSunset());
            }
        }
        BWeatherService.log.log(Level.FINE, "Updated sun status for " + report.getName());
    }

    public void stopped() throws Exception {
        if (this.updateSun != null) {
            this.updateSun.cancel();
        }
        super.stopped();
    }

    public BIcon getIcon() {
        return icon;
    }
}

