/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class NwsStationList {
    private static Station[] list = null;

    public NwsStationList() {
        if (list == null) {
            NwsStationList.loadStationList();
        }
    }

    public String[] getStates() {
        ArrayList<String> temp = new ArrayList<String>();
        for (Station s : list) {
            if (temp.contains(s.state) || s.name.isEmpty() || s.latitude == 0.0 || s.longitude == 0.0) continue;
            temp.add(s.state);
        }
        return temp.toArray(new String[temp.size()]);
    }

    public String[] getLocations(String state) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Station s : list) {
            if (!state.equals(s.state) || s.name.isEmpty() || s.latitude == 0.0 || s.longitude == 0.0) continue;
            temp.add(s.name);
        }
        return temp.toArray(new String[temp.size()]);
    }

    public String getStationId(String name, String state) {
        if (name == null || state == null) {
            return "";
        }
        for (Station s : list) {
            if (!name.equals(s.name) || !state.equals(s.state)) continue;
            return s.id;
        }
        return "";
    }

    public String searchStationId(String name, String state) {
        for (Station s : list) {
            if (!s.name.toLowerCase().contains(name.toLowerCase()) || !state.equalsIgnoreCase(s.state)) continue;
            return s.id;
        }
        return null;
    }

    public Station getStation(String id) {
        for (Station s : list) {
            if (!s.id.equals(id)) continue;
            return s;
        }
        return null;
    }

    private static void loadStationList() {
        try {
            BOrd ord = BOrd.make((String)"module://weather/com/tridium/weather/nws/nwsStationList.xml");
            BIFile file = (BIFile)ord.resolve().get();
            XElem root = XParser.make((InputStream)file.getInputStream()).parse();
            XElem[] elems = root.elems();
            list = new Station[elems.length];
            for (int i = 0; i < list.length; ++i) {
                Station s = new Station();
                s.state = elems[i].get("s", "");
                s.id = elems[i].get("i", "");
                s.name = elems[i].get("n", "");
                s.latitude = elems[i].getd("x", Double.NaN);
                s.longitude = elems[i].getd("y", Double.NaN);
                s.zone = elems[i].get("z", null);
                s.zipCode = elems[i].get("c", null);
                NwsStationList.list[i] = s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Station {
        public String state;
        public String id;
        public String name;
        public double latitude;
        public double longitude;
        public String zone;
        public String zipCode;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.name);
            buf.append(", ").append(this.state);
            return buf.toString();
        }
    }
}

