/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.AirQualityIndexUtil;
import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.FeedReader;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.status.BStatus;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherService;
import javax.baja.xml.XElem;

public class EpaForecastReader {
    BNwsWeatherProvider provider;
    private static final Logger log = Logger.getLogger("weather");
    private static final int MAX_REDIRECTS = 5;

    public EpaForecastReader(BNwsWeatherProvider provider) {
        this.provider = provider;
    }

    public XElem getFeed(NwsStationList.Station station, BForecast[] forecast) throws Exception {
        BWeatherService ws = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
        String apiKey = ws.getAirQualityApiKey();
        if (apiKey.equals("")) {
            throw new Exception("Air Quality API key has not been set. Please set the key or disable air quality checks.");
        }
        String airQualityForecastPath = this.provider.getValidAirQualityForecastPath();
        String airQualityApiKeyField = this.provider.getValidAirQualityApiKeyFieldValue();
        String uri = airQualityForecastPath + station.zipCode + airQualityApiKeyField + apiKey;
        String host = this.provider.getAirQualityHost();
        return this.getFeed(station, forecast, host, uri);
    }

    XElem getFeed(NwsStationList.Station station, BForecast[] forecast, String host, String uri) throws Exception {
        try {
            return FeedReader.getXmlFeed(host, uri, 5, false);
        }
        catch (IOException exception) {
            throw new BajaException("Unable to get EPA Forecast feed", (Throwable)exception);
        }
    }

    public BForecast[] getForecast(NwsStationList.Station station, BForecast[] forecasts) throws Exception {
        if (station.zipCode == null) {
            return forecasts;
        }
        if (!this.provider.getAirQualityEnabled()) {
            for (BForecast forecast : forecasts) {
                forecast.getOzone().setValue(Double.NaN);
                forecast.getOzone().setStatus(BStatus.nullStatus);
                forecast.getParticulateMatter().setValue(Double.NaN);
                forecast.getParticulateMatter().setStatus(BStatus.nullStatus);
            }
            return forecasts;
        }
        SimpleDateFormat format = new SimpleDateFormat("M/d/yyyy hh:mm:ss a");
        GregorianCalendar calendar = new GregorianCalendar(BTimeZone.getLocal().getJavaTimeZone());
        XElem[] epaForecasts = new XElem[]{};
        boolean errorMessage = false;
        try {
            XElem root = this.getFeed(station, forecasts);
            epaForecasts = root.elems("ForecastByZip");
            if (epaForecasts.length == 0) {
                if (root.name().equals("WebServiceError")) {
                    if (root.elem("Message").text().string().contains("Web service request limit exceeded")) {
                        log.warning("Exceeded Air Quality request limit. Change the poll frequency, or request a new API key from http://airnowapi.org/");
                    } else {
                        log.warning("Air Quality web service error.");
                    }
                } else if (root.name().equals("ForecastByZipList")) {
                    log.warning("No air quality reporting stations nearby.");
                } else {
                    log.warning("Air Quality unknown error.");
                }
                errorMessage = true;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to retrieve EPA air quality forecast.", e);
            errorMessage = true;
        }
        if (errorMessage) {
            for (BForecast forecast : forecasts) {
                forecast.getOzone().setStatus(BStatus.makeStale((BStatus)forecast.getOzone().getStatus(), (boolean)true));
                forecast.getParticulateMatter().setStatus(BStatus.makeStale((BStatus)forecast.getParticulateMatter().getStatus(), (boolean)true));
            }
            return forecasts;
        }
        for (BForecast forecast : forecasts) {
            boolean ozoneFound = false;
            boolean pmFound = false;
            for (XElem epaForecast : epaForecasts) {
                try {
                    int pmAqi;
                    if (!ozoneFound && epaForecast.elem("ParameterName").text().string().equalsIgnoreCase("O3")) {
                        int ozoneAqi;
                        calendar.setTime(format.parse(epaForecast.elem("DateForecast").text().string()));
                        if (forecast.getDate().getDay() == calendar.get(5) && forecast.getDate().getMonth().getOrdinal() == calendar.get(2) && (ozoneAqi = Integer.parseInt(epaForecast.elem("AQI").text().string())) >= 0) {
                            double ozoneConcentration = AirQualityIndexUtil.aqiToOzoneConcentration(ozoneAqi);
                            forecast.getOzone().setValue(ozoneConcentration);
                            forecast.getOzone().setStatus(BStatus.ok);
                            ozoneFound = true;
                        }
                    }
                    if (pmFound || !epaForecast.elem("ParameterName").text().string().equalsIgnoreCase("pm2.5")) continue;
                    calendar.setTime(format.parse(epaForecast.elem("DateForecast").text().string()));
                    if (forecast.getDate().getDay() != calendar.get(5) || forecast.getDate().getMonth().getOrdinal() != calendar.get(2) || (pmAqi = Integer.parseInt(epaForecast.elem("AQI").text().string())) < 0) continue;
                    double pmConcentration = AirQualityIndexUtil.aqiToParticulateConcentration(pmAqi);
                    forecast.getParticulateMatter().setValue(pmConcentration);
                    forecast.getParticulateMatter().setStatus(BStatus.ok);
                    pmFound = true;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Difficulty parsing EPA air quality forecast.", e);
                }
            }
            if (!ozoneFound) {
                forecast.getOzone().setValue(Double.NaN);
                forecast.getOzone().setStatus(64);
            }
            if (pmFound) continue;
            forecast.getParticulateMatter().setValue(Double.NaN);
            forecast.getParticulateMatter().setStatus(64);
        }
        return forecasts;
    }
}

