/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.nws.EpaCurrentReader;
import com.tridium.weather.nws.EpaForecastReader;
import com.tridium.weather.nws.NwsCurrentReader;
import com.tridium.weather.nws.NwsForecastReader;
import com.tridium.weather.nws.NwsStationList;
import com.tridium.weather.nws.advisory.BNwsAdvisoryAlarmExt;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;

public class BNwsWeatherProvider
extends BWeatherProvider {
    @Generated
    public static final Property stationId = BNwsWeatherProvider.newProperty((int)0, (String)"KRIC", null);
    @Generated
    public static final Property outlook = BNwsWeatherProvider.newProperty((int)0, (int)7, null);
    @Generated
    public static final Property location = BNwsWeatherProvider.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property longitude = BNwsWeatherProvider.newProperty((int)1, (int)0, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    @Generated
    public static final Property latitude = BNwsWeatherProvider.newProperty((int)1, (int)0, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    @Generated
    public static final Property airQualityEnabled = BNwsWeatherProvider.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property forecastServer = BNwsWeatherProvider.newProperty((int)4, (String)"graphical.weather.gov", null);
    @Generated
    public static final Property forecastPath = BNwsWeatherProvider.newProperty((int)4, (String)"/xml/sample_products/browser_interface/ndfdBrowserClientByDay.php", null);
    @Generated
    public static final Property conditionsServer = BNwsWeatherProvider.newProperty((int)4, (String)"www.weather.gov", null);
    @Generated
    public static final Property conditionsPath = BNwsWeatherProvider.newProperty((int)4, (String)"/xml/current_obs/", null);
    @Generated
    public static final Property advisoriesServer = BNwsWeatherProvider.newProperty((int)4, (String)"alerts.weather.gov", null);
    @Generated
    public static final Property advisoriesPath = BNwsWeatherProvider.newProperty((int)4, (String)"/cap/", null);
    @Generated
    public static final Property airQualityHost = BNwsWeatherProvider.newProperty((int)4, (String)"www.airnowapi.org", null);
    @Generated
    public static final Property airQualityCurrentPath = BNwsWeatherProvider.newProperty((int)4, (String)"/aq/observation/zipCode/current/?format=application/xml&zipCode=", null);
    @Generated
    public static final Property airQualityForecastPath = BNwsWeatherProvider.newProperty((int)4, (String)"/aq/forecast/zipCode/?format=application/xml&zipCode=", null);
    @Generated
    public static final Property airQualityApiKeyField = BNwsWeatherProvider.newProperty((int)4, (String)"&API_KEY=", null);
    @Generated
    public static final Property advisoriesAlarmExt = BNwsWeatherProvider.newProperty((int)0, (BValue)new BNwsAdvisoryAlarmExt(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNwsWeatherProvider.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weatherProvider.png");
    public static final int READ_TIMEOUT = AccessController.doPrivileged(() -> Integer.getInteger("weather.nws.readTimeout", 15000));
    public static final int CONNECT_TIMEOUT = AccessController.doPrivileged(() -> Integer.getInteger("weather.nws.connectTimeout", 15000));
    public static NwsStationList stationList = new NwsStationList();
    private static final String EQUALS = "=";
    private static final String AMPERSAND = "&";
    private static final String FORWARD_SLASH = "/";
    private static final String DEFAULT_ADVISORIES_SERVER = "api.weather.gov";
    private static final String DEFAULT_ADVISORIES_PATH = "/alerts.atom?zone=";
    private static final String DEFAULT_CONDITIONS_SERVER = "forecast.weather.gov";

    @Generated
    public String getStationId() {
        return this.getString(stationId);
    }

    @Generated
    public void setStationId(String v) {
        this.setString(stationId, v, null);
    }

    @Generated
    public int getOutlook() {
        return this.getInt(outlook);
    }

    @Generated
    public void setOutlook(int v) {
        this.setInt(outlook, v, null);
    }

    @Generated
    public String getLocation() {
        return this.getString(location);
    }

    @Generated
    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    @Generated
    public double getLongitude() {
        return this.getDouble(longitude);
    }

    @Generated
    public void setLongitude(double v) {
        this.setDouble(longitude, v, null);
    }

    @Generated
    public double getLatitude() {
        return this.getDouble(latitude);
    }

    @Generated
    public void setLatitude(double v) {
        this.setDouble(latitude, v, null);
    }

    @Generated
    public boolean getAirQualityEnabled() {
        return this.getBoolean(airQualityEnabled);
    }

    @Generated
    public void setAirQualityEnabled(boolean v) {
        this.setBoolean(airQualityEnabled, v, null);
    }

    @Generated
    public String getForecastServer() {
        return this.getString(forecastServer);
    }

    @Generated
    public void setForecastServer(String v) {
        this.setString(forecastServer, v, null);
    }

    @Generated
    public String getForecastPath() {
        return this.getString(forecastPath);
    }

    @Generated
    public void setForecastPath(String v) {
        this.setString(forecastPath, v, null);
    }

    @Generated
    public String getConditionsServer() {
        return this.getString(conditionsServer);
    }

    @Generated
    public void setConditionsServer(String v) {
        this.setString(conditionsServer, v, null);
    }

    @Generated
    public String getConditionsPath() {
        return this.getString(conditionsPath);
    }

    @Generated
    public void setConditionsPath(String v) {
        this.setString(conditionsPath, v, null);
    }

    @Generated
    public String getAdvisoriesServer() {
        return this.getString(advisoriesServer);
    }

    @Generated
    public void setAdvisoriesServer(String v) {
        this.setString(advisoriesServer, v, null);
    }

    @Generated
    public String getAdvisoriesPath() {
        return this.getString(advisoriesPath);
    }

    @Generated
    public void setAdvisoriesPath(String v) {
        this.setString(advisoriesPath, v, null);
    }

    @Generated
    public String getAirQualityHost() {
        return this.getString(airQualityHost);
    }

    @Generated
    public void setAirQualityHost(String v) {
        this.setString(airQualityHost, v, null);
    }

    @Generated
    public String getAirQualityCurrentPath() {
        return this.getString(airQualityCurrentPath);
    }

    @Generated
    public void setAirQualityCurrentPath(String v) {
        this.setString(airQualityCurrentPath, v, null);
    }

    @Generated
    public String getAirQualityForecastPath() {
        return this.getString(airQualityForecastPath);
    }

    @Generated
    public void setAirQualityForecastPath(String v) {
        this.setString(airQualityForecastPath, v, null);
    }

    @Generated
    public String getAirQualityApiKeyField() {
        return this.getString(airQualityApiKeyField);
    }

    @Generated
    public void setAirQualityApiKeyField(String v) {
        this.setString(airQualityApiKeyField, v, null);
    }

    @Generated
    public BNwsAdvisoryAlarmExt getAdvisoriesAlarmExt() {
        return (BNwsAdvisoryAlarmExt)this.get(advisoriesAlarmExt);
    }

    @Generated
    public void setAdvisoriesAlarmExt(BNwsAdvisoryAlarmExt v) {
        this.set(advisoriesAlarmExt, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.updateDefaultProperties();
    }

    private void updateDefaultProperties() {
        this.updateDefaultPropertyValue(advisoriesServer, DEFAULT_ADVISORIES_SERVER);
        this.updateDefaultPropertyValue(advisoriesPath, DEFAULT_ADVISORIES_PATH);
        this.updateDefaultPropertyValue(conditionsServer, DEFAULT_CONDITIONS_SERVER);
    }

    private void updateDefaultPropertyValue(Property property, String updatedValue) {
        if (!Flags.isUserDefined1((BComplex)this, (Slot)property)) {
            this.set(property, (BValue)BString.make((String)updatedValue));
            this.setFlags((Slot)property, this.getFlags((Slot)property) | 0x10000000);
        }
    }

    @Override
    public void updateReport() {
        BForecast[] children;
        BWeatherReport report = (BWeatherReport)this.getParent();
        NwsStationList.Station station = stationList.getStation(this.getStationId());
        if (station == null) {
            BForecast[] children2;
            BWeatherService.log.log(Level.SEVERE, "Invalid weather station for " + report.getName());
            for (BForecast child : children2 = (BForecast[])report.getChildren(BForecast.class)) {
                child.setStatus(BStatus.makeFault((BStatus)child.getStatus(), (boolean)true));
            }
            report.getCurrent().setStatus(BStatus.makeFault((BStatus)report.getCurrent().getStatus(), (boolean)true));
            report.setStatus(BStatus.makeFault((BStatus)report.getStatus(), (boolean)true));
            return;
        }
        for (BForecast child : children = (BForecast[])report.getChildren(BForecast.class)) {
            child.setStatus(BStatus.makeFault((BStatus)child.getStatus(), (boolean)false));
        }
        report.getCurrent().setStatus(BStatus.makeFault((BStatus)report.getCurrent().getStatus(), (boolean)false));
        report.setStatus(BStatus.makeFault((BStatus)report.getStatus(), (boolean)false));
        this.setLongitude(station.longitude);
        this.setLatitude(station.latitude);
        try {
            try {
                BNwsAdvisoryAlarmExt alarmExt = this.getAdvisoriesAlarmExt();
                if (alarmExt.getEnabled()) {
                    alarmExt.getAdvisories(this, report.getCurrent(), station);
                }
                report.getCurrent().getAdvisories().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getAdvisories().getStatus(), (boolean)false));
            }
            catch (Exception e) {
                report.getCurrent().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getStatus(), (boolean)true));
                BWeatherService.log.log(Level.WARNING, "Updating advisories failed for " + report.getName(), e);
                report.getCurrent().getAdvisories().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getAdvisories().getStatus(), (boolean)true));
            }
            NwsCurrentReader nwsCurrentReader = new NwsCurrentReader(this);
            nwsCurrentReader.getCurrent(this, report.getCurrent(), station);
            EpaCurrentReader epaCurrentReader = new EpaCurrentReader(this);
            epaCurrentReader.getCurrent(this, report.getCurrent(), station);
            boolean stale = !report.getCurrent().getObserved().isNull() && report.getCurrent().getObserved().isBefore(BAbsTime.now().subtract(BRelTime.makeHours((int)3)));
            report.getCurrent().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getStatus(), (boolean)stale));
            if (BWeatherService.log.isLoggable(Level.FINE)) {
                BWeatherService.log.log(Level.FINE, "Updated current conditions for " + report.getName());
            }
        }
        catch (Exception e) {
            report.getCurrent().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getStatus(), (boolean)true));
            BWeatherService.log.log(Level.WARNING, "Updating current conditions failed for " + report.getName(), e);
        }
        try {
            BForecast[] children3;
            NwsForecastReader nwsForecastReader = new NwsForecastReader(this);
            BForecast[] forecast = nwsForecastReader.getForecast(station, this.getOutlook());
            EpaForecastReader epaForecastReader = new EpaForecastReader(this);
            epaForecastReader.getForecast(station, forecast);
            report.setForecast(forecast);
            if (BWeatherService.log.isLoggable(Level.FINE)) {
                BWeatherService.log.log(Level.FINE, "Updated forecast for " + report.getName());
            }
            for (BForecast child : children3 = (BForecast[])report.getChildren(BForecast.class)) {
                child.setStatus(BStatus.makeStale((BStatus)child.getStatus(), (boolean)false));
            }
        }
        catch (Exception e) {
            BForecast[] children4;
            for (BForecast child : children4 = (BForecast[])report.getChildren(BForecast.class)) {
                child.setStatus(BStatus.makeStale((BStatus)child.getStatus(), (boolean)true));
            }
            BWeatherService.log.log(Level.WARNING, "Updating forecast failed for " + report.getName(), e);
        }
    }

    public String toString(Context context) {
        NwsStationList.Station station = stationList.getStation(this.getStationId());
        if (station != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(station.name);
            buf.append(", ").append(station.state);
            return buf.toString();
        }
        return this.getStationId();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(stationId)) {
            this.setLocation("");
            ((BWeatherReport)this.getParent()).updateWeatherReport();
        }
    }

    public String getValidAirQualityCurrentPath() {
        return this.getValidUriPathValue(this.getAirQualityCurrentPath(), "nwsWeatherProvider.airQualityCurrentPath.missingEquals");
    }

    public String getValidAirQualityForecastPath() {
        return this.getValidUriPathValue(this.getAirQualityForecastPath(), "nwsWeatherProvider.airQualityForecastPath.missingEquals");
    }

    public String getValidAdvisoriesPath() {
        return this.getValidUriPathValue(this.getAdvisoriesPath(), "nwsWeatherProvider.advisoriesPath.missingEquals");
    }

    public String getValidAirQualityApiKeyFieldValue() {
        return this.getValidUriPathValue(AMPERSAND, this.getAirQualityApiKeyField(), "nwsWeatherProvider.airQualityApiKeyField.missingEquals");
    }

    private String getValidUriPathValue(String uriPathValue, String errorMessage) {
        return this.getValidUriPathValue(FORWARD_SLASH, uriPathValue, errorMessage);
    }

    private String getValidUriPathValue(String prefix, String uriPathValue, String errorMessage) {
        if (!uriPathValue.endsWith(EQUALS)) {
            throw new LocalizableRuntimeException("weather", errorMessage);
        }
        StringBuilder returnVal = new StringBuilder();
        if (!uriPathValue.startsWith(prefix)) {
            returnVal.append(prefix);
        }
        returnVal.append(uriPathValue);
        return returnVal.toString();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

