/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.driverUpgrade.wizard.UpgradeWizardModel;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

public abstract class BUpgradeWizardStep
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BUpgradeWizardStep.class);
    private BEdgePane contentPane;
    protected BUpgradeWizardStep priorStep = null;
    protected BUpgradeWizardStep nextStep = null;
    protected BUpgradeWizardStep lastStep = this;
    protected BUpgradeWizardStep stepAfterSection = null;
    protected UpgradeWizardModel wizardModel;
    public static final Lexicon LEX = Lexicon.make((String)"driverUpgrade");
    public static final Logger LOG = Logger.getLogger("driverUpgrade");
    public static final BIcon DEFAULT_ICON = BIcon.make((String)"module://icons/x32/wizard.png");

    public Type getType() {
        return TYPE;
    }

    public BUpgradeWizardStep() {
    }

    public BUpgradeWizardStep(UpgradeWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.setTop((BWidget)new BWizardHeader(this.getStepIcon(), LEX.getText("UpgradeWizard." + this.getSectionName() + ".sectionDesc"), LEX.get("UpgradeWizard." + this.getStepName() + ".desc", "")));
        this.contentPane = new BEdgePane();
        this.setCenter((BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
    }

    public final BImage getStepIcon() {
        String iconOrd = LEX.get("UpgradeWizard." + this.getSectionName() + ".sectionIcon", null);
        return iconOrd == null ? BImage.make((BIcon)DEFAULT_ICON) : BImage.make((String)iconOrd);
    }

    public abstract String getStepName();

    public abstract String getSectionName();

    public void checkMode() {
    }

    protected void setContent(BWidget content) {
        this.contentPane.setCenter(content);
        content.relayout();
        this.contentPane.relayout();
    }

    public boolean showCancelPrompt() {
        return true;
    }

    public int getMode() {
        int result = 0;
        BUpgradeWizardStep step = this.priorStep;
        while (step != null && step.isSkipped()) {
            step = step.priorStep;
        }
        if (step != null) {
            result = 1;
        }
        step = this.nextStep;
        while (step != null && step.isSkipped()) {
            step = step.nextStep;
        }
        result = step == null ? (result |= 4) : (result |= 2);
        return result;
    }

    public void enter() {
    }

    public boolean checkBack() {
        return true;
    }

    public boolean checkNext() {
        return true;
    }

    public boolean exit(int direction) {
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isSkipped() {
        return false;
    }

    public void setStepAfterSection(BUpgradeWizardStep value) {
        this.stepAfterSection = value;
        this.lastStep.nextStep = value;
        if (value != null) {
            value.priorStep = this.lastStep;
        }
    }

    public void setPriorStep(BUpgradeWizardStep value) {
        this.priorStep = value;
    }

    public UpgradeWizardModel getWizardModel() {
        return this.wizardModel;
    }
}

