/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.driverUpgrade.wizard.BUpgradeWizardStep;
import com.tridium.driverUpgrade.wizard.UpgradeWizardModel;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;

public class BUpgradeReviewStep
extends BUpgradeWizardStep {
    public static final Type TYPE = Sys.loadType(BUpgradeReviewStep.class);
    private BIndentPane ip = null;
    private boolean hasInstalls = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BUpgradeReviewStep() {
    }

    public BUpgradeReviewStep(UpgradeWizardModel wizardModel) {
        super(wizardModel);
        BGridPane topGp = new BGridPane(1);
        topGp.setHalign(BHalign.left);
        topGp.setValign(BValign.top);
        topGp.setRowGap(6.0);
        topGp.add(null, (BValue)new BBox(0.0, 5.0));
        topGp.add(null, (BValue)new BLabel(LEX.getText("UpgradeWizard.review.header")));
        topGp.add(null, (BValue)new BBox(0.0, 5.0));
        BGridPane botGp = new BGridPane(1);
        botGp.setHalign(BHalign.left);
        botGp.setValign(BValign.top);
        botGp.setRowGap(6.0);
        botGp.add(null, (BValue)new BBox(0.0, 5.0));
        botGp.add(null, (BValue)new BLabel(LEX.getText("UpgradeWizard.review.line2")));
        botGp.add(null, (BValue)new BBox(0.0, 5.0));
        botGp.add(null, (BValue)new BLabel(LEX.getText("UpgradeWizard.review.line3")));
        botGp.add(null, (BValue)new BBox(0.0, 5.0));
        this.ip = new BIndentPane();
        BScrollPane sp = new BScrollPane((BWidget)this.ip);
        sp.setViewportBackground(Theme.scrollPane().getControlBackground());
        BEdgePane ep = new BEdgePane((BWidget)new BBorderPane((BWidget)topGp, 0.0, 0.0, 10.0, 0.0), (BWidget)botGp, null, null, (BWidget)sp);
        this.setContent((BWidget)ep);
    }

    @Override
    public String getSectionName() {
        return "review";
    }

    @Override
    public String getStepName() {
        return "review";
    }

    @Override
    public int getMode() {
        if (!this.hasInstalls) {
            return 6;
        }
        return 2;
    }

    @Override
    public void enter() {
        String[] nets = (String[])this.getWizardModel().upgrades.trim();
        if (nets.length > 0) {
            this.hasInstalls = true;
            this.nl();
            this.output(LEX.getText("UpgradeWizard.review.upgrade.top"));
            this.indent();
            for (int i = 0; i < nets.length; ++i) {
                this.output(nets[i]);
            }
            this.unindent();
        }
        this.nl();
        InstallScenario solution = this.getWizardModel().solution;
        BInstallable[] ina = solution.getToInstall();
        if (ina.length > 0) {
            BInstallable inst;
            int i;
            this.hasInstalls = true;
            this.output(LEX.getText("UpgradeWizard.review.install.core"));
            this.indent();
            for (i = 0; i < ina.length; ++i) {
                inst = ina[i];
                if (!(inst instanceof BDistribution)) continue;
                this.output((BWidget)new BLabel(BImage.make((BIcon)inst.getIcon()), inst.toString()));
            }
            this.unindent();
            this.nl();
            this.output(LEX.getText("UpgradeWizard.review.install.modules"));
            this.indent();
            for (i = 0; i < ina.length; ++i) {
                inst = ina[i];
                if (inst instanceof BDistribution) continue;
                this.output((BWidget)new BLabel(BImage.make((BIcon)inst.getIcon()), inst.toString()));
            }
            this.unindent();
        } else {
            this.output(LEX.getText("UpgradeWizard.review.noinstall1"));
            this.nl();
            this.output(LEX.getText("UpgradeWizard.review.noinstall2"));
        }
    }

    private void indent() {
        this.ip.indent();
    }

    private void unindent() {
        this.ip.unindent();
    }

    private void output(String s) {
        this.ip.add(s);
    }

    private void output(BWidget w) {
        this.ip.add(w);
    }

    private void nl() {
        this.ip.add((BWidget)new BBox(0.0, 5.0));
    }
}

