/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.driverUpgrade.wizard.BUpgradeWizardStep;
import com.tridium.driverUpgrade.wizard.UpgradeWizardModel;
import com.tridium.ui.util.LabelUtil;
import javax.baja.file.BDirectory;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;

public class BSelectionStep
extends BUpgradeWizardStep {
    public static final Action checkMode = BSelectionStep.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSelectionStep.class);
    private BTextDropDown stationDD;
    private boolean loading = false;
    private int mode = 0;

    @Override
    public void checkMode() {
        this.invoke(checkMode, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSelectionStep() {
        super(null);
    }

    public BSelectionStep(UpgradeWizardModel wizardModel) {
        super(wizardModel);
        BGridPane ledgerPane = new BGridPane(2);
        ledgerPane.setHalign(BHalign.left);
        ledgerPane.setValign(BValign.top);
        ledgerPane.setColumnGap(10.0);
        ledgerPane.setRowGap(6.0);
        ledgerPane.add(null, (BValue)LabelUtil.makeLabel((String)LEX.getText("UpgradeWizard.select.select"), (boolean)true));
        this.stationDD = new BTextDropDown();
        ledgerPane.add(null, (BValue)this.stationDD);
        this.setContent((BWidget)ledgerPane);
    }

    @Override
    public String getSectionName() {
        return "select";
    }

    @Override
    public String getStepName() {
        return "select";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enter() {
        this.loading = true;
        try {
            BDirectory[] stationDirs = this.getWizardModel().stationDirs;
            BList list = this.stationDD.getList();
            for (int i = 0; i < stationDirs.length; ++i) {
                list.getModel().addItem((Object)stationDirs[i].getFileName().toString());
            }
            list.setSelectedIndex(0);
            this.stationDD.setText(list.getSelectedItem().toString());
        }
        finally {
            this.loading = false;
        }
        this.checkMode();
    }

    @Override
    public boolean exit(int direction) {
        try {
            this.getWizardModel().selectedStation = this.stationDD.getList().getSelectedIndex();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void doCheckMode() {
        if (this.loading) {
            return;
        }
        this.mode = 3;
        this.getWizardModel().update(this.mode);
    }

    @Override
    public int getMode() {
        return this.mode;
    }
}

