/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.backup.ui.BBackupManager;
import com.tridium.driver.upgrade.Upgrade;
import com.tridium.driverUpgrade.wizard.BUpgradeWizardStep;
import com.tridium.driverUpgrade.wizard.UpgradeTaskDetailPane;
import com.tridium.driverUpgrade.wizard.UpgradeWizardModel;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.ComponentSlotMap;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.util.Version;

public class BProcessBogStep
extends BUpgradeWizardStep {
    public static final Type TYPE = Sys.loadType(BProcessBogStep.class);
    protected ProcessTask processTask;
    protected int mode;
    protected boolean succeeded;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BProcessBogStep() {
    }

    public BProcessBogStep(UpgradeWizardModel wizardModel) {
        super(wizardModel);
    }

    @Override
    public String getSectionName() {
        return "process";
    }

    @Override
    public String getStepName() {
        return "process";
    }

    @Override
    public boolean cancel() {
        if (this.processTask.isRunning()) {
            this.processTask.cancel();
            return false;
        }
        return true;
    }

    @Override
    public void enter() {
        this.processTask = new ProcessTask();
        this.setContent(this.processTask.getPane());
        new Thread(this.processTask).start();
    }

    @Override
    public boolean exit(int direction) {
        return !this.processTask.isRunning();
    }

    @Override
    public void checkMode() {
        if (this.processTask.isRunning()) {
            this.setMode(0);
        } else if (this.succeeded) {
            this.setMode(2);
        }
    }

    private void setMode(int value) {
        if (this.mode != value) {
            this.mode = value;
            if (this.wizardModel.getCurrentStep() == this) {
                this.wizardModel.update(this.mode);
            }
        }
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    protected class Dots
    extends Thread {
        private boolean dotCanceled = false;
        private boolean dotRunning = true;
        private int i = 0;
        private BTextOutputPane log;

        public Dots(BTextOutputPane log) {
            this.log = log;
        }

        @Override
        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i >= 60) {
                    this.log.append("\n");
                    this.i = 0;
                }
                ++this.i;
                this.log.append(".");
            }
            this.log.append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected class ProcessTask
    extends UpgradeTaskDetailPane
    implements DaemonSessionTaskListener {
        private Version maxCoreVersion = null;
        private String lastText;
        private boolean isRunning = false;
        protected UpgradeTaskDetailPane.TaskItem syncSoftwareTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.syncSoftwareTask"));
        protected UpgradeTaskDetailPane.TaskItem makeBackupTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.makeBackupTask"));
        protected UpgradeTaskDetailPane.TaskItem dbUpgradeTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.dbUpgradeTask"));
        protected UpgradeTaskDetailPane.TaskItem moduleUpgradeTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.moduleUpgradeTask"));

        public ProcessTask() {
            this.init();
        }

        @Override
        public void run() {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            try {
                if (!this.syncSoftware()) {
                    return;
                }
                if (!this.makeBackup()) {
                    return;
                }
                if (!this.upgradeConfig()) {
                    return;
                }
                if (!this.checkDependancies()) {
                    return;
                }
                BProcessBogStep.this.succeeded = true;
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.success") + '\n');
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.success.bottomContent")));
            }
            catch (ICancelHint.CanceledException ce) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.canceled") + '\n');
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.canceled")));
                this.updateCurrentItemState(BJobState.canceled);
            }
            catch (Throwable t) {
                this.updateCurrentItemState(BJobState.failed);
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.failed")));
                t.printStackTrace();
                this.getLog().append(t);
                this.getLog().append("\n");
            }
            finally {
                this.isRunning = false;
                BProcessBogStep.this.checkMode();
            }
        }

        private void syncModule(BModuleInstallable module) throws Exception {
            BDependency dep = BDependency.forPart((BPart)module.getModulePart(), (BVersionRelation)BVersionRelation.exact);
            if (LocalInstallableRegistry.getInstance().findInstallable(dep, (DaemonSessionTaskListener)this) == null) {
                BIFile remoteFile = BProcessBogStep.this.getWizardModel().platform.getDaemonSession().getFileSpace().findFile(new FilePath("!modules").merge(module.getInstallableFileName()));
                InputStream in = remoteFile.getInputStream();
                LocalInstallableRegistry.getInstance().register(module.getInstallableName(), module.getInstallableFileName(), module.getVersion(), in, (DaemonSessionTaskListener)this);
            }
        }

        protected boolean syncSoftware() throws Exception {
            this.setCurrentItem(this.syncSoftwareTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.syncSoftware") + '\n');
            BProcessBogStep.this.getWizardModel().platform.getModuleList().init((DaemonSessionTaskListener)this);
            SlotCursor cModules = BProcessBogStep.this.getWizardModel().platform.getModuleList().getModules().getProperties();
            while (cModules.next()) {
                this.checkCanceled();
                this.syncModule((BModuleInstallable)cModules.get());
            }
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.syncSoftware.done") + '\n');
            this.updateCurrentItemState(BJobState.success);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean makeBackup() throws Exception {
            this.setCurrentItem(this.makeBackupTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.backup") + '\n');
            String interest = "UpgradeWizard.process";
            BFoxSession foxSession = BProcessBogStep.this.getWizardModel().foxSession();
            foxSession.engageNoRetry(interest);
            try {
                BStation station = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)foxSession);
                station.lease(0);
                BOrd backupJobOrd = BBackupManager.submitBackupJob((String)BProcessBogStep.this.getWizardModel().backupPath.getBody(), (BFoxSession)foxSession);
                station.getComponentSpace().sync();
                BJob backupJob = (BJob)backupJobOrd.get((BObject)station);
                backupJob.lease(1);
                while (true) {
                    this.checkCanceled();
                    BJobState state = backupJob.getJobState();
                    if (state == BJobState.failed || state == BJobState.canceled) {
                        this.updateCurrentItemState(BJobState.failed);
                        boolean bl = false;
                        return bl;
                    }
                    if (state == BJobState.success) break;
                    Thread.sleep(500L);
                    if (backupJob.getLeaseExpiration() != -1L) continue;
                    backupJob.lease(1);
                }
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.backup.done") + '\n');
                this.updateCurrentItemState(BJobState.success);
                boolean bl = true;
                return bl;
            }
            finally {
                foxSession.disengage(interest);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean upgradeConfig() throws Exception {
            BBogFile bogFile;
            this.setCurrentItem(this.dbUpgradeTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.upgradeConfig") + '\n');
            BDistributionFile backupFile = (BDistributionFile)BFileSystem.INSTANCE.findFile(BProcessBogStep.this.getWizardModel().backupPath);
            BValue v = null;
            try (ZipInputStream zipIn = new ZipInputStream(backupFile.getInputStream());){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    if (entry.getName().endsWith("config.bog")) {
                        this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.decodeConfig") + '\n');
                        ValueDocDecoder vd = new ValueDocDecoder((InputStream)new BufferedInputStream(zipIn));
                        v = vd.decodeDocument();
                        break;
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            BProcessBogStep.this.getWizardModel().upgrades.clear();
            Hashtable<String, Upgrade> ht = this.getRegisteredUpgraders();
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.upgradeNetworks") + '\n');
            v = this.upgrade((BComplex)v, ht, 0, true);
            BIFile f = BFileSystem.INSTANCE.makeFile(BProcessBogStep.this.getWizardModel().backupPath.getParent().merge("config.bog"));
            BProcessBogStep.this.getWizardModel().bogFile = bogFile = new BBogFile(f.getStore());
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.encodeConfig") + '\n');
            ValueDocEncoder encoder = new ValueDocEncoder(bogFile.getOutputStream());
            encoder.setZipped(true);
            encoder.setEncodeComments(true);
            encoder.encodeDocument(v);
            encoder.close();
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.upgrade.done") + '\n');
            this.updateCurrentItemState(BJobState.success);
            return true;
        }

        private Hashtable<String, Upgrade> getRegisteredUpgraders() {
            Hashtable<String, Upgrade> upH = new Hashtable<String, Upgrade>();
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.getUpgraders") + '\n');
            String[] defs = Sys.getRegistry().getDefs("upgradeClass");
            for (int i = 0; i < defs.length; ++i) {
                String def = defs[i];
                int colNdx = def.indexOf(58);
                Upgrade upr = null;
                try {
                    upr = (Upgrade)Sys.newInstance((String)def.substring(0, colNdx), (String)def.substring(colNdx + 1));
                }
                catch (Exception e) {
                    continue;
                }
                this.getLog().append("  " + upr.getClass().getName() + '\n');
                String[] cla = upr.upgradableClasses();
                for (int n = 0; n < cla.length; ++n) {
                    upH.put(cla[n], upr);
                }
            }
            return upH;
        }

        private BComplex upgrade(BComplex co, Hashtable<String, Upgrade> ht, int depth, boolean up) {
            BComplex cn = co;
            boolean upgrad = up;
            Upgrade upg = ht.get(this.modTypeName((BValue)co));
            if (upgrad && upg != null) {
                cn = (BComplex)upg.upgrade((BValue)co, null);
            }
            if (co instanceof BDeviceNetwork) {
                if (upg == null) {
                    upgrad = false;
                } else {
                    this.addUpdateModule(co, cn);
                }
            }
            if (cn == co) {
                cn = (BComplex)cn.newCopy(true);
            }
            if (cn.isComponent()) {
                ((ComponentSlotMap)cn.asComponent().fw(1)).setHandle(co.asComponent().getHandle());
            }
            Property[] pa = co.getPropertiesArray();
            for (int i = 0; i < pa.length; ++i) {
                Property oldP = pa[i];
                BValue oldV = co.get(pa[i]);
                if (oldV == null) continue;
                Property newP = cn.getProperty(oldP.getName());
                if (oldP.isFrozen() && newP == null) continue;
                if (oldV.isSimple()) {
                    if (newP == null) continue;
                    cn.set(newP, this.upgradeVal(oldV, ht, up));
                    continue;
                }
                BComplex newV = this.upgrade((BComplex)oldV, ht, depth + 1, upgrad);
                if (newP != null) {
                    cn.set(newP, (BValue)newV);
                } else if (oldP.isDynamic() && cn.isComponent()) {
                    co.asComponent().remove(oldP);
                    newP = cn.asComponent().add(oldP.getName(), (BValue)newV, null);
                    Knob[] knobs = co.asComponent().getKnobs((Slot)oldP);
                    BLink[] links = co.asComponent().getLinks((Slot)oldP);
                    if (knobs.length > 0 || links.length > 0) {
                        BProcessBogStep.this.getWizardModel().upgrades.add((Object)("Lost links for " + co.getDisplayName(null)));
                    }
                }
                if (newP == null) continue;
                ComplexSlotMap slotMap = (ComplexSlotMap)cn.fw(1, null, null, null, null);
                BFacets f = co.getSlotFacets((Slot)oldP);
                if (!f.isNull() && !newP.isFrozen()) {
                    slotMap.setFacets((Slot)newP, f, null);
                }
                if (!cn.isComponent()) continue;
                int oldFlags = co.getFlags((Slot)oldP);
                int mask = oldFlags ^ oldP.getDefaultFlags();
                int nf = cn.getFlags((Slot)newP) & ~mask | oldFlags & mask;
                cn.setFlags((Slot)newP, nf);
            }
            return cn;
        }

        private BValue upgradeVal(BValue v, Hashtable<String, Upgrade> ht, boolean up) {
            if (!up) {
                return v;
            }
            Upgrade upg = ht.get(this.modTypeName(v));
            if (upg != null) {
                return upg.upgrade(v, null);
            }
            return v;
        }

        private void addUpdateModule(BComplex co, BComplex cn) {
            String newMod = cn.getType().getModule().getModuleName();
            String oldMod = co.getType().getModule().getModuleName();
            String s = co.getDisplayName(null) + "  from:" + oldMod + "  to:" + newMod;
            this.getLog().append("  " + s + '\n');
            BProcessBogStep.this.getWizardModel().upgrades.add((Object)s);
        }

        private boolean checkDependancies() throws Exception {
            this.setCurrentItem(this.moduleUpgradeTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.moduleUpgrade") + '\n');
            BDirectory sourceStationDir = BFileSystem.INSTANCE.makeDir(BProcessBogStep.this.getWizardModel().backupPath.getParent());
            DependencyUtil.AnalysisResults analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)BProcessBogStep.this.getWizardModel().platform, (BFileSpace)sourceStationDir.getFileSpace(), (FilePath)sourceStationDir.getFilePath(), null, null);
            InstallScenario is = analysisResults.getSolution();
            if (analysisResults.anyUnsolvable()) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.moduleUpgrade.failed") + '\n');
                UnmeetableDependency[] deps = is.getUnmeetableDependencies();
                for (int i = 0; i < deps.length; ++i) {
                    this.getLog().append("   " + deps[i].toString() + '\n');
                }
                this.updateCurrentItemState(BJobState.failed);
                return false;
            }
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.distributionUpdates") + '\n');
            BDistribution unacceptedDist = null;
            InstallScenario solution = null;
            InstallScenario almostSolution = null;
            IterableCursor c = LocalInstallableRegistry.getInstance().getInstallables(true, (DaemonSessionTaskListener)this, BProcessBogStep.this.getWizardModel().platform.getConfigDistFileName());
            while (c.next()) {
                Object o = c.get();
                if (!(o instanceof BDistribution)) continue;
                BDistribution d = (BDistribution)c.get();
                boolean acceptedDist = this.acceptInstallable((BInstallable)d);
                InstallScenario s = is.solve((DaemonSessionTaskListener)this, null, null, new BInstallable[]{d}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                if (s.canCommit() && (s = s.solve((DaemonSessionTaskListener)this, null, DependencyUtil.getPlatformModuleDependencies((BDaemonPlatform)BProcessBogStep.this.getWizardModel().platform, (BDistribution)d, (Set)s.getNewEnabledRuntimeProfiles()), null, (InstallableRegistry)LocalInstallableRegistry.getInstance())).canCommit()) {
                    solution = s;
                    break;
                }
                if (s.getExcludedInstallables().length != 0 || solution != null && s.getUnmeetableDependencies().length >= almostSolution.getUnmeetableDependencies().length) continue;
                boolean wrongPlatform = false;
                BDependency[] unmet = s.getUnmetDependencies();
                for (int i = 0; i < unmet.length; ++i) {
                    BDependency dep = unmet[i];
                    if (!dep.isPlatformDependency(BProcessBogStep.this.wizardModel.platform)) continue;
                    wrongPlatform = true;
                    break;
                }
                if (wrongPlatform) continue;
                if (acceptedDist) {
                    almostSolution = s;
                    continue;
                }
                if (unacceptedDist != null) continue;
                unacceptedDist = d;
            }
            if (solution == null || !solution.canCommit()) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.coreCheck.failed") + '\n');
                if (almostSolution != null) {
                    BDependency[] unmet = almostSolution.getUnmetDependencies();
                    for (int i = 0; i < unmet.length; ++i) {
                        this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.coreCheck.unmet") + unmet[i].getPartName() + '\n');
                    }
                }
                this.updateCurrentItemState(BJobState.failed);
                return false;
            }
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.addOutOfDates") + '\n');
            BProcessBogStep.this.getWizardModel().solution = solution = InstallScenario.upgradeOutOfDate(solution, (InstallableRegistry)LocalInstallableRegistry.getInstance());
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.moduleUpgrade.done") + '\n');
            this.updateCurrentItemState(BJobState.success);
            return true;
        }

        public boolean acceptInstallable(BInstallable inst) {
            if ("true".equals(System.getProperty("niagara.commissioning.ignoreLicenseVersion"))) {
                return true;
            }
            try {
                Version maxCoreVersion = this.getMaxCoreVersion();
                if (inst.getInstallableName().startsWith("nre-core") || inst.getInstallableName().equals("baja")) {
                    if (inst.getVersion().getVendorVersion().compareTo(maxCoreVersion) >= 0) {
                        return false;
                    }
                } else if (inst instanceof BDistribution && BPart.matchesName((String)inst.getInstallableFileName(), (String)BProcessBogStep.this.getWizardModel().platform.getConfigDistFileName())) {
                    BDependency[] configDeps = inst.getAllDependencies();
                    for (int i = 0; i < configDeps.length; ++i) {
                        if (configDeps[i].getPartType() != BNrePart.TYPE) continue;
                        if (configDeps[i].getVersion().getVendorVersion().compareTo(maxCoreVersion) < 0) break;
                        return false;
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        public Version getMaxCoreVersion() {
            if (this.maxCoreVersion == null) {
                Version v;
                if (BProcessBogStep.this.getWizardModel().currentLicenseVersion == null) {
                    this.loadCurrentLicenses();
                }
                this.maxCoreVersion = (v = BProcessBogStep.this.getWizardModel().currentLicenseVersion) == null ? Version.ZERO : new Version(v.major() + "." + (v.minor() + 1));
            }
            return this.maxCoreVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadCurrentLicenses() {
            BIFile brandProps;
            BProcessBogStep.this.getWizardModel().currentLicenses.clear();
            BDirectory licDir = (BDirectory)BProcessBogStep.this.getWizardModel().daemonSession.getFileSpace().findFile(new FilePath("!licenses"));
            if (licDir == null) {
                BProcessBogStep.this.getWizardModel().canSkipLicense = false;
                BProcessBogStep.this.getWizardModel().skipLicense = false;
                return;
            }
            String hostId = BProcessBogStep.this.getWizardModel().daemonSession.getHostProperties().getHostId();
            BINavNode[] files = licDir.getNavChildren();
            if (files == null) {
                BProcessBogStep.this.getWizardModel().canSkipLicense = false;
                BProcessBogStep.this.getWizardModel().skipLicense = false;
                return;
            }
            int count = files.length;
            String b = null;
            for (int i = 0; i < count; ++i) {
                BIFile file;
                if (!(files[i] instanceof BIFile) || !"license".equalsIgnoreCase((file = (BIFile)files[i]).getExtension())) continue;
                try {
                    LicenseInfo info = new LicenseInfo(file);
                    if (!hostId.equals(info.vendorLicense.getHostId())) continue;
                    if (b == null) {
                        b = info.getBrand();
                    }
                    if (info.vendorLicense.getVendor().equalsIgnoreCase("tridium") && !info.isExpired()) {
                        BProcessBogStep.this.getWizardModel().currentLicenseVersion = info.vendorLicense.getVersion();
                    }
                    BProcessBogStep.this.getWizardModel().currentLicenses.add((Object)info);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (b == null && (brandProps = BProcessBogStep.this.getWizardModel().daemonSession.getFileSpace().findFile(new FilePath("!brand.properties"))) != null) {
                try {
                    Properties props = new Properties();
                    InputStream in = brandProps.getInputStream();
                    try {
                        props.load(in);
                        b = props.getProperty("brand.id", null);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    BProcessBogStep.this.getWizardModel().canSkipLicense = false;
                    BProcessBogStep.this.getWizardModel().skipLicense = false;
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            if (BProcessBogStep.this.getWizardModel().currentLicenseVersion == null) {
                BProcessBogStep.this.getWizardModel().canSkipLicense = false;
                BProcessBogStep.this.getWizardModel().skipLicense = false;
            } else {
                BProcessBogStep.this.getWizardModel().canSkipLicense = true;
            }
            BProcessBogStep.this.getWizardModel().brandId = b;
        }

        private String modTypeName(BValue c) {
            Type t = c.getType();
            return t.getModule().getModuleName() + ":" + t.getTypeName();
        }

        @Override
        public String getItemListHeading() {
            return BUpgradeWizardStep.LEX.getText("UpgradeWizard.process.heading");
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public void cancel() {
            super.cancel();
            BProcessBogStep.this.checkMode();
        }

        @Override
        public UpgradeTaskDetailPane.TaskItem[] makeTaskItems() {
            return new UpgradeTaskDetailPane.TaskItem[]{this.syncSoftwareTask, this.makeBackupTask, this.dbUpgradeTask, this.moduleUpgradeTask};
        }

        public void taskStarted(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
            if (task instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)task).isCancelEnabled()) {
                this.setCancelEnabled(false);
            }
        }

        public void taskFinished(DaemonSessionTask task) {
        }
    }
}

