/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.px.editor.factory;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import javax.baja.converters.BEnumToSimpleMap;
import javax.baja.converters.BNumericToSimpleMap;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.file.types.image.BIImageFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.factory.WidgetFactory;
import javax.baja.px.editor.factory.WidgetInserter;
import javax.baja.space.BISpace;
import javax.baja.spy.BSpy;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;

public class ImageFileFactory
extends WidgetFactory {
    Lexicon LEX = Lexicon.make((String)"pxEditor");
    private static final String NOT_FOUND = "Spy Not Found";
    private static final long MAX_IMAGE_FILE_SIZE = AccessController.doPrivileged(() -> Long.getLong("niagara.ui.px.maxImageModuleFileSize", 2048L));

    public ImageFileFactory(BPxEditor editor) {
        super(editor, BIImageFile.TYPE);
    }

    @Override
    public WidgetInserter make(BObject[] objects) {
        if (!this.canConvert(objects)) {
            throw new IllegalStateException();
        }
        BWidget[] widgets = new BWidget[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            BIImageFile file = (BIImageFile)objects[i];
            BOrd ord = file.getAbsoluteOrd();
            if (BOrdFE.isRelativize((BOrd)ord, null, (BWbShell)this.getPxEditor().getWbShell())) {
                ord = ord.relativizeToSession();
            }
            ord = this.convertImageOrd(ord);
            BImage img = BImage.make((BOrd)ord);
            img.setBaseOrd(this.getPxEditor().getWbShell().getActiveOrd());
            img.sync();
            widgets[i] = new BLabel(img);
            widgets[i].setLayout(BLayout.make((double)0.0, (int)0, (double)0.0, (int)0, (double)img.getWidth(), (int)0, (double)img.getHeight(), (int)0));
        }
        return new WidgetInserter(widgets);
    }

    public BOrd convertImageOrd(BOrd ord) {
        BPxEditor editor = this.getPxEditor();
        BIFile pxFile = editor.getPxFile();
        BFileSpace pxFileSpace = pxFile.getFileSpace();
        BIFile file = (BIFile)ord.get((BObject)pxFileSpace);
        boolean localStation = false;
        boolean offlineStation = !(pxFileSpace instanceof BFoxFileSpace);
        BOrd activeOrd = editor.getWbShell().getActiveOrd();
        OrdTarget activeTarget = activeOrd.resolve();
        for (OrdQuery query : activeTarget.getOrdQueries()) {
            String scheme = query.getScheme();
            if (!scheme.equals("local")) continue;
            localStation = true;
        }
        if (BModule.isModuleFileSpace((BISpace)file.getFileSpace())) {
            BModule bModule = (BModule)BModule.getModule((BISpace)file.getFileSpace()).get();
            String moduleName = bModule.getModuleName();
            long sizeInKb = MAX_IMAGE_FILE_SIZE + 1L;
            try {
                String rcPath = file.getFilePath().getBody().substring(moduleName.length() + 3);
                String fileUrl = bModule.getResource(rcPath).toString();
                fileUrl = fileUrl.substring(4, fileUrl.indexOf(33));
                File imgfile = new File(new URL(fileUrl).toURI());
                sizeInKb = imgfile.length() / 1024L;
            }
            catch (Exception rcPath) {
                // empty catch block
            }
            if (sizeInKb > MAX_IMAGE_FILE_SIZE || !localStation) {
                boolean remoteModuleExists = false;
                Version version = null;
                if (!offlineStation) {
                    version = (Version)((BFoxSession)pxFileSpace.getSession()).fw(404, (Object)moduleName, null, null, null);
                }
                if (version == null) {
                    if (this.remoteModuleExists(moduleName, pxFileSpace)) {
                        remoteModuleExists = true;
                    }
                } else if (!version.isNull()) {
                    remoteModuleExists = true;
                }
                if (!remoteModuleExists || localStation && !offlineStation) {
                    FilePath filePath = new FilePath("^px/" + file.getFilePath().getBody().substring(2));
                    try {
                        ord = BOrd.make((OrdQuery)filePath);
                        ord.resolve((BObject)pxFileSpace).get();
                    }
                    catch (UnresolvedException ue) {
                        try {
                            OutputStream os;
                            BIFile imgFile;
                            if (offlineStation) {
                                imgFile = pxFileSpace.makeFile(filePath, null);
                                os = imgFile.getOutputStream();
                            } else {
                                imgFile = pxFileSpace.makeFile(filePath, null);
                                os = ((BFoxFileSpace)pxFileSpace).channel().write((BFoxFileStore)imgFile.getStore());
                            }
                            if (os == null) {
                                throw new Exception("Cannot open output stream to: " + new FilePath("^px/" + moduleName + file.getFilePath().getBody()));
                            }
                            BProgressDialog.open((BWidget)editor, (String)this.LEX.getText("ImageFileFactory.trasferingImageFile"), (BProgressDialog.Worker)new ImageTransferWorker(file.getFileName() + " (" + file.getSize() / 1024L + "kB)", file.getInputStream(), os), (BImage)BImage.make((String)this.LEX.getText("ImageFileFactory.trasferingImageFile.icon")));
                            os.flush();
                            os.close();
                            BImage.make((BOrd)imgFile.getAbsoluteOrd()).sync();
                        }
                        catch (Exception ioe) {
                            BDialog.error((BWidget)editor, (String)"Error", (Object)ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                }
            }
        }
        return ord;
    }

    public void convertImages(BComplex c) {
        for (Property p : c.getPropertiesArray()) {
            BSimple defaultValue;
            BSimple[] values;
            BNumericToSimpleMap map;
            if (p.getType().is(BImage.TYPE) || c.get(p) instanceof BImage) {
                BImage img = (BImage)c.get(p);
                if (img.isNull()) continue;
                BImage newImage = this.convertImage(img);
                c.set(p, (BValue)newImage);
                continue;
            }
            if (p.getType().is(BNumericToSimpleMap.TYPE)) {
                map = (BNumericToSimpleMap)c.get(p);
                values = map.getValues();
                for (int ixValues = 0; ixValues < values.length; ++ixValues) {
                    if (!(values[ixValues] instanceof BImage)) continue;
                    values[ixValues] = this.convertImage((BImage)values[ixValues]);
                }
                defaultValue = map.getDefault();
                if (defaultValue instanceof BImage) {
                    defaultValue = this.convertImage((BImage)map.getDefault());
                }
                c.set(p, (BValue)BNumericToSimpleMap.make((double[])map.getMinimums(), (double[])map.getMaximums(), (BSimple[])values, (BSimple)defaultValue));
                continue;
            }
            if (p.getType().is(BEnumToSimpleMap.TYPE)) {
                map = (BEnumToSimpleMap)c.get(p);
                values = map.getValues();
                for (int ixValues = 0; ixValues < values.length; ++ixValues) {
                    if (!(values[ixValues] instanceof BImage)) continue;
                    values[ixValues] = this.convertImage((BImage)values[ixValues]);
                }
                defaultValue = map.getDefault();
                if (defaultValue instanceof BImage) {
                    defaultValue = this.convertImage((BImage)map.getDefault());
                }
                c.set(p, (BValue)BEnumToSimpleMap.make((int[][])map.getOrdinals(), (BSimple[])values, (BSimple)defaultValue));
                continue;
            }
            if (!p.getType().is(BComplex.TYPE)) continue;
            this.convertImages(c.get(p).asComplex());
        }
    }

    public BImage convertImage(BImage currentImg) {
        BOrdList ordlist = currentImg.getOrdList();
        BOrd[] newOrds = new BOrd[ordlist.size()];
        for (int ixOrd = 0; ixOrd < ordlist.size(); ++ixOrd) {
            newOrds[ixOrd] = this.convertImageOrd(ordlist.get(ixOrd));
        }
        BImage newImg = BImage.make((BOrdList)BOrdList.make((BOrd[])newOrds));
        newImg.setBaseOrd(this.getPxEditor().getWbShell().getActiveOrd());
        newImg.sync();
        return newImg;
    }

    private boolean remoteModuleExists(String moduleName, BFileSpace base) {
        try {
            BSpy spy = (BSpy)BOrd.make((String)("spy:/nav/localhost/modules/" + moduleName)).resolve((BObject)base).get();
            return !NOT_FOUND.equals(spy.get().getTitle());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    class ImageTransferWorker
    extends BProgressDialog.Worker {
        String fileName;
        InputStream is;
        OutputStream os;

        ImageTransferWorker(String fileName, InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
            this.fileName = fileName;
        }

        public void doRun() throws Exception {
            this.getDialog().getProgressBar().setIndeterminate(true);
            this.updateProgress(this.fileName);
            BajaFileUtil.pipe((InputStream)this.is, (OutputStream)this.os);
        }

        public void doCancel() throws Exception {
            throw new Exception("Cannot Cancel");
        }
    }
}

