/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.px.editor.BPxEditorPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.px.editor.BPxEditor;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.px.BLayerStatus;
import javax.baja.ui.px.BLayerTag;
import javax.baja.ui.px.PxLayer;

public class LayerManager {
    private BPxEditor editor;
    private BPxEditorPane editorPane;

    public LayerManager(BPxEditor editor, BPxEditorPane editorPane) {
        this.editor = editor;
        this.editorPane = editorPane;
    }

    public void insert(int index, PxLayer layer, CommandArtifact removeTags) {
        if (layer.getName().length() == 0) {
            throw new IllegalArgumentException("Layer name must be defined.");
        }
        ArrayList<PxLayer> arr = new ArrayList<PxLayer>(Arrays.asList(this.editor.getPxLayers()));
        arr.add(index, layer);
        this.editor.setPxLayers(arr.toArray(new PxLayer[0]));
        if (removeTags != null) {
            try {
                removeTags.undo();
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    public CommandArtifact remove(BPxEditorPane editorPane, PxLayer layer) {
        ArrayList<PxLayer> arr = new ArrayList<PxLayer>(Arrays.asList(this.editor.getPxLayers()));
        arr.remove(layer);
        this.editor.setPxLayers(arr.toArray(new PxLayer[0]));
        RemoveTagsArtifact artifact = new RemoveTagsArtifact(layer);
        try {
            artifact.redo();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return artifact;
    }

    public PxLayer getLayerByName(String name) {
        if (name.equals("")) {
            return null;
        }
        PxLayer[] layers = this.editor.getPxLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (!name.equals(layers[i].getName())) continue;
            return layers[i];
        }
        return null;
    }

    public BLayerTag getTag(BWidget widget) {
        SlotCursor cursor = widget.getProperties();
        while (cursor.next()) {
            BValue value = widget.get(cursor.property());
            if (!(value instanceof BLayerTag)) continue;
            return (BLayerTag)value;
        }
        return BLayerTag.NULL;
    }

    public BLayerTag getCommonTag(BWidget[] widgets) {
        if (widgets.length == 0) {
            return BLayerTag.NULL;
        }
        BLayerTag common = this.getTag(widgets[0]);
        for (int i = 1; i < widgets.length; ++i) {
            BLayerTag tag = this.getTag(widgets[i]);
            if (common == null && tag != null) {
                return BLayerTag.NULL;
            }
            if (common != null && tag == null) {
                return BLayerTag.NULL;
            }
            if (common == null && tag == null || common.getLayerName().equals(tag.getLayerName())) continue;
            return BLayerTag.NULL;
        }
        return common;
    }

    public BWidget[] getLayerWidgets(PxLayer layer) {
        ArrayList<BWidget> array = new ArrayList<BWidget>();
        this.doGetWidgets(layer, (BWidget)this.editorPane.getRootContainer(), array);
        return array.toArray(new BWidget[0]);
    }

    public void renameLayerTag(String fromName, String toName) {
        if (toName.length() == 0) {
            throw new IllegalArgumentException("Layer name must be defined.");
        }
        this.doRenameLayerTag(fromName, toName, (BWidget)this.editorPane.getRootContainer());
    }

    public boolean allNormal(BWidget[] widgets) {
        if (widgets == null) {
            return true;
        }
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i] == null || this.isNormal(widgets[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isNormal(BWidget widget) {
        BLayerTag tag = this.getTag(widget);
        if (tag.isNull()) {
            return true;
        }
        PxLayer layer = this.getLayerByName(tag.getLayerName());
        return layer.getStatus().equals((Object)BLayerStatus.normal);
    }

    public BWidget[] trimToNormal(BWidget[] widgets) {
        ArrayList<BWidget> arr = new ArrayList<BWidget>();
        for (int i = 0; i < widgets.length; ++i) {
            if (!this.isNormal(widgets[i])) continue;
            arr.add(widgets[i]);
        }
        if (arr.size() == 0) {
            return null;
        }
        return arr.toArray(new BWidget[0]);
    }

    public void adjustInvisibleWidgets(boolean visible) {
        PxLayer[] layers = this.editor.getPxLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].getStatus().equals((Object)BLayerStatus.invisible)) continue;
            this.doAdjustVisibility(layers[i].getName(), visible, (BWidget)this.editorPane.getRootContainer());
        }
    }

    public void addTag(BWidget widget, PxLayer layer) {
        widget.add(null, (BValue)new BLayerTag(layer.getName()));
        if (layer.getStatus().equals((Object)BLayerStatus.invisible)) {
            widget.setVisible(false);
        }
    }

    public void removeTag(BWidget widget) {
        SlotCursor cursor = widget.getProperties();
        while (cursor.next()) {
            BValue value = widget.get(cursor.property());
            if (!(value instanceof BLayerTag)) continue;
            BLayerTag tag = (BLayerTag)value;
            PxLayer layer = this.getLayerByName(tag.getLayerName());
            if (layer != null && layer.getStatus().equals((Object)BLayerStatus.invisible)) {
                widget.setVisible(true);
            }
            widget.remove(cursor.property());
            break;
        }
    }

    public void setLayerStatus(PxLayer layer, BLayerStatus newStatus) {
        BLayerStatus oldStatus = layer.getStatus();
        if (!oldStatus.equals((Object)newStatus)) {
            layer.setStatus(newStatus);
            if (oldStatus.equals((Object)BLayerStatus.invisible)) {
                this.doAdjustVisibility(layer.getName(), true, (BWidget)this.editorPane.getRootContainer());
            } else if (newStatus.equals((Object)BLayerStatus.invisible)) {
                this.doAdjustVisibility(layer.getName(), false, (BWidget)this.editorPane.getRootContainer());
            }
        }
    }

    public void stripMissingLayer(BWidget widget) {
        BLayerTag tag = this.getTag(widget);
        if (tag == null) {
            return;
        }
        String name = tag.getLayerName();
        if (name.equals("")) {
            return;
        }
        PxLayer[] layers = this.editor.getPxLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (!name.equals(layers[i].getName())) continue;
            return;
        }
        SlotCursor cursor = widget.getProperties();
        while (cursor.next()) {
            BValue value = widget.get(cursor.property());
            if (!(value instanceof BLayerTag)) continue;
            widget.remove(cursor.property());
            break;
        }
    }

    private void doAdjustVisibility(String layerName, boolean visible, BWidget widget) {
        BLayerTag tag = this.getTag(widget);
        if (tag != null && tag.getLayerName().equals(layerName)) {
            widget.setVisible(visible);
        }
        BWidget[] kids = widget.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            this.doAdjustVisibility(layerName, visible, kids[i]);
        }
    }

    private void doRenameLayerTag(String fromName, String toName, BWidget widget) {
        BLayerTag tag = this.getTag(widget);
        if (tag != null && tag.getLayerName().equals(fromName)) {
            tag.setLayerName(toName);
        }
        BWidget[] kids = widget.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            this.doRenameLayerTag(fromName, toName, kids[i]);
        }
    }

    private void doGetWidgets(PxLayer layer, BWidget widget, List<BWidget> array) {
        BLayerTag tag = this.getTag(widget);
        if (tag != null && tag.getLayerName().equals(layer.getName())) {
            array.add(widget);
        }
        BWidget[] kids = widget.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            this.doGetWidgets(layer, kids[i], array);
        }
    }

    public class RemoveTagsArtifact
    implements CommandArtifact {
        private PxLayer layer;
        private BWidget[] widgets;

        private RemoveTagsArtifact(PxLayer layer) {
            this.layer = layer;
            this.widgets = LayerManager.this.getLayerWidgets(layer);
        }

        public void redo() throws Exception {
            for (int i = 0; i < this.widgets.length; ++i) {
                LayerManager.this.removeTag(this.widgets[i]);
            }
        }

        public void undo() throws Exception {
            for (int i = 0; i < this.widgets.length; ++i) {
                LayerManager.this.addTag(this.widgets[i], this.layer);
            }
        }
    }
}

