/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class MoveTo
extends SegmentArtisan {
    @Override
    public Point point(Point pen, IPathGeom.Segment seg) {
        IPathGeom.MoveTo n = (IPathGeom.MoveTo)seg;
        return new Point(n.getX(), n.getY());
    }

    @Override
    public IPathGeom.Segment move(Point pen, IPathGeom.Segment seg, double dx, double dy) {
        if (seg.isRelative()) {
            return seg;
        }
        IPathGeom.MoveTo mv = (IPathGeom.MoveTo)seg;
        return new IPathGeom.MoveTo(mv.isAbsolute(), mv.getX() + dx, mv.getY() + dy);
    }

    @Override
    public Point paintBars(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.MoveTo mv = (IPathGeom.MoveTo)seg;
        if (!mv.isAbsolute()) {
            throw new IllegalStateException();
        }
        Point next = new Point(mv.getX(), mv.getY());
        return next;
    }

    @Override
    public Point paintHandles(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.MoveTo mv = (IPathGeom.MoveTo)seg;
        if (!mv.isAbsolute()) {
            throw new IllegalStateException();
        }
        Point next = new Point(mv.getX(), mv.getY());
        MoveTo.paintHandle(g, studio, path, next, BColor.lime);
        return next;
    }

    @Override
    public Point addHandles(TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg, int idx, PointMap map) {
        IPathGeom.MoveTo mv = (IPathGeom.MoveTo)seg;
        if (!mv.isAbsolute()) {
            throw new IllegalStateException();
        }
        Point next = new Point(mv.getX(), mv.getY());
        MoveTo.addHandle(studio, path, next, map, MouseCursor.move, new MoveToRole(next, idx));
        return next;
    }

    static class MoveToRole
    extends Role {
        MoveToRole(Point orig, int idx) {
            super(orig, idx);
        }

        @Override
        public IPathGeom.Segment apply(double dx, double dy) {
            return new IPathGeom.MoveTo(true, this.orig.x + dx, this.orig.y + dy);
        }
    }
}

