/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.fieldeditors;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.celltable.BCellTable;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.baja.converters.BEnumToSimpleMap;
import javax.baja.converters.BIEnumToSimple;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.celleditor.BWbCellEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BIEnumToSimpleFE
extends BWbFieldEditor {
    public static final Action tableSelectionModified = BIEnumToSimpleFE.newAction((int)0, null);
    public static final Action defaultModified = BIEnumToSimpleFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BIEnumToSimpleFE.class);
    static BFont FONT = Theme.widget().getTextFont();
    BTable table = new BTable();
    BSimple defaultValue;
    BCellTable defTable;
    BWbCellEditor defaultCE;
    Type prototype;
    int[] rangeOrdinals;
    String[] rangeTags;
    BSimple[] rangeValues;
    BButton btnSetValues;
    BButton btnClearValues;

    public void tableSelectionModified() {
        this.invoke(tableSelectionModified, null, null);
    }

    public void defaultModified() {
        this.invoke(defaultModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIEnumToSimpleFE() {
        this.table.setModel((TableModel)new Model());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.table.setController((TableController)new Controller());
        this.table.setGridBrush(Theme.widget().getControlShadow());
        this.table.setHscrollBarVisible(false);
        this.table.setVscrollBarVisible(false);
        this.defTable = new BCellTable(new String[]{BIEnumToSimpleFE.text("fieldeditors.default")}, new double[]{75.0});
        this.defTable.setOptionsButtonVisible(false);
        this.btnSetValues = new BButton((Command)new SetValues((BWidget)this));
        this.btnClearValues = new BButton((Command)new ClearValues((BWidget)this));
        this.btnSetValues.setEnabled(false);
        this.btnClearValues.setEnabled(false);
        BGridPane grid = new BGridPane(2);
        grid.setHalign(BHalign.left);
        grid.setValign(BValign.bottom);
        grid.add(null, (BValue)this.btnSetValues);
        grid.add(null, (BValue)this.btnClearValues);
        BEdgePane e1 = new BEdgePane();
        e1.setCenter((BWidget)this.table);
        e1.setBottom((BWidget)new BBorderPane((BWidget)grid, 3.0, 0.0, 0.0, 0.0));
        BEdgePane e2 = new BEdgePane();
        e2.setCenter((BWidget)e1);
        e2.setBottom((BWidget)new BBorderPane((BWidget)this.defTable, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)e2);
        this.linkTo(null, (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)tableSelectionModified);
        this.linkTo(null, (BComponent)this.defTable, (Slot)BCellTable.modified, (Slot)defaultModified);
    }

    public void doTableSelectionModified() {
        int[] sel = this.table.getSelection().getRows();
        this.btnSetValues.setEnabled(sel.length > 0);
        this.btnClearValues.setEnabled(sel.length > 0);
    }

    public void doDefaultModified() {
        this.setModified();
    }

    protected void doLoadValue(BObject loadValue, Context cx) {
        BFacets facets = cx.getFacets();
        BIEnumToSimple conv = (BIEnumToSimple)loadValue;
        BEnumToSimpleMap map = conv.getMap();
        BEnumRange range = (BEnumRange)facets.get("range");
        this.rangeOrdinals = range == null ? new int[0] : range.getOrdinals();
        this.rangeTags = new String[this.rangeOrdinals.length];
        for (int i = 0; i < this.rangeOrdinals.length; ++i) {
            this.rangeTags[i] = range.getTag(this.rangeOrdinals[i]);
        }
        BSimple[] values = map.getValues();
        int[][] ordinals = map.getOrdinals();
        this.rangeValues = new BSimple[this.rangeOrdinals.length];
        for (int i = 0; i < values.length; ++i) {
            int j;
            HashSet<Integer> set = new HashSet<Integer>();
            for (j = 0; j < ordinals[i].length; ++j) {
                set.add(new Integer(ordinals[i][j]));
            }
            for (j = 0; j < this.rangeOrdinals.length; ++j) {
                if (!set.contains(new Integer(this.rangeOrdinals[j]))) continue;
                this.rangeValues[j] = values[i];
            }
        }
        this.defaultValue = map.getDefault();
        if (this.defaultValue == null) {
            if (values.length == 0) {
                throw new IllegalStateException();
            }
            this.prototype = values[0].getType();
            this.defaultValue = (BSimple)this.prototype.getInstance();
        } else {
            this.prototype = this.defaultValue.getType();
        }
        this.defaultCE = BWbCellEditor.makeFor((BObject)this.defaultValue);
        this.defaultCE.loadValue((BObject)this.defaultValue);
        this.defTable.clearRows();
        this.defTable.addRow(new BWbCellEditor[]{this.defaultCE});
        this.relayout();
    }

    protected BObject doSaveValue(BObject saveValue, Context cx) {
        try {
            BIEnumToSimple conv = (BIEnumToSimple)saveValue;
            BSimple def = (BSimple)this.defaultCE.saveValue();
            HashMap<BSimple, ArrayList<Integer>> map = new HashMap<BSimple, ArrayList<Integer>>();
            for (int i = 0; i < this.rangeValues.length; ++i) {
                BSimple val = this.rangeValues[i];
                if (val == null) continue;
                ArrayList<Integer> arr = (ArrayList<Integer>)map.get(val);
                if (arr == null) {
                    arr = new ArrayList<Integer>();
                    map.put(val, arr);
                }
                arr.add(new Integer(this.rangeOrdinals[i]));
            }
            int[][] ordinals = new int[map.size()][];
            BSimple[] values = new BSimple[map.size()];
            int n = 0;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                BSimple key;
                values[n] = key = (BSimple)iterator.next();
                List arr = (List)map.get(values[n]);
                ordinals[n] = new int[arr.size()];
                for (int i = 0; i < arr.size(); ++i) {
                    ordinals[n][i] = (Integer)arr.get(i);
                }
                ++n;
            }
            conv.setMap(BEnumToSimpleMap.make((int[][])ordinals, (BSimple[])values, (BSimple)def));
            return saveValue;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    static String text(String s) {
        return BPxEditorPane.text(s);
    }

    class ClearValues
    extends Command {
        ClearValues(BWidget owner) {
            super(owner, BPxEditorPane.lexicon(), "iEnumToSimpleFE.clearValues");
        }

        public CommandArtifact doInvoke() {
            int[] sel = BIEnumToSimpleFE.this.table.getSelection().getRows();
            if (sel.length == 0) {
                throw new IllegalStateException("No rows were selected.");
            }
            for (int i = 0; i < sel.length; ++i) {
                BIEnumToSimpleFE.this.rangeValues[sel[i]] = null;
            }
            BIEnumToSimpleFE.this.setModified();
            BIEnumToSimpleFE.this.repaint();
            return null;
        }
    }

    class SetValues
    extends Command {
        SetValues(BWidget owner) {
            super(owner, BPxEditorPane.lexicon(), "iEnumToSimpleFE.setValues");
        }

        public CommandArtifact doInvoke() {
            int[] sel = BIEnumToSimpleFE.this.table.getSelection().getRows();
            if (sel.length == 0) {
                throw new IllegalStateException("No rows were selected.");
            }
            BSimple oldVal = BIEnumToSimpleFE.this.defaultValue;
            for (int i = 0; i < sel.length; ++i) {
                if (BIEnumToSimpleFE.this.rangeValues[sel[i]] == null) continue;
                oldVal = BIEnumToSimpleFE.this.rangeValues[sel[i]];
                break;
            }
            try {
                BValue newVal = (BValue)BWbFieldEditor.dialog((BWidget)BIEnumToSimpleFE.this, (String)BIEnumToSimpleFE.text("fieldeditors.value"), (BObject)oldVal, null);
                if (newVal != null) {
                    for (int i = 0; i < sel.length; ++i) {
                        BIEnumToSimpleFE.this.rangeValues[sel[i]] = (BSimple)newVal;
                    }
                    BIEnumToSimpleFE.this.setModified();
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            BIEnumToSimpleFE.this.repaint();
            return null;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            menu.keep(new String[]{"resizeColumns"});
            return menu;
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BSimple oldVal = BIEnumToSimpleFE.this.defaultValue;
            if (BIEnumToSimpleFE.this.rangeValues[row] != null) {
                oldVal = BIEnumToSimpleFE.this.rangeValues[row];
            }
            try {
                BValue newVal = (BValue)BWbFieldEditor.dialog((BWidget)BIEnumToSimpleFE.this, (String)BIEnumToSimpleFE.text("fieldeditors.value"), (BObject)oldVal, null);
                if (newVal != null) {
                    BIEnumToSimpleFE.this.rangeValues[row] = (BSimple)newVal;
                    BIEnumToSimpleFE.this.setModified();
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.column == 2 && BIEnumToSimpleFE.this.rangeValues[cell.row] != null && BIEnumToSimpleFE.this.rangeValues[cell.row] instanceof BBrush) {
                BBrush brush = (BBrush)BIEnumToSimpleFE.this.rangeValues[cell.row];
                double bw = cell.height;
                double bh = cell.height - 4.0;
                BImage bg = BBrushSwatch.createBackground((double)bw, (double)bh);
                g.drawImage(bg, 2.0, 2.0);
                if (!brush.isNull()) {
                    g.setBrush(brush);
                    g.fillRect(2.0, 2.0, bw - 1.0, bh - 1.0);
                }
                g.setBrush(BColor.black);
                g.strokeRect(2.0, 2.0, bw - 1.0, bh - 1.0);
                String text = "";
                BBrush.Paint paint = brush.getPaint();
                if (paint instanceof BBrush.Solid) {
                    text = ((BBrush.Solid)paint).getColor().toString();
                } else if (paint instanceof BBrush.Gradient) {
                    text = "(gradient)";
                } else if (paint instanceof BBrush.Image) {
                    text = "(image)";
                }
                g.setBrush(Theme.widget().getControlForeground());
                g.setFont(FONT);
                g.drawString(text, bw + 6.0, FONT.getAscent() + 2.0);
            } else {
                super.paintCell(g, cell);
            }
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return cell.column == 2 ? this.getForeground(cell) : super.getSelectionForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return cell.column == 2 ? this.getBackground(cell) : super.getSelectionBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (cell.column == 2) {
                return 100.0;
            }
            return super.getPreferredCellWidth(cell);
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BIEnumToSimpleFE.this.rangeOrdinals.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BIEnumToSimpleFE.text("iEnumToSimpleFE.ordinal");
                }
                case 1: {
                    return BIEnumToSimpleFE.text("iEnumToSimpleFE.name");
                }
                case 2: {
                    return BIEnumToSimpleFE.text("fieldeditors.value");
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return Integer.toString(BIEnumToSimpleFE.this.rangeOrdinals[row]);
                }
                case 1: {
                    return BIEnumToSimpleFE.this.rangeTags[row];
                }
                case 2: {
                    return BIEnumToSimpleFE.this.rangeValues[row] == null ? "" : BIEnumToSimpleFE.this.rangeValues[row].toString();
                }
            }
            throw new IllegalStateException();
        }
    }
}

