/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor;

import com.tridium.px.editor.BPxEditorOptions;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.TypeInfoSpec;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileScheme;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.xml.XWriter;

public class BNewPxViewDialog
extends BEdgePane {
    public static final Action viewNameChanged = BNewPxViewDialog.newAction((int)0, null);
    public static final Action fileNameChanged = BNewPxViewDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNewPxViewDialog.class);
    static Lexicon lex = Lexicon.make((String)"pxEditor");
    static final BImage headerIcon = BPxEditorPane.icon("newPxView.iconHeader");
    static final BImage browseIcon = BPxEditorPane.icon("newPxView.iconBrowse");
    static final String lexBrowse = BPxEditorPane.text("newPxView.browse");
    static final String lexCancel = BPxEditorPane.text("newPxView.cancel");
    static final String lexDescription = BPxEditorPane.text("newPxView.description");
    static final String lexExporter = BPxEditorPane.text("newPxView.dynamic");
    static final String lexFileAlreadyExists = BPxEditorPane.text("newPxView.fileAlreadyExists");
    static final String lexMedia = BPxEditorPane.text("newPxView.media");
    static final String lexOverwrite = BPxEditorPane.text("newPxView.overwrite");
    static final String lexPxFile = BPxEditorPane.text("newPxView.pxFile");
    static final String lexSource = BPxEditorPane.text("newPxView.source");
    static final String lexReuse = BPxEditorPane.text("newPxView.reuse");
    static final String lexReuseOrOverwrite = BPxEditorPane.text("newPxView.reuseOrOverwrite");
    static final String lexSaveError = BPxEditorPane.text("newPxView.saveError");
    static final String lexTitle = BPxEditorPane.text("newPxView.title");
    static final String lexViewIcon = BPxEditorPane.text("newPxView.viewIcon");
    static final String lexViewName = BPxEditorPane.text("newPxView.viewName");
    static BFileChooser openChooser;
    static BFileChooser saveChooser;
    BComponent component;
    BWidget owner;
    BDialog existingDialog;
    boolean reuse = false;
    boolean overwrite = false;
    boolean cancelled = false;
    BMruTextDropDown name;
    BWbFieldEditor icon;
    BListDropDown media;
    FilePath currentDirFilePath = null;
    boolean useFile;
    BMruTextDropDown file;
    BButton browse;
    BTextDropDown dynamic;
    TypeInfo[] dynamicTypes;
    BPxEditorOptions pxEditorOptions;

    public void viewNameChanged() {
        this.invoke(viewNameChanged, null, null);
    }

    public void fileNameChanged() {
        this.invoke(fileNameChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static CommandArtifact invoke(BWidget owner, BComponent component) throws Exception {
        BNewPxViewDialog dialog = new BNewPxViewDialog(component);
        dialog.owner = owner;
        String pxViewName = null;
        do {
            int r;
            if ((r = BDialog.open((BWidget)owner, (String)lexTitle, (Object)((Object)dialog), (int)3)) == 1) continue;
            return null;
        } while ((pxViewName = dialog.save()) == null);
        String view = "view:" + pxViewName;
        if (!dialog.reuse && dialog.useFile) {
            view = view + "/editor";
        }
        BWbShell shell = (BWbShell)owner.getShell();
        shell.hyperlink(BOrd.make((BOrd)component.getNavOrd(), (String)view));
        return null;
    }

    public BNewPxViewDialog(BComponent component) {
        this.component = component;
        this.name = this.buildName();
        this.icon = this.buildIcon();
        this.pxEditorOptions = BPxEditorOptions.make();
        this.media = this.buildMedia();
        ToggleCommand cmdPxFile = new ToggleCommand((BWidget)this, lexPxFile){

            public CommandArtifact doInvoke() throws Exception {
                if (this.isSelected()) {
                    BNewPxViewDialog.this.useFile = true;
                    BNewPxViewDialog.this.file.setEnabled(true);
                    BNewPxViewDialog.this.dynamic.setEnabled(false);
                }
                return null;
            }
        };
        ToggleCommand cmdDynamic = new ToggleCommand((BWidget)this, lexExporter){

            public CommandArtifact doInvoke() throws Exception {
                if (this.isSelected()) {
                    BNewPxViewDialog.this.useFile = false;
                    BNewPxViewDialog.this.file.setEnabled(false);
                    BNewPxViewDialog.this.dynamic.setEnabled(true);
                }
                return null;
            }
        };
        ToggleCommandGroup grp = new ToggleCommandGroup();
        grp.add(cmdPxFile);
        grp.add(cmdDynamic);
        BGridPane source = new BGridPane(2);
        source.add(null, (BValue)new BRadioButton(cmdPxFile));
        source.add(null, (BValue)this.buildFile());
        source.add(null, (BValue)new BRadioButton(cmdDynamic));
        source.add(null, (BValue)this.buildDynamic());
        this.useFile = true;
        this.file.setEnabled(true);
        this.dynamic.setEnabled(false);
        BGridPane pairs = new BGridPane(2);
        pairs.setColumnGap(10.0);
        pairs.add(null, (BValue)new BLabel(lexViewName));
        pairs.add(null, (BValue)this.name);
        pairs.add(null, (BValue)new BLabel(lexViewIcon));
        pairs.add(null, (BValue)this.icon);
        pairs.add(null, (BValue)new BLabel(lexMedia));
        pairs.add(null, (BValue)this.media);
        pairs.add(null, (BValue)new BLabel(lexSource));
        pairs.add(null, (BValue)source);
        this.setTop((BWidget)new BWizardHeader(headerIcon, lexTitle, lexDescription));
        this.setCenter((BWidget)new BBorderPane((BWidget)pairs));
        this.linkTo((BComponent)this.name.getEditor(), (Slot)BTextEditor.textModified, (Slot)viewNameChanged);
        this.linkTo((BComponent)this.file.getEditor(), (Slot)BTextEditor.textModified, (Slot)fileNameChanged);
    }

    public BMruTextDropDown buildName() {
        BMruTextDropDown field = new BMruTextDropDown("newPxViewName", 20);
        String name = field.getText();
        if (name.length() == 0) {
            name = "Graphic";
        }
        name = CompToComp.getUniqueName((BComponent)this.component, (String)name);
        field.setText(name);
        return field;
    }

    public BWbFieldEditor buildIcon() {
        BIcon icon = new BPxView().getIcon();
        BWbFieldEditor field = BWbFieldEditor.makeFor((BObject)icon);
        field.loadValue((BObject)icon);
        return field;
    }

    public BListDropDown buildMedia() {
        BListDropDown field = new BListDropDown();
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BPxMedia.TYPE.getTypeInfo());
        int def = 0;
        for (int i = 0; i < types.length; ++i) {
            TypeInfoSpec m = new TypeInfoSpec(types[i]);
            if (m.info.getTypeName().equals(this.pxEditorOptions.getPxMediaTypeName())) {
                def = i;
            }
            field.getList().addItem(m.icon, (Object)m);
        }
        field.setSelectedIndex(def);
        return field;
    }

    public BWidget buildFile() {
        this.file = this.buildMru("pxViewFile");
        this.browse = new BButton((Command)new ReflectCommand((BWidget)this, null, browseIcon, "browse"));
        this.browse.setButtonStyle(BButtonStyle.toolBar);
        BGridPane a = new BGridPane(2);
        a.add(null, (BValue)this.file);
        a.add(null, (BValue)this.browse);
        return a;
    }

    public BWidget buildDynamic() {
        this.dynamicTypes = Sys.getRegistry().getConcreteTypes(BDynamicPxView.TYPE.getTypeInfo());
        this.dynamic = new BTextDropDown(new ArrayList<TypeInfo>(Arrays.asList(this.dynamicTypes)), 40, false);
        return this.dynamic;
    }

    public BMruTextDropDown buildMru(String mru) {
        BMruTextDropDown field = new BMruTextDropDown(mru, 60);
        FilePath filePath = null;
        String last = field.getText();
        if (last.length() > 0) {
            try {
                int slash = last.lastIndexOf(47);
                BOrd.make((String)last.substring(0, slash)).get((BObject)this.component);
                filePath = this.stringToFilePath(last.substring(0, slash));
            }
            catch (Exception slash) {
                // empty catch block
            }
        }
        if (filePath == null || !last.startsWith("file:^")) {
            try {
                BDirectory dir;
                try {
                    dir = (BDirectory)BOrd.make((String)"file:^").get((BObject)this.component);
                }
                catch (UnresolvedException e) {
                    dir = (BDirectory)BOrd.make((String)"file:^^").get((BObject)this.component);
                    dir = dir.getFileSpace().makeDir(dir.getFilePath().merge("shared"));
                }
                dir.getFileSpace().makeDir(dir.getFilePath().merge("px"));
                filePath = new FilePath("^").merge("px");
            }
            catch (Exception dir) {
                // empty catch block
            }
        }
        if (filePath == null) {
            BDirectory dir = BFileSystem.INSTANCE.getSysHome();
            try {
                filePath = dir.getFileSpace().makeDir(dir.getFilePath().merge("px")).getFilePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentDirFilePath = filePath;
        String filename = this.name.getText() + ".px";
        if (filename.length() > 3 && FilePath.isValidName((String)filename)) {
            field.setText(filePath.merge(filename).toString());
        }
        return field;
    }

    public String save() throws Exception {
        String slotName = SlotPath.escape((String)this.name.getTextAndSave());
        if (this.component.get(slotName) != null) {
            String text = lex.getText("newPxView.slotAlreadyExists", new Object[]{slotName});
            BDialog.error((BWidget)this.owner, (Object)text);
            return null;
        }
        TypeInfoSpec m = (TypeInfoSpec)this.media.getSelectedItem();
        BPxView view = null;
        if (this.useFile) {
            view = new BPxView();
            BOrd ord = this.saveFile(m);
            view.setPxFile(ord);
        } else {
            int n = this.dynamic.getList().getSelectedIndex();
            view = (BDynamicPxView)this.dynamicTypes[n].getInstance();
        }
        view.setIcon((BIcon)this.icon.saveValue());
        view.setMedia(m.info.getTypeSpec());
        String selectedMediaTypeName = m.info.getTypeName();
        if (!selectedMediaTypeName.equals(this.pxEditorOptions.getPxMediaTypeName())) {
            this.pxEditorOptions.setPxMediaTypeName(selectedMediaTypeName);
            this.pxEditorOptions.save();
        }
        this.component.add(slotName, (BValue)view, 256);
        this.component.lease();
        return slotName;
    }

    private BOrd saveFile(TypeInfoSpec m) throws Exception {
        BOrd ord = BOrd.make((String)this.file.getText());
        try {
            BIFile f = (BIFile)ord.resolve((BObject)this.component).get();
            this.existingDialog = this.makeExistingDialog();
            this.existingDialog.setBoundsCenteredOnOwner();
            this.existingDialog.open();
            if (this.cancelled) {
                return null;
            }
            if (this.overwrite) {
                this.writeNewFile(f, m.info);
            }
        }
        catch (UnresolvedException e) {
            this.createNew(ord, m.info);
        }
        catch (SyntaxException e2) {
            String text = lex.getText("newPxView.illegalFilename", new Object[]{this.file.getText()});
            BDialog.error((BWidget)this.owner, (Object)text);
            return null;
        }
        this.file.getTextAndSave();
        return ord;
    }

    BDialog makeExistingDialog() {
        BGridPane actions = new BGridPane(3);
        actions.setUniformColumnWidth(true);
        actions.setColumnAlign(BHalign.fill);
        actions.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, lexReuse, "reuse")));
        actions.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, lexOverwrite, "overwrite")));
        actions.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, lexCancel, "cancel")));
        BLabel desc = new BLabel(lexReuseOrOverwrite);
        desc.setHalign(BHalign.left);
        BGridPane text = new BGridPane(1);
        text.add(null, (BValue)new BLabel(lexFileAlreadyExists, Theme.widget().getBoldText()));
        text.add(null, (BValue)desc);
        BGridPane top = new BGridPane(2);
        top.setColumnGap(10.0);
        top.add(null, (BValue)new BLabel(BImage.make((String)"module://icons/x32/warning.png")));
        top.add(null, (BValue)text);
        BGridPane content = new BGridPane(1);
        content.add(null, (BValue)new BBorderPane((BWidget)top, 0.0, 10.0, 10.0, 10.0));
        content.add(null, (BValue)actions);
        this.reuse = false;
        this.overwrite = false;
        this.cancelled = false;
        return new BDialog(this.owner, lexFileAlreadyExists, true, (BWidget)new BBorderPane((BWidget)content));
    }

    void createNew(BOrd ord, TypeInfo media) throws Exception {
        BIFile file;
        OrdQuery[] q = ord.parse();
        FilePath path = (FilePath)q[q.length - 1];
        q[q.length - 1] = new FilePath(path.getScheme(), path.getAbsoluteBase());
        BOrd rootOrd = BOrd.make((OrdQuery[])q);
        BIFile root = (BIFile)rootOrd.get((BObject)this.component);
        BFileSpace space = root.getFileSpace();
        try {
            file = space.makeFile(path);
        }
        catch (UnresolvedException e) {
            file = space.makeFile(BFileScheme.localizeStationPath((BOrd)this.component.getOrdInHost(), (FilePath)path), null);
        }
        this.writeNewFile(file, media);
    }

    void writeNewFile(BIFile newFile, TypeInfo media) throws Exception {
        try {
            BPxMedia pxMedia = (BPxMedia)media.getTypeSpec().getResolvedType().getInstance();
            BIFile source = (BIFile)pxMedia.getPxFileOrd().get();
            BajaFileUtil.pipe((BIFile)source, (BIFile)newFile);
        }
        catch (UnresolvedException e) {
            XWriter out = new XWriter(newFile.getOutputStream());
            out.prolog();
            out.w((Object)"<px version='1.0' media='").w((Object)media).w((Object)"'>\n");
            out.w((Object)"<import>\n");
            out.w((Object)" <module name='bajaui'/>\n");
            out.w((Object)"</import>\n");
            out.w((Object)"<content>\n");
            out.w((Object)"  <ScrollPane>\n");
            out.w((Object)"    <CanvasPane name=\"content\" viewSize=\"500,400\"/>\n");
            out.w((Object)"  </ScrollPane>\n");
            out.w((Object)"</content>\n");
            out.w((Object)"</px>");
            out.close();
        }
    }

    public void overwrite() {
        this.existingDialog.close();
        this.overwrite = true;
    }

    public void reuse() {
        this.existingDialog.close();
        this.reuse = true;
    }

    public void cancel() {
        this.existingDialog.close();
        this.cancelled = true;
    }

    public void browse() {
        BFileChooser chooser = BFileChooser.makeSave((BWidget)this.owner);
        chooser.setBoundsCenteredOnScreen();
        chooser.setCreateFileOnSave(false);
        chooser.setConfirmOverwrite(false);
        try {
            BOrd ord = BOrd.make((String)this.file.getText());
            OrdQuery[] q = ord.parse();
            FilePath path = (FilePath)q[q.length - 1];
            String name = path.getName();
            q[q.length - 1] = path.getParent();
            BOrd dir = BOrd.make((OrdQuery[])q);
            chooser.setDefaultFileName(name);
            chooser.setCurrentDirectory(BOrd.make((BOrd)this.component.getAbsoluteOrd(), (BOrd)dir));
            BObject obj = BOrd.make((BOrd)this.component.getAbsoluteOrd(), (String)"file:^").get((BObject)this.component);
            BSpace space = BOrd.toSpace((BObject)obj);
            if (space != null) {
                chooser.setSpaces(new BSpace[]{space});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BOrd result = chooser.show();
        if (result != null) {
            result = result.relativizeToSession();
            this.file.setText(result.toString());
        }
    }

    public void doViewNameChanged() {
        String filename = this.name.getText() + ".px";
        if (filename.length() > 3 && FilePath.isValidName((String)filename)) {
            this.file.setText(this.currentDirFilePath.merge(filename).toString());
        }
    }

    public void doFileNameChanged() {
        try {
            this.currentDirFilePath = this.stringToFilePath(this.file.getText()).getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private FilePath stringToFilePath(String fileStr) {
        OrdQuery[] q = BOrd.make((String)fileStr).parse();
        return (FilePath)q[q.length - 1];
    }
}

