/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.portal.api;

import com.tridium.platform.license.BrandProps;
import com.tridium.portal.api.PortalApiException;
import com.tridium.sys.NreLib;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class PortalApi {
    private static BrandProps brandProps;
    public static final String DEFAULT_HOST = "https://axlicensing.tridium.com";
    public static final String DEFAULT_SCHEME = "http";
    public static final int DEFAULT_PORT = -1;
    public static final BModule MODULE;
    public static final Version VERSION;
    public static final String MY_HOST_ID;
    protected static final Logger log;

    private static XElem request(String name, String path) {
        XElem cmd = new XElem(name);
        cmd.addAttr("path", path);
        return cmd;
    }

    public static String getPortalAddress() {
        String addr = brandProps.get("license.server", null);
        if (addr == null) {
            addr = System.getProperty("portal.host", DEFAULT_HOST);
        }
        return addr;
    }

    public static XElem[] getLicenses(String hostId, String brand, Version version) throws Exception {
        XElem req = PortalApi.request("req", "/ws/license/api31/getByHostId");
        XElem params = new XElem("params");
        params.addAttr("hostId", hostId);
        params.addAttr("clientVersion", Sys.getBajaVersion().toString(2));
        if (brand != null) {
            params.addAttr("brand", brand);
        }
        if (version != null) {
            params.addAttr("version", version.toString(2));
        }
        req.addContent((XContent)params);
        XElem resp = PortalApi.post(req);
        XElem[] licenseFileElems = resp.elems("licensefile");
        if (licenseFileElems.length == 0) {
            XElem[] licenses = resp.elems("license");
            if (licenses.length == 0) {
                XElem error = resp.elem("error");
                if (error != null) {
                    throw new PortalApiException(resp.elem("error").get("msg"));
                }
                error = resp.elem("failed");
                if (error != null && !"No license found.".equals(resp.elem("failed").get("cause", ""))) {
                    throw new PortalApiException(resp.elem("failed").get("cause", ""));
                }
                return null;
            }
            licenseFileElems = new XElem[]{new XElem("licensefile")};
            for (XElem license : licenses) {
                resp.removeContent((XContent)license);
                licenseFileElems[0].addContent((XContent)license);
            }
        }
        return licenseFileElems;
    }

    public static XElem[] getLicenseUpdates(XElem[] summaries) throws Exception {
        XElem[] licenseFiles;
        XElem req = PortalApi.request("req", "/ws/license/api31/getUpdates");
        for (XElem summary : summaries) {
            req.addContent((XContent)summary.copy());
        }
        ArrayList licenseUpdates = new ArrayList();
        for (XElem licenseFile : licenseFiles = PortalApi.post(req).elems("licensefile")) {
            XElem[] licenses = licenseFile.elems("license");
            Collections.addAll(licenseUpdates, licenses);
        }
        return licenseUpdates.toArray(new XElem[1]);
    }

    public static XElem[] getCertificateUpdates(XElem[] summaries) throws Exception {
        XElem req = PortalApi.request("req", "/ws/license/api31/getUpdates");
        for (XElem summary : summaries) {
            req.addContent((XContent)summary.copy());
        }
        return PortalApi.post(req).elems("certificate");
    }

    public static XElem[] getCertificates(String hostId) throws Exception {
        return PortalApi.getCertificates(hostId, PortalApi.getLocalBrandId());
    }

    public static XElem[] getCertificates(String hostId, String brand) throws Exception {
        XElem req = PortalApi.request("req", "/ws/license/api31/getCertsByHostId");
        XElem params = new XElem("params");
        params.addAttr("hostId", hostId);
        if (brand != null) {
            params.addAttr("brand", brand);
        }
        req.addContent((XContent)params);
        XElem resp = PortalApi.post(req);
        XElem[] certs = resp.elems("certificate");
        if (certs == null || certs.length == 0) {
            XElem error = resp.elem("error");
            if (error != null) {
                throw new PortalApiException(resp.elem("error").get("msg"));
            }
            return null;
        }
        return certs;
    }

    public static XElem getCertificate(String vendor) throws Exception {
        XElem req = PortalApi.request("req", "/ws/license/api31/getCertByVendor");
        XElem params = new XElem("params");
        params.addAttr("vendor", vendor);
        req.addContent((XContent)params);
        XElem resp = PortalApi.post(req);
        XElem[] certs = resp.elems("certificate");
        if (certs == null || certs.length == 0) {
            XElem error = resp.elem("error");
            if (error != null) {
                throw new PortalApiException(resp.elem("error").get("msg"));
            }
            return null;
        }
        return certs[0];
    }

    public static XElem[] getCertificates(String[] vendors) throws Exception {
        if (vendors == null || vendors.length == 0) {
            return null;
        }
        XElem req = PortalApi.request("req", "/ws/license/api31/getCertsForVendors");
        XElem params = new XElem("params");
        for (String vendor : vendors) {
            XElem vendorElem = new XElem("vendor");
            vendorElem.setAttr("name", vendor);
            params.addContent((XContent)vendorElem);
        }
        req.addContent((XContent)params);
        XElem resp = PortalApi.post(req);
        XElem[] certs = resp.elems("certificate");
        if (certs == null || certs.length == 0) {
            XElem error = resp.elem("error");
            if (error != null) {
                throw new PortalApiException(resp.elem("error").get("msg"));
            }
            return null;
        }
        return certs;
    }

    public static boolean checkConnectivity() {
        try {
            PortalApi.get("/ws/license/api31/ping");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected static XElem get(String uri) throws Exception {
        try {
            return AccessController.doPrivileged(new GetPrivilegedAction(uri));
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    protected static XElem post(XElem req) throws Exception {
        try {
            return AccessController.doPrivileged(new PostPrivilegedAction(req));
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static String brandGet(String key, String def) {
        return brandProps.get(key, def);
    }

    public static boolean brandGet(String key, boolean def) {
        return brandProps.get(key, def ? "true" : "false").equals("true");
    }

    public static int brandGet(String key, int def) {
        return Integer.parseInt(brandProps.get(key, Integer.toString(def)));
    }

    public static String[] getBrandKeys() {
        return brandProps.getKeys();
    }

    private static void loadBrand() {
        brandProps = BrandProps.getLocalInstance();
    }

    public static String getLocalBrandId() {
        Feature[] features;
        for (Feature feature : features = Sys.getLicenseManager().getFeatures()) {
            if (!feature.getVendorName().equals("tridium") || !feature.getFeatureName().equals("brand")) continue;
            return feature.get("brandId");
        }
        return brandProps.get("brand.id", null);
    }

    static {
        PortalApi.loadBrand();
        MODULE = Sys.loadModule((String)"portalApi");
        VERSION = BModule.getClassVersion(PortalApi.class);
        MY_HOST_ID = NreLib.getHostId();
        log = Logger.getLogger("portalApi");
    }

    private static class PostPrivilegedAction
    implements PrivilegedExceptionAction<XElem> {
        private final XElem req;

        private PostPrivilegedAction(XElem req) {
            this.req = req;
        }

        @Override
        public XElem run() throws Exception {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Request:");
                this.req.dump();
            }
            String address = PortalApi.getPortalAddress();
            String scheme = PortalApi.DEFAULT_SCHEME;
            int endScheme = address.indexOf("://");
            if (endScheme != -1) {
                scheme = address.substring(0, endScheme);
                address = address.substring(endScheme + 3);
            }
            int port = -1;
            int colon = address.indexOf(58);
            if (colon != -1) {
                port = Integer.parseInt(address.substring(colon + 1));
                address = address.substring(0, colon);
            }
            URL url = new URL(scheme, address, port, this.req.get("path"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Type", "text/xml");
            XWriter xOut = new XWriter(conn.getOutputStream());
            this.req.write(xOut);
            xOut.flush();
            XElem resp = XParser.make((InputStream)conn.getInputStream()).parse(true);
            conn.disconnect();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Response:");
                resp.dump();
            }
            return resp;
        }
    }

    private static class GetPrivilegedAction
    implements PrivilegedExceptionAction<XElem> {
        private final String uri;

        private GetPrivilegedAction(String uri) {
            this.uri = uri;
        }

        @Override
        public XElem run() throws Exception {
            String address = PortalApi.getPortalAddress();
            String scheme = PortalApi.DEFAULT_SCHEME;
            int endScheme = address.indexOf("://");
            if (endScheme != -1) {
                scheme = address.substring(0, endScheme);
                address = address.substring(endScheme + 3);
            }
            int port = -1;
            int colon = address.indexOf(58);
            if (colon != -1) {
                port = Integer.parseInt(address.substring(colon + 1));
                address = address.substring(0, colon);
            }
            URL url = new URL(scheme, address, port, this.uri);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            XElem resp = XParser.make((InputStream)conn.getInputStream()).parse(true);
            conn.disconnect();
            return resp;
        }
    }
}

