/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.datatypes.BExeParam;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"ace:ExeParam"})})
public class BAceExeParamFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BAceExeParamFE.class);
    private BListDropDown level = new BListDropDown();
    private BTextField exeOrder = new BTextField("", 19);
    private static Lexicon lex = Lexicon.make(BAceExeParamFE.class);
    private static final String[] szLevels = new String[]{"1", "2", "3", "4"};

    public Type getType() {
        return TYPE;
    }

    public BAceExeParamFE() {
        BGridPane pane = new BGridPane(5);
        pane.add("levelLabel", (BValue)new BLabel("level"));
        pane.add("level", (BValue)this.level);
        pane.add("space", (BValue)new BLabel("  "));
        pane.add("orderLabel", (BValue)new BLabel("exeOrder"));
        pane.add("order", (BValue)this.exeOrder);
        this.setContent((BWidget)pane);
        BList list = this.level.getList();
        for (int i = 0; i < szLevels.length; ++i) {
            list.addItem((Object)szLevels[i]);
        }
        this.linkTo("lk0", (BComponent)this.level, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.level, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.exeOrder, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.exeOrder, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.level.setEnabled(!readonly);
        this.exeOrder.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BExeParam ep = (BExeParam)value;
        this.level.setSelectedIndex(ep.getLevel());
        this.exeOrder.setText(Integer.toString(ep.getExecOrder()));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int lev = this.level.getSelectedIndex();
        int order = Integer.valueOf(this.exeOrder.getText());
        BExeParam exeParam = BExeParam.make((int)lev, (int)order);
        this.doLoadValue((BObject)exeParam, null);
        return exeParam;
    }
}

