/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point.ui;

import com.tridium.obix.driver.point.BObixPointDiscoveryJob;
import com.tridium.obix.driver.point.BObixPointDiscoveryResult;
import com.tridium.obix.driver.point.BObixProxyExt;
import com.tridium.obix.driver.point.ui.BObixPointManager;
import com.tridium.obix.driver.point.ui.ObixPointModel;
import com.tridium.obix.driver.ui.BObixLearnTable;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ObixPointLearn
extends MgrLearn {
    private static BImage boolImg = BImage.make((BIcon)BIcon.std((String)"control/booleanPoint.png"));
    private static BImage enumImg = BImage.make((BIcon)BIcon.std((String)"control/enumPoint.png"));
    private static BImage numericImg = BImage.make((BIcon)BIcon.std((String)"control/numericPoint.png"));
    private static BImage obixImg = BImage.make((BIcon)BIcon.std((String)"obix.png"));
    private static BImage strImg = BImage.make((BIcon)BIcon.std((String)"control/stringPoint.png"));
    BObixPointDiscoveryJob obixJob;

    public ObixPointLearn(BObixPointManager mgr) {
        super((BAbstractManager)mgr);
    }

    public Object[] getChildren(Object discovered) {
        try {
            this.getManager().enterBusy();
            Object[] objectArray = ObixPointLearn.x(discovered).getChildren(this.obixJob);
            return objectArray;
        }
        finally {
            this.getManager().exitBusy();
        }
    }

    public BImage getIcon(Object discovered) {
        BValue val = ObixPointLearn.x(discovered).getValue();
        if (val instanceof BINumeric) {
            return numericImg;
        }
        if (val instanceof BIBoolean) {
            return boolImg;
        }
        if (val instanceof BIEnum) {
            return enumImg;
        }
        if (ObixPointLearn.x(discovered).getIs().indexOf("obix:Lobby") >= 0) {
            return obixImg;
        }
        return strImg;
    }

    public boolean hasChildren(Object discovered) {
        BObixPointDiscoveryResult res = ObixPointLearn.x(discovered);
        return res.getKids().getSlotCount() > 0;
    }

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public boolean isExisting(Object discovered, BComponent db) {
        BObixPointDiscoveryResult res = ObixPointLearn.x(discovered);
        if (db instanceof BControlPoint) {
            return ObixPointLearn.ext(db).getHref().equals(res.getHref());
        }
        return false;
    }

    public boolean isGroup(Object discovered) {
        String is = ObixPointLearn.x(discovered).getIs();
        if (is != null) {
            return is.indexOf("t:Container") >= 0;
        }
        return false;
    }

    public boolean isMatchable(Object discovered, BComponent db) {
        BObixPointDiscoveryResult res = ObixPointLearn.x(discovered);
        BValue dis = res.getValue();
        if (res.getMode().isWrite()) {
            if (dis instanceof BINumeric) {
                return db instanceof BNumericWritable;
            }
            if (dis instanceof BIBoolean) {
                return db instanceof BBooleanWritable;
            }
            if (dis instanceof BIEnum) {
                return db instanceof BEnumWritable;
            }
            return db instanceof BStringWritable;
        }
        if (dis instanceof BINumeric) {
            return db instanceof BNumericPoint;
        }
        if (dis instanceof BIBoolean) {
            return db instanceof BBooleanPoint;
        }
        if (dis instanceof BIEnum) {
            return db instanceof BEnumPoint;
        }
        return db instanceof BStringPoint;
    }

    public void jobComplete(BJob job) {
        this.obixJob = (BObixPointDiscoveryJob)job;
        job.lease(Integer.MAX_VALUE);
        this.updateRoots(job.getChildComponents());
    }

    protected BLearnTable makeTable() {
        return new BObixLearnTable(this);
    }

    public void toRow(Object discovered, MgrEditRow row) throws Exception {
        BObixPointDiscoveryResult res = ObixPointLearn.x(discovered);
        ObixPointModel m = (ObixPointModel)this.getManager().getModel();
        row.setCell(m.name, (BValue)BString.make((String)res.getObixName()));
        row.setCell(m.id, (BValue)BString.make((String)res.getHref()));
    }

    public MgrTypeInfo[] toTypes(Object discovered) {
        boolean isPoint;
        BObixPointDiscoveryResult res = ObixPointLearn.x(discovered);
        BValue proto = res.getValue();
        boolean write = res.getMode().isWrite();
        boolean bl = isPoint = res.getIs().indexOf("obix:Point") >= 0;
        if (proto instanceof BINumeric) {
            if (write && isPoint) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
            }
            if (write) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
            }
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
        }
        if (proto instanceof BIBoolean) {
            if (write && isPoint) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
            }
            if (write) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
            }
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
        }
        if (proto instanceof BIEnum) {
            if (write && isPoint) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BEnumWritable.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
            }
            if (write) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE)};
            }
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BEnumPoint.TYPE)};
        }
        if (write && isPoint) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
        }
        if (write) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
        }
        return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringPoint.TYPE)};
    }

    public void updateTable() {
        this.getTable().getSelection().deselectAll();
        ((BObixLearnTable)this.getTable()).treeTableModel.updateTreeTable(true);
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(BObixPointDiscoveryResult.obixName), new MgrColumn.Prop(BObixPointDiscoveryResult.value), new MgrColumn.Prop(BObixPointDiscoveryResult.mode), new MgrColumn.Prop(BObixPointDiscoveryResult.href)};
    }

    private static BObixProxyExt ext(Object o) {
        return (BObixProxyExt)((BControlPoint)o).getProxyExt();
    }

    private static BObixPointDiscoveryResult x(Object discovered) {
        return (BObixPointDiscoveryResult)discovered;
    }
}

