/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point.ui;

import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.FolderModel;

public class BObixPointTable
extends BMgrTable {
    public static final Type TYPE = Sys.loadType(BObixPointTable.class);
    BAbstractManager manager;
    MgrModel model;
    FolderModel folderModel;
    Type[] includes;
    HashMap<BComponent, BComponent> subscription = new HashMap();

    public Type getType() {
        return TYPE;
    }

    public BObixPointTable() {
    }

    public BObixPointTable(MgrModel model) {
        super(model);
        this.manager = model.getManager();
        this.model = model;
        this.folderModel = model instanceof FolderModel ? (FolderModel)model : null;
    }

    public void reload() {
        super.reload();
        this.myreload();
    }

    public void myreload() {
        this.includes = this.model.getIncludeTypes();
        BComponent[] rows = this.resolve();
        this.mySubscribe(rows);
    }

    private BComponent[] resolve() {
        if (this.folderModel == null || !this.folderModel.isAllDescendants()) {
            return this.resolveFlat();
        }
        return this.resolveDeep();
    }

    private BComponent[] resolveFlat() {
        BComponent target = this.manager.getCurrentValue().asComponent();
        Array acc = new Array(BComponent.class);
        SlotCursor c = target.getProperties();
        while (c.nextComponent()) {
            Property prop = c.property();
            BComponent comp = (BComponent)c.get();
            if (Flags.isHidden((BComplex)target, (Slot)prop) || !this.include(comp)) continue;
            acc.add((Object)comp);
        }
        return (BComponent[])acc.trim();
    }

    private BComponent[] resolveDeep() {
        BComponent target = this.manager.getCurrentValue().asComponent();
        String bql = "bql:select slotPath from ";
        for (int i = 0; i < this.includes.length; ++i) {
            if (i > 0) {
                bql = bql + ", ";
            }
            bql = bql + this.includes[i];
        }
        BITable result = (BITable)BOrd.make((String)bql).get((BObject)target);
        try (TableCursor cursor = result.cursor();){
            ArrayList<BOrd> ords = new ArrayList<BOrd>();
            Column col = result.getColumns().get(0);
            while (cursor.next()) {
                ords.add(BOrd.make((String)cursor.cell(col).toString()));
            }
            BComponent[] bComponentArray = new BatchResolve(ords.toArray(new BOrd[ords.size()])).resolve((BObject)target).getTargetComponents();
            return bComponentArray;
        }
    }

    private void mySubscribe(BComponent[] rows) {
        BAbstractManager mgr = this.manager;
        Array ptList = new Array(BComponent.class);
        for (int i = 0; i < rows.length; ++i) {
            BComponent p = (BComponent)rows[i].getParent();
            if (rows[i] instanceof BControlPoint) {
                ptList.add((Object)rows[i]);
            }
            this.subscription.put(p, p);
        }
        if (ptList.size() == 0) {
            return;
        }
        BComponent[] pxSub = (BComponent[])ptList.trim();
        mgr.registerForComponentEvents(pxSub, 1);
    }

    public void handleComponentEvent(BComponentEvent event) {
        switch (event.getId()) {
            case 2: {
                super.reload();
                break;
            }
            default: {
                super.handleComponentEvent(event);
            }
        }
    }
}

