/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.alarm.ui;

import com.tridium.obix.driver.alarm.BObixAlarmDiscoveryJob;
import com.tridium.obix.driver.alarm.BObixAlarmDiscoveryResult;
import com.tridium.obix.driver.alarm.BObixAlarmImport;
import com.tridium.obix.driver.alarm.ui.BObixAlarmManager;
import com.tridium.obix.driver.alarm.ui.ObixAlarmModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ObixAlarmLearn
extends MgrLearn {
    private static BImage alarmImg = BImage.make((BIcon)BIcon.std((String)"alarm.png"));
    private static BImage obixImg = BImage.make((BIcon)BIcon.std((String)"obix.png"));
    private static BImage objImg = BImage.make((BIcon)BIcon.std((String)"object.png"));
    BObixAlarmDiscoveryJob obixJob;
    BObixAlarmManager manager;

    public ObixAlarmLearn(BObixAlarmManager mgr) {
        super((BAbstractManager)mgr);
        this.manager = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object discovered) {
        try {
            this.getManager().enterBusy();
            BObixAlarmDiscoveryResult r = ObixAlarmLearn.x(discovered);
            Object[] objectArray = r.getChildren(this.obixJob);
            return objectArray;
        }
        finally {
            this.getManager().exitBusy();
        }
    }

    public BImage getIcon(Object discovered) {
        if (!ObixAlarmLearn.x(discovered).getFeed().equals("")) {
            return alarmImg;
        }
        if (ObixAlarmLearn.x(discovered).getObixName().equals("lobby")) {
            return obixImg;
        }
        return objImg;
    }

    public boolean hasChildren(Object discovered) {
        BObixAlarmDiscoveryResult r = ObixAlarmLearn.x(discovered);
        return r.getKids().getSlotCount() > 0;
    }

    public final boolean isDepthExpandable(int depth) {
        return true;
    }

    public final boolean isExisting(Object discovered, BComponent db) {
        BObixAlarmDiscoveryResult res = ObixAlarmLearn.x(discovered);
        if (db instanceof BObixAlarmImport) {
            return ObixAlarmLearn.proxy(db).getHref().equals(res.getHref());
        }
        return false;
    }

    public final boolean isGroup(Object discovered) {
        return false;
    }

    public final boolean isMatchable(Object discovered, BComponent db) {
        return this.isGroup(discovered) && db instanceof BObixAlarmImport;
    }

    public final void jobComplete(BJob job) {
        this.obixJob = (BObixAlarmDiscoveryJob)job;
        job.lease(Integer.MAX_VALUE);
        this.updateRoots(job.getChildComponents());
    }

    public void toRow(Object discovered, MgrEditRow row) throws Exception {
        BObixAlarmDiscoveryResult res = ObixAlarmLearn.x(discovered);
        ObixAlarmModel m = (ObixAlarmModel)this.getManager().getModel();
        row.setCell(m.href, (BValue)BString.make((String)res.getFeed()));
        row.setCell(m.name, (BValue)BString.make((String)res.getObixName()));
    }

    public final MgrTypeInfo[] toTypes(Object discovered) {
        BObixAlarmDiscoveryResult res = ObixAlarmLearn.x(discovered);
        if (res.isAlarmFeed()) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)this.manager.getDeviceExt().getAlarmImportType())};
        }
        return new MgrTypeInfo[0];
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(BObixAlarmDiscoveryResult.obixName), new MgrColumn.Prop(BObixAlarmDiscoveryResult.href), new MgrColumn.Prop(BObixAlarmDiscoveryResult.feed)};
    }

    private static BObixAlarmImport proxy(Object o) {
        return (BObixAlarmImport)o;
    }

    private static BObixAlarmDiscoveryResult x(Object discovered) {
        return (BObixAlarmDiscoveryResult)discovered;
    }
}

