/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import javax.baja.schedule.BYearSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;

public class BYearEd
extends BAbstractScheduleWidget {
    public static final Action yearModified = BYearEd.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BYearEd.class);
    BTextDropDown yearBox = new BTextDropDown(9, true);
    BYearSchedule schedule;

    public void yearModified() {
        this.invoke(yearModified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BYearEd() {
        BList l = this.yearBox.getList();
        l.addItem((Object)this.lex("year.anyYear"));
        int yr = Clock.time().getYear();
        int stop = yr + 10;
        for (int i = yr; i < stop; ++i) {
            l.addItem((Object)String.valueOf(i));
        }
        this.linkTo((BComponent)this.yearBox, (Slot)BTextDropDown.valueModified, (Slot)yearModified);
        this.setContent((BWidget)this.yearBox);
    }

    public void load(BYearSchedule schedule) {
        this.schedule = schedule;
        if (schedule.getAlwaysEffective()) {
            this.yearBox.setText(this.lex("year.anyYear"));
        } else {
            this.yearBox.setText(String.valueOf(schedule.getYear()));
        }
        this.yearBox.setEnabled(!this.isReadonly());
    }

    public void doYearModified() {
        String s = this.yearBox.getText().trim();
        if (s.isEmpty()) {
            return;
        }
        if (s.equals(this.lex("year.anyYear"))) {
            this.schedule.setAlwaysEffective(true);
        } else {
            if (this.schedule.getAlwaysEffective()) {
                this.schedule.setAlwaysEffective(false);
            }
            this.schedule.setYear(Integer.parseInt(s));
        }
        this.fireModified(null);
    }

    public void select(int year) {
        if (year == -1) {
            this.yearBox.setText(this.lex("year.anyYear"));
        } else {
            this.yearBox.setText(String.valueOf(year));
        }
    }

    @Override
    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        this.yearBox.setEnabled(!ro);
    }
}

