/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;

@NiagaraType
@NiagaraAction(name="listModified")
public class BScheduleReferenceEd
extends BAbstractScheduleWidget {
    public static final Action listModified = BScheduleReferenceEd.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BScheduleReferenceEd.class);
    private final BScheduleReference schedule;
    private final BAbstractSchedule base;
    private final BList list;

    public void listModified() {
        this.invoke(listModified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BScheduleReferenceEd(BAbstractSchedule base, BScheduleReference schedule) {
        this.base = base;
        this.schedule = schedule;
        this.list = new BList();
        this.list.setMultipleSelection(false);
        this.loadList();
        this.list.setEnabled(!this.isReadonly());
        BBorderPane bp = new BBorderPane((BWidget)this.list);
        bp.setLabel((BWidget)new BLabel(this.lex("scheduleReference.calendars")));
        bp.setBorder(BBorder.solid);
        this.setContent((BWidget)bp);
        this.linkTo((BComponent)this.list, (Slot)BList.selectionModified, (Slot)listModified);
    }

    public void doListModified() {
        if (this.list.getItemCount() > 0 && this.list.getSelectedIndex() >= 0) {
            this.schedule.setRef((BOrd)this.list.getSelectedItem());
        }
        this.fireModified(null);
    }

    @Override
    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        if (this.list != null) {
            this.list.setEnabled(!ro);
        }
    }

    private void loadList() {
        BOrd current = this.schedule.getRef();
        if (!current.isNull()) {
            this.list.addItem((Object)this.schedule.getRef());
            this.list.setSelectedItem((Object)this.schedule.getRef());
        }
        BOrd query = BOrd.make((String)"station:|slot:/|bql: SELECT slotPathOrd FROM schedule:CalendarSchedule stop");
        BOrd baseOrd = this.base.getSlotPathOrd();
        BITable table = (BITable)query.resolve((BObject)this.base).get();
        Column col = table.getColumns().get(0);
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                BCalendarSchedule calendarSchedule;
                BOrd ord = BOrd.make((String)cursor.cell(col).toString(null));
                if (ord.equals((Object)current) || ord.equals((Object)baseOrd) || (calendarSchedule = (BCalendarSchedule)ord.get((BObject)this.base)).getParent() instanceof BAbstractSchedule) continue;
                this.list.addItem((Object)ord);
            }
        }
    }
}

