/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ScheduleValidator;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BCompositeEd;
import com.tridium.schedule.ui.BCustomEd;
import com.tridium.schedule.ui.BDateEd;
import com.tridium.schedule.ui.BDateRangeEd;
import com.tridium.schedule.ui.BDayOfMonthEd;
import com.tridium.schedule.ui.BMonthEd;
import com.tridium.schedule.ui.BScheduleReferenceEd;
import com.tridium.schedule.ui.BWeekAndDayEd;
import com.tridium.schedule.ui.BWeekOfMonthEd;
import com.tridium.schedule.ui.BWeekdayEd;
import com.tridium.schedule.ui.BYearEd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDayOfMonthSchedule;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.schedule.BWeekOfMonthSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.schedule.BYearSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BScheduleFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BScheduleFE.class);
    BAbstractScheduleWidget ed;
    boolean resize;
    BAbstractSchedule schedule;
    BAbstractSchedule base;

    public Type getType() {
        return TYPE;
    }

    public BScheduleFE() {
    }

    public BScheduleFE(BAbstractSchedule base) {
        this(base, false);
    }

    public BScheduleFE(BAbstractSchedule base, boolean resize) {
        this.base = base;
        this.resize = resize;
    }

    public void doSetReadonly(boolean ro) {
        this.setReadonly(ro);
        if (this.ed != null) {
            this.ed.setReadonly(ro);
        }
    }

    private BAbstractScheduleWidget makeFor(BAbstractSchedule sch) {
        if (sch instanceof BCustomSchedule) {
            return new BCustomEd(this.base, (BCustomSchedule)sch);
        }
        if (sch instanceof BScheduleReference) {
            return new BScheduleReferenceEd(this.base, (BScheduleReference)sch);
        }
        if (sch instanceof BWeekAndDaySchedule) {
            return new BWeekAndDayEd((BWeekAndDaySchedule)sch);
        }
        if (sch instanceof BDateSchedule) {
            BDateEd ed = new BDateEd();
            ed.load((BDateSchedule)sch);
            return ed;
        }
        if (sch instanceof BDateRangeSchedule) {
            BDateRangeEd ed = new BDateRangeEd();
            ed.load((BDateRangeSchedule)sch);
            return ed;
        }
        if (sch instanceof BDayOfMonthSchedule) {
            BDayOfMonthEd ed = new BDayOfMonthEd(this.base, false);
            ed.load((BEnumSetSchedule)((BDayOfMonthSchedule)sch));
            return ed;
        }
        if (sch instanceof BMonthSchedule) {
            BMonthEd ed = new BMonthEd();
            ed.load((BEnumSetSchedule)((BMonthSchedule)sch));
            return ed;
        }
        if (sch instanceof BWeekdaySchedule) {
            BWeekdayEd ed = new BWeekdayEd();
            ed.load((BEnumSetSchedule)((BWeekdaySchedule)sch));
            return ed;
        }
        if (sch instanceof BWeekOfMonthSchedule) {
            BWeekOfMonthEd ed = new BWeekOfMonthEd();
            ed.load((BEnumSetSchedule)((BWeekOfMonthSchedule)sch));
            return ed;
        }
        if (sch instanceof BYearSchedule) {
            BYearEd ed = new BYearEd();
            ed.load((BYearSchedule)sch);
            return ed;
        }
        if (sch instanceof BCompositeSchedule) {
            BCompositeEd ret = new BCompositeEd(false, false);
            ret.schedule = (BCompositeSchedule)sch;
            return ret;
        }
        throw new IllegalArgumentException("Unexpected schedule: " + sch.getClass().getName());
    }

    public void doLoadValue(BObject value, Context cx) {
        this.schedule = (BAbstractSchedule)value;
        this.ed = this.makeFor(this.schedule);
        this.ed.setReadonly(this.isReadonly());
        this.linkTo((BComponent)this.ed, (Slot)BAbstractScheduleWidget.modified, (Slot)pluginModified);
        this.setContent(this.ed);
    }

    public BObject doSaveValue(BObject value, Context cx) {
        return this.schedule;
    }

    void validate() throws Exception {
        ScheduleValidator.validate((BAbstractSchedule)this.schedule);
    }
}

