/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.Utils;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class BMonthWidget
extends BWidget {
    public static final Topic selected = BMonthWidget.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BMonthWidget.class);
    static double baseYoffset;
    static double cellH;
    static double cellW;
    Cell[][] cells = new Cell[7][7];
    static BFont font;
    static Cell[] headers;
    static double highH;
    static double highW;
    BMonth month;
    String monthStr;
    double monthX;
    boolean selectable = false;
    int selection = -1;
    BAbsTime start;
    static double strH;
    static double strW;
    static double padding;
    int year;
    static double widgetW;
    static double widgetH;

    public void fireSelected(BMonthWidget event) {
        this.fire(selected, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMonthWidget() {
    }

    public BMonthWidget(int year, BMonth month) {
        this.start = BAbsTime.make((int)year, (BMonth)month, (int)1, (int)0, (int)0, (int)0, (int)0);
        this.year = year;
        this.month = month;
        this.monthStr = month.getShortDisplayTag(null) + " " + year;
        this.monthX = (widgetW - font.width(this.monthStr)) / 2.0;
        int daysInMonth = BAbsTime.getDaysInMonth((int)year, (BMonth)month);
        int firstDay = this.translateDay(this.start.getWeekday());
        for (int i = 0; i < 7; ++i) {
            this.cells[0][i] = headers[i];
        }
        double curY = cellH * 2.0;
        int curDay = 1;
        for (int row = 1; row < 7; ++row) {
            int col = 0;
            double curX = 0.0;
            if (row == 1) {
                col = firstDay;
                curX = cellW * (double)col;
            }
            while (col < 7 && curDay <= daysInMonth) {
                Cell c;
                this.cells[row][col] = c = new Cell();
                c.dom = curDay;
                c.str = String.valueOf(curDay);
                c.strW = font.width(c.str);
                c.strX = curX + (cellW - c.strW) / 2.0;
                c.strBaseY = curY + baseYoffset;
                c.highX = curX + (cellW - highW) / 2.0;
                c.highY = curY + (cellH - highH) / 2.0;
                c.x = curX;
                c.y = curY;
                ++curDay;
                ++col;
                curX += cellW;
            }
            curY += cellH;
        }
    }

    public void clearHighlights() {
        int row = 7;
        while (--row > 0) {
            int col = 7;
            while (--col >= 0) {
                Cell c = this.cells[row][col];
                if (c == null) continue;
                c.highlight = false;
            }
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(widgetW, widgetH);
    }

    public BMonth getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public int getSelection() {
        return this.selection;
    }

    public BAbsTime getStart() {
        return this.start;
    }

    public void highlight(int dom) {
        int row = 7;
        while (--row > 0) {
            int col = 7;
            while (--col >= 0) {
                Cell c = this.cells[row][col];
                if (c == null || c.dom != dom) continue;
                c.highlight = true;
            }
        }
    }

    public void paint(Graphics g) {
        if (this.selectable) {
            g.setBrush(Utils.clrBg);
        } else {
            g.setBrush(Utils.clrRoBg);
        }
        g.fillRect(0.0, 0.0, widgetW, widgetH);
        g.setBrush(Utils.clrFg);
        g.drawString(this.monthStr, this.monthX, baseYoffset);
        this.paintHeaders(g);
        this.paintDays(g);
        g.setBrush(Utils.clrFg);
        g.strokeRect(0.0, 0.0, widgetW - 1.0, widgetH - 1.0);
    }

    public void mouseReleased(BMouseEvent e) {
        if (!this.selectable) {
            return;
        }
        int row = (int)(e.getY() / cellH) - 1;
        if (row < 0) {
            return;
        }
        int col = (int)(e.getX() / cellW);
        Cell c = this.cells[row][col];
        if (c != null && c.dom > 0) {
            this.selection = c.dom;
            this.repaint();
            this.fireSelected(this);
        }
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public void setSelection(int dom) {
        this.selection = dom;
    }

    private void paintHeaders(Graphics g) {
        g.setBrush(Utils.clrFg);
        g.setPen(BPen.DEFAULT);
        for (int col = 0; col < 7; ++col) {
            Cell c = this.cells[0][col];
            g.drawString(c.str, c.strX, c.strBaseY);
            double y = c.highY + highH;
            g.strokeLine(c.highX, y, c.highX + highW, y);
        }
    }

    private void paintDays(Graphics g) {
        g.setFont(font);
        g.setBrush(Utils.clrFg);
        g.setPen(BPen.DEFAULT);
        block0: for (int row = 1; row < 7; ++row) {
            for (int col = 0; col < 7; ++col) {
                Cell c = this.cells[row][col];
                if (c == null) {
                    if (row <= 1) continue;
                    continue block0;
                }
                g.setBrush(Utils.clrFg);
                if (this.selection == c.dom) {
                    g.setBrush(Utils.clrSelCurBg);
                    g.fillRect(c.x, c.y, cellW, cellH);
                    g.setBrush(Utils.clrSelFg);
                }
                if (c.highlight) {
                    g.setBrush(Utils.clrSelBg);
                    g.fillRect(c.highX, c.highY, highW, highH);
                    g.setBrush(Utils.clrSelFg);
                }
                g.drawString(c.str, c.strX, c.strBaseY);
            }
        }
    }

    private int translateDay(BWeekday day) {
        int ret = day.getOrdinal() - BWeekday.getFirstDayOfWeek(null).getOrdinal();
        if (ret < 0) {
            ret += 7;
        }
        return ret;
    }

    static {
        padding = 2.0;
        font = Theme.widget().getTextFont();
        strH = font.getAscent() + font.getDescent();
        strW = font.width("W0");
        cellW = strW + padding * 4.0;
        cellH = strH + padding * 4.0;
        highW = strW + padding * 2.0;
        highH = strH + padding * 2.0;
        baseYoffset = font.getAscent() + padding * 2.0;
        widgetW = cellW * 7.0;
        widgetH = cellH * 8.0;
        BWeekday[] ary = BWeekSchedule.daysInOrder(null);
        headers = new Cell[7];
        int curX = 0;
        for (int i = 0; i < ary.length; ++i) {
            BMonthWidget.headers[i] = new Cell();
            BMonthWidget.headers[i].str = String.valueOf(ary[i].getShortDisplayTag(null).toLowerCase().charAt(0));
            BMonthWidget.headers[i].strW = font.width(BMonthWidget.headers[i].str);
            BMonthWidget.headers[i].strX = (double)curX + (cellW - BMonthWidget.headers[i].strW) / 2.0;
            BMonthWidget.headers[i].strBaseY = cellH + baseYoffset;
            BMonthWidget.headers[i].x = curX;
            BMonthWidget.headers[i].y = cellH;
            BMonthWidget.headers[i].highX = (double)curX + (cellW - highW) / 2.0;
            BMonthWidget.headers[i].highY = cellH + (cellH - highH) / 2.0;
            curX = (int)((double)curX + cellW);
        }
    }

    static class Cell {
        String str;
        int dom = -1;
        double highX;
        double highY;
        double strX;
        double strBaseY;
        double strW;
        double x;
        double y;
        boolean highlight = false;

        Cell() {
        }
    }
}

