/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFixedRangeEnumFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BFixedRangeEnumFE.class);
    private BListDropDown combo = new BListDropDown();
    private BEnumRange range;
    private int[] ordinals;

    public Type getType() {
        return TYPE;
    }

    public BFixedRangeEnumFE() {
        this.setContent((BWidget)this.combo);
        this.linkTo("lk0", (BComponent)this.combo, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.combo, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.combo.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject v, Context cx) {
        BEnumRange r;
        BEnum val = (BEnum)v;
        this.range = val.getRange();
        if (cx != null && (r = (BEnumRange)cx.getFacet("range")) != null) {
            this.range = r;
        }
        this.ordinals = this.range.getOrdinals();
        this.populateDropDown(val);
        this.doSetReadonly(this.isReadonly());
    }

    private void populateDropDown(BEnum val) {
        int sel = -1;
        this.combo.getList().removeAllItems();
        for (int i = 0; i < this.ordinals.length; ++i) {
            int ordinal = this.ordinals[i];
            String displayTag = this.range.getDisplayTag(ordinal, null);
            this.combo.getList().addItem((Object)displayTag);
            if (ordinal != val.getOrdinal()) continue;
            sel = i;
        }
        this.combo.setSelectedIndex(sel);
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        int sel = this.combo.getSelectedIndex();
        return BDynamicEnum.make((int)this.ordinals[sel], (BEnumRange)this.range);
    }
}

