/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleView;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.ScheduleColors;
import com.tridium.schedule.ui.Utils;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;

public class BDaySlider
extends BAbstractScheduleWidget {
    public static final Topic clearWeek = BDaySlider.newTopic((int)0, null);
    public static final Topic fillWeek = BDaySlider.newTopic((int)0, null);
    public static final Topic schDragged = BDaySlider.newTopic((int)0, null);
    public static final Topic schRemoved = BDaySlider.newTopic((int)0, null);
    public static final Topic schSelected = BDaySlider.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BDaySlider.class);
    private static final int BOTTOM = 0;
    private static final int CENTER = 1;
    private static final int TOP = 2;
    private static int RANGE_BORDER = 4;
    static WidgetTheme widgetTheme = Theme.widget();
    private Clipboard clipboard;
    private BStatusValue defaultValue;
    private Range dragging;
    private int dragType;
    private BFacets facets;
    private Range first;
    static BFont font = widgetTheme.getTextFont();
    static double fontOffset = font.getMaxAscent() + 1.0;
    private int maxU;
    private int minU;
    private double pressedOffset;
    private double pressedY;
    BDaySchedule schedule;
    private Range selected;
    private boolean week;
    int units = 48;
    int[] unitLines = new int[]{6, 12, 18, 24, 30, 36, 42};
    private int[] unitY;
    private boolean dragHappened = false;

    public void fireClearWeek(BValue event) {
        this.fire(clearWeek, event, null);
    }

    public void fireFillWeek(BDaySchedule event) {
        this.fire(fillWeek, (BValue)event, null);
    }

    public void fireSchDragged(BValue event) {
        this.fire(schDragged, event, null);
    }

    public void fireSchRemoved(BValue event) {
        this.fire(schRemoved, event, null);
    }

    public void fireSchSelected(BDaySlider event) {
        this.fire(schSelected, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDaySlider() {
    }

    public BDaySlider(Clipboard clipboard, boolean week) {
        this.clipboard = clipboard;
        this.week = week;
    }

    public Range add(Object value, BTime start, BTime finish) {
        BTimeSchedule sch = new BTimeSchedule();
        sch.setStart(start);
        sch.setFinish(finish);
        sch.setEffectiveValue((BStatusValue)value);
        this.schedule.add(sch);
        Range r = new Range(this, sch);
        this.add(r);
        return r;
    }

    public Range add(Object value, int startUnit, int finishUnit) {
        if (startUnit == finishUnit && startUnit == 0) {
            finishUnit = startUnit + 1;
            this.fireModified(null);
        }
        BTimeSchedule sch = new BTimeSchedule();
        sch.setStart(BTime.make((BRelTime)BRelTime.make((long)this.unitToMillis(startUnit, true))));
        sch.setFinish(BTime.make((BRelTime)BRelTime.make((long)this.unitToMillis(finishUnit, false))));
        sch.setEffectiveValue((BStatusValue)value);
        this.schedule.add(sch);
        Range r = new Range(this, sch, startUnit, finishUnit);
        this.add(r);
        return r;
    }

    public void clearDay() {
        while (this.first != null) {
            this.remove(this.first);
        }
    }

    public void copy(BDaySchedule sch) {
        this.clearDay();
        this.schedule.removeAll(null);
        Object[] kids = sch.getChildren(BTimeSchedule.class);
        int len = kids.length;
        for (int i = 0; i < len; ++i) {
            BTimeSchedule t = (BTimeSchedule)kids[i];
            t = (BTimeSchedule)t.newCopy(true);
            this.schedule.add(t);
            Range r = new Range(this, t, this.millisToUnit(t.getStart().getTimeOfDayMillis(), true), this.millisToUnit(t.getFinish().getTimeOfDayMillis(), false));
            this.add(r);
        }
    }

    @Override
    public void computePreferredSize() {
        double pw = font.width("WWWWW");
        double ph = pw * 3.0;
        this.setPreferredSize(pw, ph);
    }

    public void deselect() {
        this.selected = null;
        this.repaint();
    }

    @Override
    public void doLayout(BWidget[] kids) {
        if (this.schedule != null) {
            BAbstractSchedule root = this.schedule.getRootSchedule();
            this.facets = (BFacets)root.get("facets");
        }
        if (this.unitY == null) {
            this.unitY = new int[this.units + 1];
        }
        double h = this.getHeight();
        double ppu = h / (double)this.units;
        for (int i = 0; i < this.units; ++i) {
            this.unitY[i] = (int)Math.round((double)i * ppu);
        }
        this.unitY[this.units] = (int)h - 1;
    }

    public BTimeSchedule getSelectedSchedule() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.sch;
    }

    public String getUnitLabel(int unit) {
        long millis = this.unitToMillis(unit, false);
        BTime t = BTime.make((BRelTime)BRelTime.make((long)millis));
        return t.toString(null);
    }

    public boolean isFocusTraversable() {
        return this.first != null;
    }

    public void load(BDaySchedule schedule, BStatusValue defaultValue) {
        this.schedule = schedule;
        this.defaultValue = defaultValue;
        this.first = null;
        this.dragging = null;
        this.selected = null;
        BAbstractSchedule root = schedule.getRootSchedule();
        this.facets = (BFacets)root.get("facets");
        Object[] kids = schedule.getChildren(BTimeSchedule.class);
        int len = kids.length;
        for (int i = 0; i < len; ++i) {
            BTimeSchedule t = (BTimeSchedule)kids[i];
            Range r = new Range(this, t, this.millisToUnit(t.getStart().getTimeOfDayMillis(), true), this.millisToUnit(t.getFinish().getTimeOfDayMillis(), false));
            this.add(r);
        }
    }

    public void keyPressed(BKeyEvent e) {
        if (!this.isEnabled() || this.isReadonly()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                if (this.selected == null) {
                    return;
                }
                e.consume();
                this.remove(this.selected);
                this.repaint();
                break;
            }
            case 9: {
                if (this.selected == null) {
                    if (this.first == null) break;
                    this.select(this.first);
                    e.consume();
                    break;
                }
                if (this.selected.next == null) break;
                this.select(this.selected.next);
                e.consume();
            }
        }
    }

    public int millisToUnit(long millis, boolean isStart) {
        if (millis == 0L) {
            if (isStart) {
                return 0;
            }
            return this.units;
        }
        float mpu = 86400000 / this.units;
        return Math.round((float)millis / mpu);
    }

    public int millisToRangeUnit(long millis, boolean isStart) {
        if (millis == 0L) {
            if (isStart) {
                return 0;
            }
            return this.units;
        }
        float mpu = 86400000 / this.units;
        if (isStart) {
            return Math.round((float)millis / mpu - 0.49999f);
        }
        return Math.round((float)millis / mpu + 0.49999f);
    }

    public void mouseDragged(BMouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    public void mouseEntered(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseExited(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseMoved(BMouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    public void mousePressed(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePulsed(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(BMouseEvent e) {
        this.processMouseEvent(e);
        if (this.dragHappened) {
            this.dragHappened = false;
            this.fireModified(null);
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintForeground(g);
    }

    public void popup(BMouseEvent e) {
        if (this.isReadonly()) {
            return;
        }
        BMenu menu = new BMenu();
        this.pressedY = e.getY();
        Range r = this.yToRange(this.pressedY);
        if (r != null) {
            if (this.selected != r) {
                this.select(r);
            }
            menu.add(null, (Command)new CmdDelete());
        }
        Object[] kids = this.schedule.getChildren(BAbstractSchedule.class);
        if (this.clipboard != null && this.clipboard.get() != null && this.clipboard.get() != this.schedule) {
            menu.add(null, (Command)new CmdPaste());
        }
        menu.add(null, (Command)new CmdAllDay());
        if (kids.length > 0) {
            if (this.week) {
                menu.add(null, (Command)new CmdFill());
                menu.add(null, (Command)new CmdCopy());
            }
            menu.add(null, (Command)new CmdClear());
        }
        if (this.week) {
            menu.add(null, (Command)new CmdClearWeek());
        } else {
            menu.add(null, (Command)new CmdScheduleDefaults());
        }
        menu.open((BWidget)this, e.getX(), e.getY());
    }

    private void processMouseEvent(BMouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e);
            return;
        }
        switch (e.getId()) {
            case 504: {
                if (!this.isEnabled() || this.isReadonly()) {
                    return;
                }
                if (this.dragging != null) break;
                this.checkCursor(e.getY());
                break;
            }
            case 505: {
                if (!this.isEnabled() || this.isReadonly()) {
                    return;
                }
                if (this.dragging != null) break;
                this.setMouseCursor(MouseCursor.normal);
                break;
            }
            case 501: {
                this.pressedY = e.getY();
                if (e.isButton1Down()) {
                    this.dragging = this.yToRange(this.pressedY);
                }
                if (this.dragging == null) {
                    if (!UiEnv.get().hasMouse() && e.isButton1Down()) {
                        int oneHourLater;
                        int pressedUnit = this.yToUnit(this.pressedY);
                        if (pressedUnit == (oneHourLater = Math.min(this.units, pressedUnit + 2))) {
                            return;
                        }
                        if (this.yToRange(this.unitToY(pressedUnit + 1)) != null) {
                            return;
                        }
                        this.dragging = this.add((Object)this.newEffectiveValue(), pressedUnit, oneHourLater);
                    } else {
                        return;
                    }
                }
                this.select(this.dragging);
                if (!this.isEnabled() || this.isReadonly()) {
                    this.dragging = null;
                    return;
                }
                this.startDrag(this.pressedY, false);
                this.requestFocus();
                break;
            }
            case 502: {
                if (!this.isEnabled() || this.isReadonly()) {
                    return;
                }
                this.dragging = null;
                this.checkCursor(e.getY());
            }
        }
    }

    private void processMouseMotionEvent(BMouseEvent e) {
        if (!this.isEnabled() || this.isReadonly()) {
            return;
        }
        switch (e.getId()) {
            case 503: {
                this.checkCursor(e.getY());
                break;
            }
            case 506: {
                if (!e.isButton1Down()) {
                    return;
                }
                double y = e.getY();
                if (this.dragging != null) {
                    this.handleDrag(y);
                    break;
                }
                if (!(y - this.pressedY >= 2.0)) break;
                int unit = this.yToUnit(this.pressedY);
                int roundedY = this.unitToY(unit);
                Range range = this.yToRange(roundedY);
                if (range != null && range.finishRange > unit) {
                    return;
                }
                this.dragging = this.add((Object)this.newEffectiveValue(), this.yToUnit(this.pressedY), this.yToUnit(y));
                this.select(this.dragging);
                this.startDrag(y, true);
            }
        }
    }

    public void remove(Range r) {
        if (r == this.first) {
            this.first = r.next;
            if (this.first != null) {
                this.first.prev = null;
            }
        } else {
            r.prev.next = r.next;
            if (r.prev.next != null) {
                r.next.prev = r.prev;
            }
        }
        if (r == this.selected) {
            this.selected = null;
        }
        this.schedule.remove((BComplex)r.sch);
        this.fireSchRemoved((BValue)r.sch);
    }

    public final void select(Range r) {
        if (this.selected == r) {
            return;
        }
        this.selected = r;
        this.repaint();
        if (r != null) {
            this.fireSchSelected(this);
        }
    }

    public final BTime selectedEarliestStart() {
        if (this.selected.prev == null) {
            return BTime.make((int)0, (int)0, (int)0, (int)0);
        }
        return this.selected.prev.sch.getFinish();
    }

    public final BTime selectedLatestFinish() {
        if (this.selected.next == null) {
            return BTime.make((int)0, (int)0, (int)0, (int)0);
        }
        return this.selected.next.sch.getStart();
    }

    public long unitToMillis(int unit, boolean isStart) {
        if (unit == 0) {
            if (isStart) {
                return 0L;
            }
            return 86400000L;
        }
        float mpu = 86400000 / this.units;
        return (long)(mpu * (float)unit);
    }

    public final int unitToY(int unit) {
        if (this.unitY == null) {
            return 0;
        }
        return this.unitY[unit];
    }

    public final int unitToY(int unit, int height) {
        float ppu = (float)height / (float)this.units;
        return Math.round((float)unit * ppu);
    }

    public void updateSelectedSchedule() {
        this.selected.updateUnits();
        this.selected.updateColors();
        this.repaint();
    }

    public final Range yToRange(double y) {
        Range r = this.first;
        while (r != null) {
            if (y >= r.startY() && y <= r.finishY()) {
                return r;
            }
            r = r.next;
        }
        return null;
    }

    public final int yToUnit(double y) {
        double f = y / this.getHeight();
        f = (double)this.units * f;
        return (int)Math.min(Math.round(f), (long)this.units);
    }

    protected void paintBackground(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.isReadonly() || !this.isEnabled()) {
            g.setBrush(Utils.clrRoBg);
        } else {
            g.setBrush(Utils.clrBg);
        }
        g.fillRect(0.0, 0.0, w, h);
        if (this.unitLines != null) {
            g.setBrush(Utils.clrFg);
            int i = this.unitLines.length;
            while (--i >= 0) {
                double y = this.unitToY(this.unitLines[i]);
                g.strokeLine(0.0, y, w, y);
            }
        }
        if (this.defaultValue != null) {
            g.setFont(font);
            g.setBrush(Utils.clrFg);
            if (this.week) {
                g.drawString(this.valueText(this.defaultValue), 2.0, 2.0 + fontOffset);
            } else {
                g.drawString(this.lex("day.unscheduled"), 2.0, 2.0 + fontOffset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintForeground(Graphics g) {
        g.setFont(font);
        Range r = this.first;
        double w = this.getWidth();
        while (r != null) {
            double y = r.startY();
            double h = r.height() + 1.0;
            boolean isSelected = r == this.selected;
            g.push();
            try {
                ScheduleColors sc = r.getColors();
                g.clip(0.0, y, w, h);
                g.setBrush(isSelected ? Utils.clrSelCurBg : sc.getBackground(null));
                g.fillRect(0.0, y, w, h);
                g.setBrush(Utils.clrFg);
                double tmp = y + h - 1.0;
                g.strokeLine(0.0, y, w, y);
                g.strokeLine(0.0, tmp, w, tmp);
                String text = this.rangeText(r);
                if (text != null) {
                    g.setBrush(isSelected ? Utils.clrSelFg : sc.getForeground(null));
                    g.drawString(text, 2.0, y + fontOffset);
                }
            }
            finally {
                g.pop();
            }
            r = r.next;
        }
    }

    private void add(Range r) {
        Range pred = this.predecessor(r.start);
        if (pred == null) {
            r.next = this.first;
            if (r.next != null) {
                this.first.prev = r;
            }
            this.first = r;
        } else {
            r.next = pred.next;
            if (r.next != null) {
                r.next.prev = r;
            }
            r.prev = pred;
            pred.next = r;
        }
    }

    private void checkCursor(double y) {
        if (!this.isEnabled() || this.isReadonly()) {
            return;
        }
        Range r = this.yToRange(y);
        if (r == null) {
            this.setMouseCursor(MouseCursor.normal);
        } else if (y <= r.startY() + (double)RANGE_BORDER) {
            this.setMouseCursor(MouseCursor.nResize);
        } else if (y >= r.finishY() - (double)RANGE_BORDER) {
            this.setMouseCursor(MouseCursor.sResize);
        } else if (y > r.startY() && y < r.finishY()) {
            this.setMouseCursor(MouseCursor.openHand);
        } else {
            this.setMouseCursor(MouseCursor.normal);
        }
    }

    private void handleDrag(double y) {
        boolean repaint = false;
        switch (this.dragType) {
            case 2: {
                int unit = this.yToUnit(y);
                unit = unit < this.minU ? this.minU : (unit > this.maxU ? this.maxU : unit);
                boolean bl = repaint = unit != this.dragging.start;
                if (this.dragging.start == unit) {
                    return;
                }
                this.dragging.start = unit;
                this.dragging.updateStartTime();
                break;
            }
            case 0: {
                int unit = this.yToUnit(y);
                unit = unit < this.minU ? this.minU : (unit > this.maxU ? this.maxU : unit);
                boolean bl = repaint = unit != this.dragging.finish;
                if (this.dragging.finish == unit) {
                    return;
                }
                this.dragging.finish = unit;
                this.dragging.updateFinishTime();
                break;
            }
            case 1: {
                int h = this.dragging.finish - this.dragging.start;
                int unit = this.yToUnit(y -= this.pressedOffset);
                unit = unit < this.minU ? this.minU : (unit > this.maxU ? this.maxU : unit);
                boolean bl = repaint = unit != this.dragging.start;
                if (this.dragging.start == unit && this.dragging.finish == unit + h) {
                    return;
                }
                this.dragging.start = unit;
                this.dragging.finish = unit + h;
                this.dragging.updateStartTime();
                this.dragging.updateFinishTime();
            }
        }
        if (repaint) {
            this.repaint();
        }
        this.dragHappened = true;
        this.fireSchDragged(null);
    }

    private BStatusValue newEffectiveValue() {
        BStatus s;
        if (this.clipboard != null) {
            return this.clipboard.newEffectiveValue();
        }
        BAbstractScheduleView view = this.getView();
        BStatusValue ret = this.defaultValue;
        if ((ret = (BStatusValue)ret.newCopy(true)) instanceof BStatusBoolean) {
            BStatusBoolean b;
            b.setValue(!(b = (BStatusBoolean)ret).getValue());
        }
        if ((s = ret.getStatus()).isNull()) {
            ret.setStatus(BStatus.makeNull((BStatus)s, (boolean)false));
        }
        return ret;
    }

    private Range predecessor(double y) {
        Range r = this.first;
        Range prev = null;
        while (r != null) {
            if (y <= (double)r.start) {
                return prev;
            }
            prev = r;
            r = r.next;
        }
        return prev;
    }

    private String rangeText(Range r) {
        try {
            BTimeSchedule t = r.sch;
            if (t == null) {
                return "???";
            }
            BStatusValue e = t.getEffectiveValue();
            if (e == null) {
                return "";
            }
            return this.valueText(e);
        }
        catch (Exception x) {
            Utils.error(this, x);
            return "-";
        }
    }

    private void startDrag(double y, boolean create) {
        Range r = this.dragging;
        if (r != null) {
            if (y >= r.finishY() - (double)RANGE_BORDER || create) {
                this.dragType = 0;
                this.minU = r.start + 1;
                this.maxU = r.next == null ? this.units : r.next.startRange;
                this.setMouseCursor(MouseCursor.sResize);
            } else if (y <= r.startY() + (double)RANGE_BORDER) {
                this.setMouseCursor(MouseCursor.nResize);
                this.dragType = 2;
                this.minU = r.prev == null ? 0 : r.prev.finishRange;
                this.maxU = r.finish - 1;
            } else {
                this.setMouseCursor(MouseCursor.grabHand);
                this.dragType = 1;
                this.pressedOffset = y - r.startY();
                int h = this.dragging.finish - this.dragging.start;
                this.minU = r.prev == null ? 0 : r.prev.finishRange;
                this.maxU = r.next == null ? this.units - h : r.next.startRange - h;
            }
        } else {
            r = this.predecessor(y);
            if (r == null) {
                this.minU = 0;
                this.maxU = this.first == null ? this.units : this.first.start;
            } else {
                this.minU = r.finish;
                this.maxU = r.next == null ? this.units : r.start;
            }
            this.setMouseCursor(MouseCursor.sResize);
        }
    }

    private String valueText(BStatusValue v) {
        if (v.getStatus().isNull()) {
            return this.lex("day.null");
        }
        return v.getValueValue().toString((Context)this.facets);
    }

    public class Range {
        Range next;
        Range prev;
        BTimeSchedule sch;
        BDaySlider slider;
        private int start;
        private int finish;
        int startRange;
        int finishRange;
        private ScheduleColors colors;

        Range(BDaySlider slider, BTimeSchedule sch) {
            this.slider = slider;
            this.sch = sch;
            this.updateUnits();
            this.updateColors();
        }

        Range(BDaySlider slider, BTimeSchedule sch, int start, int finish) {
            this.slider = slider;
            this.sch = sch;
            this.start = start;
            this.finish = finish;
            this.updateRangeUnits();
            this.updateColors();
        }

        public int getFinish() {
            return this.finish;
        }

        public int getStart() {
            return this.start;
        }

        public ScheduleColors getColors() {
            return this.colors;
        }

        final double finishY() {
            return this.slider.unitToY(this.finish);
        }

        public BDaySlider getSlider() {
            return this.slider;
        }

        public Object getValue() {
            return this.sch.getEffectiveValue();
        }

        final double height() {
            double f = this.slider.unitToY(this.finish);
            double s = this.slider.unitToY(this.start);
            return Math.max(f - s, 1.0);
        }

        final double startY() {
            return this.slider.unitToY(this.start);
        }

        final void updateFinishTime() {
            this.sch.setFinish(BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(this.finish, false))));
            this.updateRangeUnits();
        }

        final void updateStartTime() {
            this.sch.setStart(BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(this.start, true))));
            this.updateRangeUnits();
        }

        final void updateUnits() {
            this.start = BDaySlider.this.millisToUnit(this.sch.getStart().getTimeOfDayMillis(), true);
            this.finish = BDaySlider.this.millisToUnit(this.sch.getFinish().getTimeOfDayMillis(), false);
            this.updateRangeUnits();
        }

        final void updateRangeUnits() {
            this.startRange = BDaySlider.this.millisToRangeUnit(this.sch.getStart().getTimeOfDayMillis(), true);
            this.finishRange = BDaySlider.this.millisToRangeUnit(this.sch.getFinish().getTimeOfDayMillis(), false);
        }

        void updateColors() {
            this.colors = new ScheduleColors(this.sch.getEffectiveValue());
        }
    }

    private class CmdScheduleDefaults
    extends Command {
        CmdScheduleDefaults() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.schedule_defaults"));
        }

        public CommandArtifact doInvoke() {
            Range cur = BDaySlider.this.first;
            if (cur == null) {
                BDaySlider.this.select(BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), 0, BDaySlider.this.units));
                return null;
            }
            Object sch = null;
            if (cur.start != 0) {
                cur = BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(0, true))), cur.sch.getStart());
            }
            Range next = cur.next;
            while (cur != null) {
                next = cur.next;
                if (next == null) {
                    if (cur.finish != BDaySlider.this.units) {
                        BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), cur.sch.getFinish(), BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(BDaySlider.this.units, false))));
                    }
                } else if (!cur.sch.getFinish().equals((Object)next.sch.getStart())) {
                    BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), cur.sch.getFinish(), next.sch.getStart());
                }
                cur = next;
            }
            BDaySlider.this.repaint();
            BDaySlider.this.fireModified(null);
            return null;
        }
    }

    private class CmdPaste
    extends Command {
        CmdPaste() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.paste_day"));
        }

        public CommandArtifact doInvoke() {
            if (BDaySlider.this.clipboard != null) {
                BDaySlider.this.clearDay();
                BDaySlider.this.copy(BDaySlider.this.clipboard.get());
            }
            BDaySlider.this.repaint();
            BDaySlider.this.fireModified(null);
            return null;
        }
    }

    private class CmdFill
    extends Command {
        CmdFill() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.apply_weekdays"));
        }

        public CommandArtifact doInvoke() {
            BDaySlider.this.fireFillWeek(BDaySlider.this.schedule);
            return null;
        }
    }

    private class CmdDelete
    extends Command {
        CmdDelete() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.delete"));
        }

        public CommandArtifact doInvoke() {
            BDaySlider.this.remove(BDaySlider.this.selected);
            BDaySlider.this.repaint();
            return null;
        }
    }

    private class CmdCopy
    extends Command {
        CmdCopy() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.copy_day"));
        }

        public CommandArtifact doInvoke() {
            if (BDaySlider.this.clipboard != null) {
                BDaySlider.this.clipboard.set((BDaySchedule)BDaySlider.this.schedule.newCopy(true));
            }
            return null;
        }
    }

    private class CmdClearWeek
    extends Command {
        CmdClearWeek() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.clear_week"));
        }

        public CommandArtifact doInvoke() {
            BDaySlider.this.fireClearWeek(null);
            return null;
        }
    }

    private class CmdClear
    extends Command {
        CmdClear() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.clear_day"));
        }

        public CommandArtifact doInvoke() {
            BDaySlider.this.clearDay();
            BDaySlider.this.repaint();
            return null;
        }
    }

    private class CmdAllDay
    extends Command {
        CmdAllDay() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.all_day"));
        }

        public CommandArtifact doInvoke() {
            BDaySlider.this.clearDay();
            BDaySlider.this.select(BDaySlider.this.add((Object)BDaySlider.this.newEffectiveValue(), 0, BDaySlider.this.units));
            BDaySlider.this.fireModified(null);
            return null;
        }
    }

    public static interface Clipboard {
        public BDaySchedule get();

        public BStatusValue newEffectiveValue();

        public void set(BDaySchedule var1);
    }
}

