/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BDayOfMonthEd;
import com.tridium.schedule.ui.BMonthEd;
import com.tridium.schedule.ui.BWeekdayEd;
import com.tridium.schedule.ui.BYearEd;
import com.tridium.workbench.util.BDatePickerCalendar;
import javax.baja.gx.BImage;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BGridPane;

public class BDateEd
extends BAbstractScheduleWidget {
    public static final Action dayModified = BDateEd.newAction((int)0, null);
    public static final Action monthModified = BDateEd.newAction((int)0, null);
    public static final Action showCalendar = BDateEd.newAction((int)0, null);
    public static final Action weekdayModified = BDateEd.newAction((int)0, null);
    public static final Action yearModified = BDateEd.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BDateEd.class);
    boolean range = false;
    BDateSchedule schedule;
    BButton calendar;
    BDayOfMonthEd dom;
    BMonthEd mon;
    BDateEd otherRange;
    BWeekdayEd wkd;
    BYearEd year;

    public void dayModified() {
        this.invoke(dayModified, null, null);
    }

    public void monthModified() {
        this.invoke(monthModified, null, null);
    }

    public void showCalendar() {
        this.invoke(showCalendar, null, null);
    }

    public void weekdayModified() {
        this.invoke(weekdayModified, null, null);
    }

    public void yearModified() {
        this.invoke(yearModified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDateEd() {
        this(false);
    }

    public BDateEd(boolean range) {
        String order;
        this.range = range;
        BGridPane gp = null;
        gp = range ? new BGridPane(4) : new BGridPane(5);
        this.calendar = new BButton(BImage.make((String)"module://icons/x16/calendar.png"));
        this.calendar.setButtonStyle(BButtonStyle.toolBar);
        this.year = new BYearEd();
        this.dom = new BDayOfMonthEd(true);
        this.mon = new BMonthEd(true);
        if (!range) {
            this.wkd = new BWeekdayEd();
        }
        if ((order = this.lex("date.displayOrder")).equals("date.displayOrder")) {
            order = "wdmyc";
        }
        order = order.trim().toLowerCase();
        block7: for (int i = 0; i < order.length(); ++i) {
            char ch = order.charAt(i);
            switch (order.charAt(i)) {
                case 'c': {
                    gp.add(null, (BValue)this.calendar);
                    continue block7;
                }
                case 'd': {
                    gp.add(null, (BValue)this.dom);
                    continue block7;
                }
                case 'm': {
                    gp.add(null, (BValue)this.mon);
                    continue block7;
                }
                case 'w': {
                    if (range) continue block7;
                    gp.add(null, (BValue)this.wkd);
                    continue block7;
                }
                case 'y': {
                    gp.add(null, (BValue)this.year);
                }
            }
        }
        this.linkTo((BComponent)this.dom, (Slot)BDayOfMonthEd.modified, (Slot)dayModified);
        this.linkTo((BComponent)this.mon, (Slot)BMonthEd.modified, (Slot)monthModified);
        if (!range) {
            this.linkTo((BComponent)this.wkd, (Slot)BWeekdayEd.modified, (Slot)weekdayModified);
        }
        this.linkTo((BComponent)this.year, (Slot)BYearEd.modified, (Slot)yearModified);
        this.linkTo((BComponent)this.calendar, (Slot)BButton.actionPerformed, (Slot)showCalendar);
        this.setContent((BWidget)gp);
    }

    public void load(BDateSchedule schedule) {
        this.schedule = schedule;
        this.calendar.setEnabled(!this.isReadonly());
        this.year.setReadonly(this.isReadonly());
        this.dom.setReadonly(this.isReadonly());
        this.mon.setReadonly(this.isReadonly());
        this.year.load(schedule.getYearSchedule());
        this.dom.load((BEnumSetSchedule)schedule.getDaySchedule());
        this.mon.load((BEnumSetSchedule)schedule.getMonthSchedule());
        if (!this.range) {
            this.wkd.setReadonly(this.isReadonly());
            this.wkd.load((BEnumSetSchedule)schedule.getWeekdaySchedule());
        }
    }

    public void doDayModified() {
        this.fireModified(null);
    }

    public void doMonthModified() {
        this.fireModified(null);
    }

    public void doShowCalendar() {
        BDatePickerCalendar picker;
        BAbsTime t = Clock.time();
        int yr = t.getYear();
        BMonth mo = t.getMonth();
        if (this.otherRange != null) {
            if (this.otherRange.schedule.getYear() >= 0) {
                yr = this.otherRange.schedule.getYear();
            }
            if (this.otherRange.schedule.getMonth() >= 0) {
                mo = BMonth.make((int)this.otherRange.schedule.getMonth());
            }
        }
        if ((picker = BDatePickerCalendar.dialog((BWidget)this, (int)yr, (BMonth)mo)) != null) {
            if (!this.range) {
                this.wkd.select(this.wkd.getWildcard());
            }
            this.dom.select(picker.day);
            this.mon.select(picker.month.getOrdinal());
            this.year.select(picker.year);
            this.repaint();
            this.fireModified(null);
        }
    }

    public void doWeekdayModified() {
        this.fireModified(null);
    }

    public void doYearModified() {
        this.fireModified(null);
    }

    @Override
    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        this.year.setReadonly(ro);
        this.calendar.setEnabled(!ro);
        this.dom.setReadonly(ro);
        this.mon.setReadonly(ro);
        if (!this.range) {
            this.wkd.setReadonly(ro);
        }
    }
}

