/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.BAuxWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"schedule:WeeklySchedule"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="foreground", type="BBrush", defaultValue="BColor.make(0x666699).toBrush()"), @NiagaraProperty(name="foregroundText", type="BBrush", defaultValue="BColor.white.toBrush()"), @NiagaraProperty(name="background", type="BBrush", defaultValue="BColor.make(0xeeeeee).toBrush()"), @NiagaraProperty(name="backgroundGrid", type="BBrush", defaultValue="BColor.make(0xcccccc).toBrush()"), @NiagaraProperty(name="backgroundText", type="BBrush", defaultValue="BColor.make(0x666666).toBrush()"), @NiagaraProperty(name="hyperlinkActive", type="boolean", defaultValue="true"), @NiagaraProperty(name="showTimeIn12HourFormat", type="boolean", defaultValue="false")})
public class BCurrentDaySummary
extends BWbComponentView {
    public static final Property foreground = BCurrentDaySummary.newProperty((int)0, (BValue)BColor.make((int)0x666699).toBrush(), null);
    public static final Property foregroundText = BCurrentDaySummary.newProperty((int)0, (BValue)BColor.white.toBrush(), null);
    public static final Property background = BCurrentDaySummary.newProperty((int)0, (BValue)BColor.make((int)0xEEEEEE).toBrush(), null);
    public static final Property backgroundGrid = BCurrentDaySummary.newProperty((int)0, (BValue)BColor.make((int)0xCCCCCC).toBrush(), null);
    public static final Property backgroundText = BCurrentDaySummary.newProperty((int)0, (BValue)BColor.make((int)0x666666).toBrush(), null);
    public static final Property hyperlinkActive = BCurrentDaySummary.newProperty((int)0, (boolean)true, null);
    public static final Property showTimeIn12HourFormat = BCurrentDaySummary.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BCurrentDaySummary.class);
    private TimeFormatCommand timeFormatCommand;
    private Widget support;
    private ArrayList<Object> events = new ArrayList();
    private Updater updater;
    private BObject toUpdate;

    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    public void setForeground(BBrush v) {
        this.set(foreground, (BValue)v, null);
    }

    public BBrush getForegroundText() {
        return (BBrush)this.get(foregroundText);
    }

    public void setForegroundText(BBrush v) {
        this.set(foregroundText, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public BBrush getBackgroundGrid() {
        return (BBrush)this.get(backgroundGrid);
    }

    public void setBackgroundGrid(BBrush v) {
        this.set(backgroundGrid, (BValue)v, null);
    }

    public BBrush getBackgroundText() {
        return (BBrush)this.get(backgroundText);
    }

    public void setBackgroundText(BBrush v) {
        this.set(backgroundText, (BValue)v, null);
    }

    public boolean getHyperlinkActive() {
        return this.getBoolean(hyperlinkActive);
    }

    public void setHyperlinkActive(boolean v) {
        this.setBoolean(hyperlinkActive, v, null);
    }

    public boolean getShowTimeIn12HourFormat() {
        return this.getBoolean(showTimeIn12HourFormat);
    }

    public void setShowTimeIn12HourFormat(boolean v) {
        this.setBoolean(showTimeIn12HourFormat, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCurrentDaySummary() {
        this.support = new Widget();
        this.setContent((BWidget)new BAuxWidget((BAuxWidget.Support)this.support));
    }

    public void stopped() throws Exception {
        if (this.updater != null) {
            this.updater.kill = true;
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(200.0, 40.0);
    }

    public void doLoadValue(BObject value, Context cx) {
        BWeeklySchedule schedule = (BWeeklySchedule)value;
        schedule.lease(Integer.MAX_VALUE);
        this.events.clear();
        BAbsTime time = BAbsTime.now().timeOfDay(0, 0, 0, 0);
        BAbsTime end = time.nextDay();
        while (time != null && time.isBefore(end)) {
            BAbstractSchedule source = schedule.getOutputSource(time);
            if (source instanceof BTimeSchedule) {
                this.events.add(source);
                this.events.add(schedule.getOutput(time).getValueValue().toString((Context)schedule.getFacets()));
            }
            time = schedule.nextEvent(time);
        }
        BAuxWidget content = (BAuxWidget)this.getContent();
        content.setSupport((BAuxWidget.Support)this.support);
        content.relayout();
        this.registerForComponentEvents((BComponent)schedule);
        if (this.updater == null && Sys.getStation() == null) {
            this.updater = new Updater();
            this.updater.start();
        }
        this.timeFormatCommand = new TimeFormatCommand((BWidget)this);
    }

    public void handleComponentEvent(BComponentEvent event) {
        BComponent c = event.getSourceComponent();
        if (c == this.getCurrentValue()) {
            this.toUpdate = c;
        }
    }

    public BMenu[] getViewMenus() {
        BMenu menu = UiLexicon.makeUiLexicon((BModule)this.getType().getModule()).buildMenu("menu.currentDaySummary.label");
        menu.add("timeFormat", (Command)this.timeFormatCommand);
        return new BMenu[]{menu};
    }

    public class TimeFormatCommand
    extends ToggleCommand {
        public TimeFormatCommand(BWidget owner) {
            super(owner, BCurrentDaySummary.this.getType().getModule(), "commands.timeFormat");
            super.setSelected(BCurrentDaySummary.this.getShowTimeIn12HourFormat());
        }

        public void setSelected(boolean s) {
            super.setSelected(s);
            BCurrentDaySummary.this.setShowTimeIn12HourFormat(s);
            BCurrentDaySummary.this.repaint();
        }
    }

    class Updater
    extends Thread {
        boolean kill = false;

        Updater() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.kill) {
                    return;
                }
                if (BCurrentDaySummary.this.toUpdate == null) continue;
                BCurrentDaySummary.this.loadValue(BCurrentDaySummary.this.toUpdate, BCurrentDaySummary.this.getCurrentContext());
                BCurrentDaySummary.this.toUpdate = null;
            }
        }
    }

    class Widget
    extends BAuxWidget.Support {
        Widget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g, double w, double h) {
            BFont font = Theme.widget().getTextFont();
            g.setBrush(BCurrentDaySummary.this.getBackground());
            g.fillRect(0.0, 0.0, w, h);
            double dw = w / 24.0;
            g.setFont(font);
            for (int i = 0; i < 24; ++i) {
                double dx = (double)i * dw;
                if (i > 0) {
                    g.setBrush(BCurrentDaySummary.this.getBackgroundGrid());
                    g.strokeLine(dx, 0.0, dx, h);
                }
                g.setBrush(BCurrentDaySummary.this.getBackgroundText());
                if (BCurrentDaySummary.this.getShowTimeIn12HourFormat()) {
                    int hour = i % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    g.drawString(String.valueOf(hour), dx + 3.0, h - 5.0);
                    continue;
                }
                g.drawString(String.valueOf(i), dx + 3.0, h - 5.0);
            }
            double dy = 0.0;
            double dh = h - font.getHeight() - 5.0 - dy;
            for (int i = 0; i < BCurrentDaySummary.this.events.size(); i += 2) {
                BTimeSchedule time = (BTimeSchedule)BCurrentDaySummary.this.events.get(i);
                String value = (String)BCurrentDaySummary.this.events.get(i + 1);
                BTime start = time.getStart();
                BTime finish = time.getFinish();
                double x1 = (double)start.getHour() + (double)start.getMinute() / 60.0;
                double x2 = (double)finish.getHour() + (double)finish.getMinute() / 60.0;
                if (finish.getHour() == 0 && finish.getMinute() == 0 && finish.getSecond() == 0) {
                    x2 = 24.0;
                }
                x1 = x1 / 24.0 * w;
                x2 = x2 / 24.0 * w;
                g.push();
                try {
                    g.clip(x1, dy, x2 - x1, dh);
                    g.setBrush(BCurrentDaySummary.this.getForeground());
                    g.fillRect(x1, dy, x2 - x1, dh);
                    g.setBrush(BColor.black.toBrush());
                    g.strokeRect(x1, dy, x2 - x1 - 1.0, dh - 1.0);
                    g.setBrush(BCurrentDaySummary.this.getForegroundText());
                    g.drawString(value, x1 + 4.0, dy + 3.0 + font.getAscent());
                    continue;
                }
                finally {
                    g.pop();
                }
            }
            g.setBrush(BColor.black.toBrush());
            g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        }

        public void mousePressed(BMouseEvent event) {
            if (!BCurrentDaySummary.this.getHyperlinkActive()) {
                return;
            }
            BOrd ord = BCurrentDaySummary.this.getCurrentValue().asComponent().getNavOrd();
            BHyperlinkMode mode = event.isControlDown() ? BHyperlinkMode.newTab : BHyperlinkMode.replace;
            BCurrentDaySummary.this.getWbShell().hyperlink(new HyperlinkInfo(ord, mode));
        }

        public void mouseEntered(BMouseEvent event) {
            if (!BCurrentDaySummary.this.getHyperlinkActive()) {
                return;
            }
            BCurrentDaySummary.this.setMouseCursor(MouseCursor.hand);
        }

        public void mouseExited(BMouseEvent event) {
            if (!BCurrentDaySummary.this.getHyperlinkActive()) {
                return;
            }
            BCurrentDaySummary.this.setMouseCursor(null);
        }
    }
}

