/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BCompositeEd;
import com.tridium.schedule.ui.BScheduleFE;
import com.tridium.schedule.ui.SelectionItem;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;

public class BCompositeAdd
extends BAbstractScheduleWidget {
    public static final Action selectionChanged = BCompositeAdd.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCompositeAdd.class);
    boolean controlSchedule;
    Context cx;
    BCompositeEd ed;
    BEdgePane edgePane;
    BScheduleFE fe;
    BTextField name;
    BAbstractSchedule selected;
    BListDropDown typesList;

    public void selectionChanged() {
        this.invoke(selectionChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCompositeAdd(BCompositeEd ed, String defaultName, boolean controlSchedule, Context cx) {
        this.ed = ed;
        this.controlSchedule = controlSchedule;
        this.cx = cx;
        this.typesList = new BListDropDown();
        BList list = this.typesList.getList();
        list.setMultipleSelection(false);
        this.loadList(list);
        this.linkTo((BComponent)this.typesList, (Slot)BListDropDown.listActionPerformed, (Slot)selectionChanged);
        this.name = new BTextField(defaultName);
        this.name.setVisibleColumns(40);
        BGridPane gp = new BGridPane(2);
        gp.setValign(BValign.center);
        gp.setHalign(BHalign.left);
        gp.add("nameLabel", (BValue)new BLabel(this.lex("composite.name")));
        gp.add("name", (BValue)this.name);
        gp.add("typeLabel", (BValue)new BLabel(this.lex("composite.scheduleType")));
        gp.add("type", (BValue)this.typesList);
        this.edgePane = new BEdgePane();
        this.edgePane.setTop((BWidget)gp);
        this.setContent((BWidget)this.edgePane);
        this.typesList.setSelectedIndex(0);
        this.doSelectionChanged();
    }

    public void doSelectionChanged() {
        SelectionItem item = (SelectionItem)this.typesList.getSelectedItem();
        this.selected = (BAbstractSchedule)item.value;
        this.fe = new BScheduleFE(this.ed.getView().getBase());
        this.fe.loadValue((BObject)this.selected, this.cx);
        BBorderPane bp = new BBorderPane((BWidget)this.fe);
        this.edgePane.setCenter((BWidget)bp);
        BWidgetShell shell = this.getShell();
        if (shell instanceof BDialog) {
            BDialog d = (BDialog)shell;
            this.computePreferredSize();
            d.setScreenSizeToPreferredSize();
            d.relayout();
        }
    }

    public BAbstractSchedule getSchedule() {
        if (this.controlSchedule) {
            return new BDailySchedule(this.selected);
        }
        return this.selected;
    }

    public String name() {
        return this.name.getText();
    }

    public void validate() throws Exception {
        if (this.fe != null) {
            this.fe.validate();
        }
    }

    void loadList(BList list) {
        String str = this.ed.lex("type.dateSchedule");
        BDateSchedule sch = new BDateSchedule();
        BAbsTime t = Clock.time();
        sch.setDay(t.getDay());
        sch.setMonth(t.getMonth().getOrdinal());
        sch.setYear(t.getYear());
        list.addItem((Object)new SelectionItem(str, sch));
        str = this.ed.lex("type.dateRangeSchedule");
        list.addItem((Object)new SelectionItem(str, new BDateRangeSchedule()));
        str = this.ed.lex("type.weekAndDaySchedule");
        list.addItem((Object)new SelectionItem(str, new BWeekAndDaySchedule()));
        str = this.ed.lex("type.customSchedule");
        list.addItem((Object)new SelectionItem(str, new BCustomSchedule()));
        if (this.controlSchedule) {
            str = this.ed.lex("type.scheduleReference");
            list.addItem((Object)new SelectionItem(str, new BScheduleReference()));
        }
    }
}

