/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BMonthWidget;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;

public class BCalendarWidget
extends BAbstractScheduleWidget {
    public static final Action handleSelect = BCalendarWidget.newAction((int)0, (BValue)new BMonthWidget(), null);
    public static final Action nextMonth = BCalendarWidget.newAction((int)0, null);
    public static final Action nextPage = BCalendarWidget.newAction((int)0, null);
    public static final Action prevMonth = BCalendarWidget.newAction((int)0, null);
    public static final Action prevPage = BCalendarWidget.newAction((int)0, null);
    public static final Action updateMonths = BCalendarWidget.newAction((int)16, null);
    public static final Action today = BCalendarWidget.newAction((int)0, null);
    public static final Topic selected = BCalendarWidget.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BCalendarWidget.class);
    BButton butNextMonth;
    BButton butNextPage;
    BButton butPrevMonth;
    BButton butPrevPage;
    BButton butToday;
    BGridPane buttons;
    int cols = 0;
    BGridPane calendar;
    BEdgePane content;
    BMonthWidget current;
    Array<BMonthWidget> months = new Array(BMonthWidget.class);
    static final double pad = 10.0;
    int rows = 0;
    boolean selectable = false;
    BAbstractSchedule schedule;
    BMonthWidget selection;

    public void handleSelect(BMonthWidget arg) {
        this.invoke(handleSelect, (BValue)arg, null);
    }

    public void nextMonth() {
        this.invoke(nextMonth, null, null);
    }

    public void nextPage() {
        this.invoke(nextPage, null, null);
    }

    public void prevMonth() {
        this.invoke(prevMonth, null, null);
    }

    public void prevPage() {
        this.invoke(prevPage, null, null);
    }

    public void updateMonths() {
        this.invoke(updateMonths, null, null);
    }

    public void today() {
        this.invoke(today, null, null);
    }

    public void fireSelected(BAbsTime event) {
        this.fire(selected, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCalendarWidget(boolean selectable) {
        this.selectable = selectable;
        this.buttons = new BGridPane(5);
        BImage img = BImage.make((BIcon)BIcon.std((String)"arrowRight.png"));
        this.butNextMonth = new BButton(img, this.lex("calendar.nextMonth"));
        this.butNextMonth.setButtonStyle(BButtonStyle.toolBar);
        this.butNextMonth.setTextToIconAlign(BAlign.left);
        this.butNextPage = new BButton(img, this.lex("calendar.nextPage"));
        this.butNextPage.setButtonStyle(BButtonStyle.toolBar);
        this.butNextPage.setTextToIconAlign(BAlign.left);
        img = BImage.make((BIcon)BIcon.std((String)"arrowLeft.png"));
        this.butPrevMonth = new BButton(img, this.lex("calendar.prevMonth"));
        this.butPrevMonth.setButtonStyle(BButtonStyle.toolBar);
        this.butPrevMonth.setTextToIconAlign(BAlign.right);
        this.butPrevPage = new BButton(img, this.lex("calendar.prevPage"));
        this.butPrevPage.setButtonStyle(BButtonStyle.toolBar);
        this.butPrevPage.setTextToIconAlign(BAlign.right);
        this.butToday = new BButton(this.lex("calendar.today"));
        this.linkTo((BComponent)this.butNextMonth, (Slot)BButton.actionPerformed, (Slot)nextMonth);
        this.linkTo((BComponent)this.butNextPage, (Slot)BButton.actionPerformed, (Slot)nextPage);
        this.linkTo((BComponent)this.butPrevMonth, (Slot)BButton.actionPerformed, (Slot)prevMonth);
        this.linkTo((BComponent)this.butPrevPage, (Slot)BButton.actionPerformed, (Slot)prevPage);
        this.linkTo((BComponent)this.butToday, (Slot)BButton.actionPerformed, (Slot)today);
        this.buttons.add(null, (BValue)this.butPrevPage);
        this.buttons.add(null, (BValue)this.butPrevMonth);
        this.buttons.add(null, (BValue)this.butToday);
        this.buttons.add(null, (BValue)this.butNextMonth);
        this.buttons.add(null, (BValue)this.butNextPage);
        this.content = new BEdgePane();
        this.content.setTop((BWidget)this.buttons);
        this.calendar = new BGridPane();
        this.calendar.setColumnGap(10.0);
        this.calendar.setRowGap(10.0);
        this.content.setCenter((BWidget)this.calendar);
        BAbsTime t = Clock.time();
        this.current = new BMonthWidget(t.getYear(), t.getMonth());
        this.setContent((BWidget)this.content);
    }

    @Override
    public void computePreferredSize() {
        double w = BMonthWidget.widgetW + 10.0;
        double h = BMonthWidget.widgetH + 10.0;
        this.buttons.computePreferredSize();
        this.setPreferredSize(w * 4.0, h += this.buttons.getPreferredHeight());
    }

    public void doHandleSelect(BMonthWidget mw) {
        this.fireSelected(BAbsTime.make((int)mw.getYear(), (BMonth)mw.getMonth(), (int)mw.getSelection(), (int)0, (int)0, (int)0, (int)0));
        if (this.selection == mw) {
            return;
        }
        if (this.selection != null) {
            this.selection.setSelection(-1);
            this.selection.repaint();
        }
        this.selection = mw;
        this.selection.repaint();
    }

    @Override
    public void doLayout(BWidget[] kids) {
        int rows;
        int ttl;
        this.content.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
        int cols = this.computeCols();
        if (cols != this.calendar.getColumnCount()) {
            this.calendar.setColumnCount(cols);
        }
        if ((ttl = cols * (rows = this.computeRows())) != this.months.size()) {
            this.fillCal(this.current.getStart());
            if (this.selection == null && this.schedule != null) {
                this.doToday();
            }
        }
    }

    public void doNextMonth() {
        this.fillCal(this.nextMonth(this.current.getStart()));
    }

    public void doNextPage() {
        BMonthWidget w = (BMonthWidget)((Object)this.months.peek());
        this.fillCal(this.nextMonth(w.getStart()));
    }

    public void doPrevMonth() {
        this.fillCal(this.prevMonth(this.current.getStart()));
    }

    public void doPrevPage() {
        int count = this.computeCols() * this.computeRows();
        BAbsTime t = this.current.getStart();
        int year = t.getYear();
        BMonth month = t.getMonth();
        while (--count >= 0) {
            if (month == BMonth.january) {
                --year;
                month = BMonth.december;
                continue;
            }
            month = month.previous();
        }
        this.fillCal(BAbsTime.make((int)year, (BMonth)month, (int)1, (int)0, (int)0, (int)0, (int)0));
    }

    public void doToday() {
        BAbsTime t = Clock.time();
        this.fillCal(t);
        this.current.setSelection(t.getDay());
        this.doHandleSelect(this.current);
    }

    public synchronized void doUpdateMonths() {
        BMonthWidget[] ary = (BMonthWidget[])this.months.array();
        int i = this.months.size();
        while (--i >= 0) {
            this.highlight(ary[i]);
        }
        this.repaint();
    }

    public void setSchedule(BAbstractSchedule sch) {
        this.schedule = sch;
        this.updateMonths();
    }

    public void syncSchedule(BAbstractSchedule sch) {
        this.schedule = sch;
        this.doUpdateMonths();
    }

    private int computeCols() {
        return (int)(this.getWidth() / (BMonthWidget.widgetW + 10.0));
    }

    private int computeRows() {
        double h = this.getHeight() - this.buttons.getHeight() - 10.0;
        int ret = (int)(h / (BMonthWidget.widgetH + 10.0));
        if (ret == 0) {
            return 1;
        }
        return ret;
    }

    private synchronized void fillCal(BAbsTime from) {
        BAbsTime now = Clock.time();
        int nowYear = now.getYear();
        BMonth nowMo = now.getMonth();
        this.butToday.setEnabled(true);
        this.months.clear();
        this.calendar.removeAll();
        int cols = this.computeCols();
        int ttl = cols * this.computeRows();
        BAbsTime cur = from;
        for (int i = 0; i < ttl; ++i) {
            BMonthWidget w = new BMonthWidget(cur.getYear(), cur.getMonth());
            w.setSelectable(this.selectable);
            if (i == 0) {
                this.current = w;
            }
            if (cur.getYear() == nowYear && cur.getMonth() == nowMo && !this.selectable) {
                w.setSelection(now.getDay());
            }
            this.highlight(w);
            this.linkTo((BComponent)w, (Slot)BMonthWidget.selected, (Slot)handleSelect);
            this.calendar.add(null, (BValue)w);
            this.months.add((Object)w);
            cur = this.nextMonth(cur);
        }
    }

    private void highlight(BMonthWidget widget) {
        widget.clearHighlights();
        if (this.schedule == null) {
            return;
        }
        BAbsTime current = widget.getStart();
        BAbsTime nextDay = this.nextDay(current);
        BAbsTime end = this.nextMonth(current);
        while (current.isBefore(end)) {
            if (this.schedule.isEffective(current)) {
                widget.highlight(current.getDay());
            } else if ((current = this.schedule.next(true, current, nextDay)) != null) {
                widget.highlight(current.getDay());
            }
            current = nextDay;
            nextDay = this.nextDay(current);
        }
    }

    private BAbsTime nextDay(BAbsTime t) {
        return t.nextDay().timeOfDay(0, 0, 0, 0);
    }

    private BAbsTime nextMonth(BAbsTime t) {
        BMonth m = t.getMonth();
        if (m == BMonth.december) {
            return BAbsTime.make((int)(t.getYear() + 1), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0);
        }
        return BAbsTime.make((int)t.getYear(), (BMonth)m.next(), (int)1, (int)0, (int)0, (int)0, (int)0);
    }

    private BAbsTime prevMonth(BAbsTime t) {
        BMonth m = t.getMonth();
        if (m == BMonth.january) {
            return BAbsTime.make((int)(t.getYear() - 1), (BMonth)BMonth.december, (int)1, (int)0, (int)0, (int)0, (int)0);
        }
        return BAbsTime.make((int)t.getYear(), (BMonth)m.previous(), (int)1, (int)0, (int)0, (int)0, (int)0);
    }
}

