/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.export.impl.destination;

import com.tridium.nre.platform.OperatingSystemEnum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.export.BIExportDestinationType;
import javax.baja.export.BITransformOperation;
import javax.baja.export.ExportException;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraSingleton
public final class BLaunchExternalApplicationDestinationType
extends BSingleton
implements BIExportDestinationType<Context> {
    public static final BLaunchExternalApplicationDestinationType INSTANCE = new BLaunchExternalApplicationDestinationType();
    public static final Type TYPE = Sys.loadType(BLaunchExternalApplicationDestinationType.class);
    private static final char[] INVALID_CHARACTERS = new char[]{'{', '}', '(', ')', '<', '>', '&', '*', '\u2018', '|', '=', '?', ';', '[', ']', '$', '^', '#', '~', '!', '%', '@', '+', ',', '`'};
    private static final boolean HEADLESS = AccessController.doPrivileged(() -> Boolean.getBoolean("java.awt.headless"));
    private static final LexiconModule LEX = LexiconModule.make((String)"export");

    public Type getType() {
        return TYPE;
    }

    private BLaunchExternalApplicationDestinationType() {
    }

    @Override
    public void checkValid(Context cx) throws ExportException {
        if (Sys.getStation() == null) {
            throw new ExportException("Only valid in station");
        }
    }

    @Override
    public String getDisplayName(Context cx) {
        return LEX.get("exporter.action.launchExternal.label", cx);
    }

    @Override
    public <T, X extends Context> void transform(BITransformOperation<T, ? super X> transformOperation, X cx) throws IOException, ExportException {
        String filePath = BLaunchExternalApplicationDestinationType.getFilePath(cx);
        try (InputStream data = transformOperation.doTransform(cx);){
            Path path = Paths.get(filePath, new String[0]);
            Files.copy(data, path, StandardCopyOption.REPLACE_EXISTING);
            BLaunchExternalApplicationDestinationType.launchExternal(path.toFile());
        }
    }

    private static String getFilePath(Context cx) throws ExportException {
        BObject filePath = cx.getFacet("filePath");
        if (filePath == null) {
            throw new ExportException("filePath facet required");
        }
        return filePath.toString();
    }

    public static void launchExternal(File file) {
        if (HEADLESS) {
            throw new UnsupportedOperationException("Display required to launch external application");
        }
        try {
            AccessController.doPrivileged(() -> {
                BLaunchExternalApplicationDestinationType.openFileExternal(file);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new BajaRuntimeException((Throwable)e.getException());
        }
    }

    private static void openFileExternal(File fileToOpen) throws IOException {
        String pathToFile = BLaunchExternalApplicationDestinationType.formatPath(fileToOpen);
        if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
            Runtime.getRuntime().exec("xdg-open " + pathToFile);
        } else if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
            Runtime.getRuntime().exec("cmd.exe /c start " + pathToFile);
        } else {
            throw new IllegalStateException("Unknown OS " + OperatingSystemEnum.getOS());
        }
    }

    private static String formatPath(File file) {
        String[] filePathElements;
        try {
            filePathElements = TextUtil.split((String)file.getCanonicalPath(), (char)File.separatorChar);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to canonicalize provided file path", ioe);
        }
        for (String filePathElement : filePathElements) {
            for (char invalidChar : INVALID_CHARACTERS) {
                if (filePathElement.indexOf(invalidChar) == -1) continue;
                throw new IllegalArgumentException("Provided file path contains invalid character '" + invalidChar + "'");
            }
        }
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < filePathElements.length; ++i) {
            if (i > 0) {
                path.append(File.separatorChar);
            }
            if (filePathElements[i].contains(" ")) {
                path.append('\"').append(filePathElements[i]).append('\"');
                continue;
            }
            path.append(filePathElements[i]);
        }
        return path.toString();
    }
}

