/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.ui;

import com.tridium.tagdictionary.condition.BAnd;
import com.tridium.tagdictionary.condition.BBooleanFilter;
import com.tridium.tagdictionary.condition.BHasAncestor;
import com.tridium.tagdictionary.condition.BHasRelation;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import com.tridium.tagdictionary.condition.BNever;
import com.tridium.tagdictionary.condition.BOr;
import com.tridium.tagdictionary.util.ImportExportConst;
import com.tridium.tagdictionary.util.ImportUtil;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BSimpleTagInfo;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.TagRule;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public final class ExportUtil
implements ImportExportConst {
    public static Lexicon lex = Lexicon.make((String)"tagdictionary");
    static Logger log = Logger.getLogger("tagdictionary.export");
    static final String[] header1 = new String[]{"", "", "", "", "", "", "Validity Rules", "", "", "", ""};
    static final String[] header2 = new String[]{"Section", "Rule Name", "Group Name", "Tag name", "Type", "Smart Type", "hasTags", "hasAncestor", "isType", "hasRelation", "hasRelationFilter", "Units"};
    static final String[] tag = new String[]{"#", "", "", "name", "type", "module:class", "opt", "opt", "opt", "opt", "opt", "opt"};
    static final String[] group = new String[]{"#", "", "groupName", "", "", "", "opt", "opt", "opt", "opt", "opt", ""};
    static final String[] groupTags = new String[]{"#(tags)", "", "", "name", "", "", "", "", "", "", "", ""};
    static final String[] relation = new String[]{"#", "", "", "name", "Relation", "", "", "", "", "", "", ""};
    static final String[] rule = new String[]{"#", "ruleName", "", "", "", "", "opt", "opt", "opt", "opt", "opt", ""};
    static final String[] ruleTags = new String[]{"#(tags)", "", "", "name", "type", "module:class", "", "", "", "", "", ""};
    static final String[] ruleGroups = new String[]{"#(group)", "", "groupName", "", "", "", "", "", "", "", "", ""};
    static final String[] ruleRelations = new String[]{"#(relation)", "", "", "name", "Relation", "", "", "", "", "", "", ""};

    public static ArrayList<ImportUtil.ResultInfo> ExportTagDictionary(BTagDictionary dictionary, BOrd file) {
        ArrayList<ImportUtil.ResultInfo> results;
        block14: {
            results = new ArrayList<ImportUtil.ResultInfo>();
            log.fine("Exporting tagDictionary to: " + file);
            BIFile inFile = (BIFile)file.resolve((BObject)dictionary).get();
            if (!(inFile instanceof BCsvFile)) {
                results.add(ImportUtil.ResultInfo.make((String)"File must be a csv file!", (BColor)BColor.red));
                return results;
            }
            OutputStream out = null;
            try {
                BCsvFile csvFile = (BCsvFile)inFile;
                out = csvFile.getOutputStream();
                ExportUtil.exportHeader(dictionary, out);
                int tagCount = ExportUtil.exportTagDefinitions(dictionary, out);
                if (tagCount == 0) {
                    ExportUtil.writeRow(tag, out);
                    ExportUtil.writeTagTypeChoices(out);
                    ExportUtil.writeRow(ExportUtil.newRow(), out);
                }
                int groupCount = ExportUtil.exportTagGroupDefinitions(dictionary, out);
                if (tagCount == 0 && groupCount == 0) {
                    ExportUtil.writeRow(group, out);
                    ExportUtil.writeRow(ExportUtil.newRow(), out);
                    ExportUtil.writeRow(groupTags, out);
                    ExportUtil.writeRow(ExportUtil.newRow(), out);
                }
                int relationCount = ExportUtil.exportRelationDefinitions(dictionary, out);
                if (tagCount == 0 && relationCount == 0) {
                    ExportUtil.writeRow(relation, out);
                }
                int ruleCount = ExportUtil.exportRules(dictionary, out);
                boolean isSmartDictionary = dictionary.getType().is(BSmartTagDictionary.TYPE);
                if (isSmartDictionary && tagCount == 0 && ruleCount == 0) {
                    ExportUtil.writeRow(rule, out);
                    ExportUtil.writeRow(ExportUtil.newRow(), out);
                    ExportUtil.writeRow(ruleTags, out);
                    ExportUtil.writeRow(ExportUtil.newRow(), out);
                    ExportUtil.writeRow(ruleGroups, out);
                    ExportUtil.writeRow(ExportUtil.newRow(), out);
                    ExportUtil.writeRow(ruleRelations, out);
                }
                if (tagCount > 0) {
                    results.add(ImportUtil.ResultInfo.make((String)lex.getText("import.processTags", new Object[]{tagCount}), (BColor)BColor.black));
                }
                if (groupCount > 0) {
                    results.add(ImportUtil.ResultInfo.make((String)lex.getText("import.processGroups", new Object[]{groupCount}), (BColor)BColor.black));
                }
                if (relationCount > 0) {
                    results.add(ImportUtil.ResultInfo.make((String)lex.getText("import.processRelations", new Object[]{relationCount}), (BColor)BColor.black));
                }
                if (ruleCount > 0) {
                    results.add(ImportUtil.ResultInfo.make((String)lex.getText("import.processRules", new Object[]{ruleCount}), (BColor)BColor.black));
                }
                String msg = lex.getText("export.wasExported", new Object[]{dictionary.getName(), inFile.getFileName()});
                results.add(ImportUtil.ResultInfo.make((String)msg, (BColor)BColor.black));
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception e) {
                results.add(ImportUtil.ResultInfo.make((String)e.getMessage(), (BColor)BColor.red));
                e.printStackTrace();
                if (out == null) break block14;
                try {
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return results;
    }

    static void exportHeader(BTagDictionary dictionary, OutputStream out) throws Exception {
        String[] row = ExportUtil.newRow();
        row[0] = "namespace";
        row[1] = dictionary.getNamespace();
        ExportUtil.writeRow(row, out);
        ExportUtil.writeRow(header1, out);
        ExportUtil.writeRow(header2, out);
    }

    static int exportTagDefinitions(BTagDictionary dictionary, OutputStream out) throws Exception {
        String[] row = ExportUtil.newRow();
        row[0] = "TagDefinitions";
        ExportUtil.writeRow(row, out);
        int count = 0;
        for (TagInfo tagInfo : dictionary.getTagDefinitions()) {
            BUnit unit;
            BTagInfo bTagInfo = (BTagInfo)tagInfo;
            String isValidValidity = ExportUtil.isConditionValid(bTagInfo.getValidity());
            if (!isValidValidity.isEmpty()) {
                throw new Exception("tag: " + bTagInfo.getName() + ' ' + isValidValidity);
            }
            StringBuilder hasTags = new StringBuilder();
            StringBuilder hasAncestors = new StringBuilder();
            StringBuilder hasRelation = new StringBuilder();
            StringBuilder hasRelationFilter = new StringBuilder();
            for (BBooleanFilter booleanFilter : (BBooleanFilter[])CompUtil.getDescendants((BComponent)bTagInfo, BBooleanFilter.class)) {
                if (booleanFilter instanceof BHasRelation) {
                    hasRelation.append(((BHasRelation)booleanFilter).getRelationId());
                    hasRelationFilter.append(booleanFilter.getFilter());
                    continue;
                }
                if (booleanFilter instanceof BHasAncestor) {
                    hasAncestors.append(booleanFilter.getFilter());
                    continue;
                }
                hasTags.append(booleanFilter.getFilter());
            }
            StringJoiner isType = new StringJoiner(" ");
            for (BIsTypeCondition condition : (BIsTypeCondition[])CompUtil.getDescendants((BComponent)bTagInfo, BIsTypeCondition.class)) {
                isType.add(condition.getObjectType().toString());
            }
            String isTypeString = isType.toString();
            if (isTypeString.equals("baja:Component")) {
                isTypeString = "";
            }
            String units = "";
            BValue defFacets = bTagInfo.get("defFacets");
            if (defFacets != null && defFacets.getType().is(BFacets.TYPE) && !(unit = (BUnit)((BFacets)defFacets).get("units", (BObject)BUnit.NULL)).isNull()) {
                units = unit.getUnitName();
            }
            row = ExportUtil.newRow();
            row[3] = bTagInfo.getName();
            row[4] = ExportUtil.encodeTagType(bTagInfo.getDefaultValue().getType());
            Type infoType = bTagInfo.getType();
            row[5] = infoType.is(BSimpleTagInfo.TYPE) ? "" : infoType.toString();
            row[6] = hasTags.toString();
            row[7] = hasAncestors.toString();
            row[8] = isTypeString;
            row[9] = hasRelation.toString();
            row[10] = hasRelationFilter.toString();
            row[11] = units;
            ExportUtil.writeRow(row, out);
            ++count;
        }
        return count;
    }

    static int exportTagGroupDefinitions(BTagDictionary dictionary, OutputStream out) throws Exception {
        String[] row = ExportUtil.newRow();
        row[0] = "TagGroupDefinitions";
        ExportUtil.writeRow(row, out);
        int count = 0;
        for (TagGroupInfo tagGroupInfo : dictionary.getTagGroupDefinitions()) {
            BIsTypeCondition[] bIsTypeConditionArray;
            BBooleanFilter[] bBooleanFilterArray;
            BTagGroupInfo bTagGroupInfo = (BTagGroupInfo)tagGroupInfo;
            BTagRuleCondition validity = bTagGroupInfo.getValidity();
            String isValidValidity = ExportUtil.isConditionValid(validity);
            if (!isValidValidity.isEmpty()) {
                throw new Exception("tagGroup: " + bTagGroupInfo.getName() + isValidValidity);
            }
            if (validity instanceof BBooleanFilter) {
                BBooleanFilter[] bBooleanFilterArray2 = new BBooleanFilter[1];
                bBooleanFilterArray = bBooleanFilterArray2;
                bBooleanFilterArray2[0] = (BBooleanFilter)validity;
            } else {
                bBooleanFilterArray = (BBooleanFilter[])CompUtil.getDescendants((BComponent)validity, BBooleanFilter.class);
            }
            BBooleanFilter[] filters = bBooleanFilterArray;
            String hasAncestors = "";
            String hasRelation = "";
            String hasRelationFilter = "";
            String hasTags = "";
            for (BBooleanFilter filter : filters) {
                if (filter instanceof BHasRelation) {
                    hasRelation = ((BHasRelation)filter).getRelationId();
                    hasRelationFilter = filter.getFilter();
                    continue;
                }
                if (filter instanceof BHasAncestor) {
                    hasAncestors = filter.getFilter();
                    continue;
                }
                hasTags = filter.getFilter();
            }
            if (validity instanceof BIsTypeCondition) {
                BIsTypeCondition[] bIsTypeConditionArray2 = new BIsTypeCondition[1];
                bIsTypeConditionArray = bIsTypeConditionArray2;
                bIsTypeConditionArray2[0] = (BIsTypeCondition)validity;
            } else {
                bIsTypeConditionArray = (BIsTypeCondition[])CompUtil.getDescendants((BComponent)validity, BIsTypeCondition.class);
            }
            BIsTypeCondition[] isTypeConds = bIsTypeConditionArray;
            StringJoiner isType = new StringJoiner(" ");
            for (BIsTypeCondition isTypeCond : isTypeConds) {
                String type = isTypeCond.getObjectType().toString();
                if (type.equals("baja:Component")) continue;
                isType.add(isTypeCond.getObjectType().toString());
            }
            row = ExportUtil.newRow();
            row[2] = bTagGroupInfo.getName();
            row[6] = hasTags;
            row[7] = hasAncestors;
            row[8] = isType.toString();
            row[9] = hasRelation;
            row[10] = hasRelationFilter;
            for (TagInfo tagInfo : bTagGroupInfo.getTagList()) {
                row[3] = tagInfo.getName();
                ExportUtil.writeRow(row, out);
                row = ExportUtil.newRow();
            }
            ++count;
        }
        return count;
    }

    static int exportRelationDefinitions(BTagDictionary dictionary, OutputStream out) throws Exception {
        String[] row = ExportUtil.newRow();
        row[0] = "RelationDefinitions";
        ExportUtil.writeRow(row, out);
        int count = 0;
        for (RelationInfo relationInfo : dictionary.getRelationDefinitions()) {
            BRelationInfo bRelationInfo = (BRelationInfo)relationInfo;
            String type = bRelationInfo.getType().toString();
            if (type.equals("tagdictionary:RelationInfo")) {
                type = "";
            }
            row = ExportUtil.newRow();
            row[3] = bRelationInfo.getName();
            row[4] = "Relation";
            row[5] = type;
            ExportUtil.writeRow(row, out);
            ++count;
        }
        return count;
    }

    static int exportRules(BTagDictionary dictionary, OutputStream out) throws Exception {
        if (!dictionary.getType().is(BSmartTagDictionary.TYPE)) {
            return 0;
        }
        BSmartTagDictionary smartTagDictionary = (BSmartTagDictionary)dictionary;
        String[] row = ExportUtil.newRow();
        row[0] = "RuleDefinitions";
        ExportUtil.writeRow(row, out);
        int count = 0;
        for (TagRule thisRule : smartTagDictionary.getTagRules()) {
            BIsTypeCondition[] bIsTypeConditionArray;
            BTagRule tagRule = (BTagRule)thisRule;
            BTagRuleCondition condition = tagRule.getCondition();
            String isValidCondition = ExportUtil.isConditionValid(condition);
            if (!isValidCondition.isEmpty()) {
                throw new Exception("tagGroup: " + tagRule.getName() + isValidCondition);
            }
            String hasAncestors = "";
            String hasRelation = "";
            String hasRelationFilter = "";
            String hasTags = "";
            for (BBooleanFilter filter : (BBooleanFilter[])CompUtil.getDescendants((BComponent)tagRule, BBooleanFilter.class)) {
                if (!(filter.getParent() instanceof BTagRule) && !(filter.getParent().getParent() instanceof BTagRule) && !(filter.getParent().getParent().getParent() instanceof BTagRule)) continue;
                if (filter instanceof BHasRelation) {
                    hasRelation = ((BHasRelation)filter).getRelationId();
                    hasRelationFilter = filter.getFilter();
                    continue;
                }
                if (filter instanceof BHasAncestor) {
                    hasAncestors = filter.getFilter();
                    continue;
                }
                hasTags = filter.getFilter();
            }
            if (condition instanceof BIsTypeCondition) {
                BIsTypeCondition[] bIsTypeConditionArray2 = new BIsTypeCondition[1];
                bIsTypeConditionArray = bIsTypeConditionArray2;
                bIsTypeConditionArray2[0] = (BIsTypeCondition)condition;
            } else {
                bIsTypeConditionArray = (BIsTypeCondition[])CompUtil.getDescendants((BComponent)condition, BIsTypeCondition.class);
            }
            BIsTypeCondition[] isTypeConds = bIsTypeConditionArray;
            StringJoiner isType = new StringJoiner(" ");
            for (BIsTypeCondition isTypeCond : isTypeConds) {
                String type = isTypeCond.getObjectType().toString();
                if (type.equals("baja:Component")) continue;
                isType.add(isTypeCond.getObjectType().toString());
            }
            row = ExportUtil.newRow();
            row[1] = tagRule.getName();
            row[6] = hasTags;
            row[7] = hasAncestors;
            row[8] = isType.toString();
            row[9] = hasRelation;
            row[10] = hasRelationFilter;
            for (TagInfo tagInfo : tagRule.getTagList()) {
                row[3] = tagInfo.getName();
                ExportUtil.writeRow(row, out);
                row = ExportUtil.newRow();
            }
            for (TagGroupInfo groupInfo : tagRule.getTagGroupList()) {
                row[2] = groupInfo.getName();
                ExportUtil.writeRow(row, out);
                row = ExportUtil.newRow();
            }
            for (RelationInfo relationInfo : tagRule.getRelationList()) {
                row[3] = relationInfo.getName();
                row[4] = "Relation";
                ExportUtil.writeRow(row, out);
                row = ExportUtil.newRow();
            }
            ++count;
        }
        return count;
    }

    private static String isConditionValid(BTagRuleCondition condition) {
        String results = "";
        if (condition instanceof BNever) {
            results = lex.getText("export.no.never");
        } else if (((BAnd[])CompUtil.getDescendants((BComponent)condition, BAnd.class)).length > 0) {
            results = lex.getText("export.no.nestedAnd");
        } else if (((BOr[])CompUtil.getDescendants((BComponent)condition, BOr.class)).length > 1) {
            results = lex.getText("export.limit.nestedOr");
        } else if (((BNever[])CompUtil.getDescendants((BComponent)condition, BNever.class)).length > 0) {
            results = lex.getText("export.no.nestedNever");
        }
        return results;
    }

    private static String encodeTagType(Type type) throws Exception {
        for (int i = 0; i < tagImportTypes.length; ++i) {
            if (!tagImportTypes[i].equals(type)) continue;
            return tagImportTypeStrings[i];
        }
        throw new Exception(type + lex.getText("export.invalidType"));
    }

    static void writeTagTypeChoices(OutputStream out) {
        String[] row = ExportUtil.newRow();
        row[0] = "#";
        String[] stringArray = tagImportTypeStrings;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String tagImportTypeString;
            row[4] = tagImportTypeString = stringArray[i];
            try {
                ExportUtil.writeRow(row, out);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void writeRow(String[] row, OutputStream out) throws Exception {
        for (int i = 0; i < row.length; ++i) {
            out.write(row[i].getBytes());
            if (i >= 11) continue;
            out.write(44);
        }
        out.write("\r\n".getBytes());
    }

    static String[] newRow() {
        String[] values = new String[12];
        for (int i = 0; i < values.length; ++i) {
            values[i] = "";
        }
        return values;
    }
}

