/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.typenode;

import com.tridium.box.json.BlackListedTypes;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.typenode.CommonTypes;
import com.tridium.box.typenode.ContractEncoderVisitor;
import com.tridium.box.typenode.TypeNode;
import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.sys.schema.ComplexType;
import java.util.Optional;
import javax.baja.box.BBoxClientEnv;
import javax.baja.box.BIBoxTypeExt;
import javax.baja.naming.BOrdScheme;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.JsInfo;

public final class RegistryEncoderVisitor
extends TypeNodeVisitor {
    private BoxWriter writer;
    private ContractEncoderVisitor contractEncoder;
    private String lang;
    private Context cx;
    private BBoxClientEnv clientEnv;
    private boolean useCache;
    private boolean includeCommonTypes;
    private static final TypeInfo interfaceType = Sys.getRegistry().getType("baja:Interface");
    private static final BIcon stdObjIcon = BIcon.std((String)"object.png");

    public RegistryEncoderVisitor(BoxWriter writer, ContractEncoderVisitor contractEncoder, Context cx, BBoxClientEnv clientEnv, boolean useCache, boolean includeCommonTypes) {
        this.writer = writer;
        this.contractEncoder = contractEncoder;
        this.includeCommonTypes = includeCommonTypes;
        this.lang = cx != null ? cx.getLanguage() : "";
        this.cx = cx;
        this.clientEnv = clientEnv;
        this.useCache = useCache;
    }

    @Override
    public boolean doVisit(TypeNode node) throws Exception {
        TypeInfo t = node.getTypeInfo();
        String typeSpec = t.toString();
        boolean encodeType = this.includeCommonTypes || !CommonTypes.isCommonType(typeSpec);
        this.writer.key(typeSpec);
        if (encodeType) {
            if (this.useCache) {
                if (!node.getCache().isPresent() || !node.getCacheKey().equals(this.lang)) {
                    BoxWriter cacheOut = new BoxWriter();
                    cacheOut.object();
                    this.encode(node, cacheOut);
                    cacheOut.endObject();
                    node.setCache(this.lang, (Object)cacheOut);
                }
                this.writer.value(node.getCache().get());
            } else {
                this.writer.object();
                this.encode(node, this.writer);
                this.writer.endObject();
            }
        } else {
            this.writer.object().endObject();
        }
        return encodeType;
    }

    private void encode(TypeNode node, BoxWriter out) throws Exception {
        BIcon icon;
        TypeInfo[] it;
        Optional<BIBoxTypeExt> typeExt;
        boolean isInterface;
        if (node.isComplex() || node.isFrozenEnum()) {
            if (this.contractEncoder != null) {
                out.key("c");
                this.contractEncoder.encode(node, out);
            } else if (node.isComplex()) {
                try {
                    ComplexType clxt = (ComplexType)node.getResolvedType();
                    if (clxt.getFrozenSlots().length == 0) {
                        out.key("c").array().endArray();
                    }
                }
                catch (Throwable clxt) {
                    // empty catch block
                }
            }
        }
        if (isInterface = node.isInterface()) {
            out.key("i").value(true);
        }
        if (node.isTransient()) {
            out.key("t").value(true);
        }
        if (node.isValue()) {
            out.key("isv").value(true);
        }
        if (node.isSimple()) {
            out.key("iss").value(true);
            Type type = node.getResolvedType();
            if (!type.isAbstract()) {
                try {
                    String enc = type.getInstance().asSimple().encodeToString();
                    out.key("enc").value((Object)enc);
                    if (BlackListedTypes.isTypeBlackListed(type)) {
                        out.key("bl").value(true);
                    }
                }
                catch (Exception enc) {
                    // empty catch block
                }
            }
        }
        if (node.isSingleton()) {
            out.key("isg").value(true);
        }
        if (node.isNumber()) {
            out.key("isn").value(true);
        }
        if (node.isComplex()) {
            out.key("isx").value(true);
        }
        if (node.isComponent()) {
            out.key("isc").value(true);
        }
        if (node.isLink()) {
            out.key("isl").value(true);
        }
        if (node.isAction()) {
            out.key("isa").value(true);
        }
        if (node.isTopic()) {
            out.key("ist").value(true);
        }
        if (node.isFrozenEnum()) {
            out.key("ise").value(true);
        }
        if ((typeExt = node.getBoxTypeExt(this.clientEnv)).isPresent()) {
            out.key("te").value(typeExt.get().encodeToJson(this.cx));
        }
        if (!isInterface) {
            if (node.isAbstract()) {
                out.key("a").value(true);
            } else if (node.isOrdScheme()) {
                BOrdScheme ordScheme = (BOrdScheme)node.getInstance();
                out.key("os").value((Object)ordScheme.getId());
            }
        }
        if ((it = node.getInterfaces()) != null && it.length > 0) {
            out.key("it").array();
            for (TypeInfo info : it) {
                if (info.equals(interfaceType)) continue;
                out.value(info);
            }
            out.endArray();
        }
        if (!isInterface && node.superTypeValidAndNotEqualToObject()) {
            out.key("p").value((Object)node.getSuperType().toString());
        }
        if ((icon = node.getIcon()) != null && icon != BIcon.DEFAULT && !icon.equals((Object)stdObjIcon)) {
            try {
                out.key("ic").value((Object)icon.encodeToString());
            }
            catch (Exception e) {
                System.out.println("Error encoding icon to BOX...");
                e.printStackTrace();
            }
        }
        if (node.isJavaScript() && !node.isAbstract() && !node.isInterface()) {
            out.key("js").object();
            BIJavaScript js = (BIJavaScript)node.getInstance();
            JsInfo jsInfo = js.getJsInfo(this.cx);
            out.key("id").value((Object)jsInfo.getJsId());
            if (jsInfo.hasBuiltJs()) {
                out.key("deps").array();
                for (String id : jsInfo.getBuiltJsIds()) {
                    out.value(id);
                }
                out.endArray();
            }
            out.endObject();
        }
    }
}

