/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.json;

import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BJsonSimple
extends BSimple {
    public static final Type TYPE = Sys.loadType(BJsonSimple.class);
    protected JSONObject data;

    public Type getType() {
        return TYPE;
    }

    protected BJsonSimple(JSONObject data) {
        this.data = data;
    }

    public abstract BJsonSimple make(JSONObject var1);

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        BJsonSimple jsonSimple = (BJsonSimple)((Object)obj);
        return jsonSimple.data.equals(this.data);
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.data.toString());
    }

    public BObject decode(DataInput decoder) throws IOException {
        try {
            JSONTokener tok = new JSONTokener(decoder.readUTF());
            return this.make(new JSONObject(tok));
        }
        catch (JSONException e) {
            throw new IOException("json decode failed: " + e.getMessage());
        }
    }

    public String encodeToString() throws IOException {
        return this.data.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            JSONTokener tok = new JSONTokener(s);
            return this.make(new JSONObject(tok));
        }
        catch (JSONException e) {
            throw new IOException("json decode failed: " + e.getMessage());
        }
    }

    public String toString(Context context) {
        return "";
    }
}

