/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BoxWsHttpSessionListener;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.util.HistoryUtil;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.web.RestUtil;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.web.CsrfUtil;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class QueryServlet
extends HttpServlet
implements BoxWsHttpSessionListener.IHttpSessionDestroyListener {
    private static final Object MONITOR = new Object();
    private static final String POLLABLE_MAP_NAME = "pollableHistorySource";
    private static final Logger LOG = Logger.getLogger("box");
    private static final int ORD_INDEX = 1;
    private static final Pattern DATA_PATTERN = Pattern.compile("/data/.+");
    private static final Pattern SOURCE_PATTERN = Pattern.compile("/source/.+");
    private static final Pattern LAST_TIME_PATTERN = Pattern.compile("/lastTime/.+");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        BoxWsHttpSessionListener.addDestroyListener(this);
    }

    public void destroy() {
        BoxWsHttpSessionListener.removeDestroyListener(this);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setHeader("transfer-encoding", "chunked");
        resp.setContentType("text/plain;charset=utf-8");
        Context cx = null;
        Writer writer = this.getWriter(resp);
        try {
            cx = (Context)req.getAttribute("niagara.context");
            RestUtil util = new RestUtil(req, resp);
            util.respondNoCache();
            if (util.matches(DATA_PATTERN)) {
                BOrd ord = BOrd.make((String)SlotPath.unescape((String)util.get(1))).relativizeToSession().normalize();
                if (ord == BOrd.NULL || ord.toString().equals("")) {
                    resp.sendError(404);
                    return;
                }
                int offset = (Integer)WebUtil.getParameter((ServletRequest)req, (String)"offset", Integer::parseInt, (Object)0);
                int limit = (Integer)WebUtil.getParameter((ServletRequest)req, (String)"limit", Integer::parseInt, (Object)-1);
                boolean descending = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"descending", Boolean::parseBoolean, (Object)false);
                String sortColumnParam = req.getParameter("sortColumn");
                String filterParam = req.getParameter("filter");
                BFilterSet filterSet = null;
                if (filterParam != null) {
                    filterSet = (BFilterSet)BsonDecoderPlugin.unmarshal(SlotPath.unescape((String)filterParam));
                }
                this.encodeQueryData(ord, filterSet, offset, limit, sortColumnParam, descending, writer, cx);
            } else {
                resp.sendError(404);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "ServletException", e);
            WebUtil.sendSafeErrorToUser((HttpServletResponse)resp, (int)400, (Throwable)e, (Context)cx);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block17: {
            resp.setContentType("application/json; charset=utf-8");
            Context cx = null;
            Writer writer = this.getWriter(resp);
            try {
                cx = (Context)req.getAttribute("niagara.context");
                RestUtil util = new RestUtil(req, resp);
                util.respondNoCache();
                if (util.matches(SOURCE_PATTERN)) {
                    CsrfUtil.verifyCsrfToken((HttpServletRequest)req);
                    BOrd ord = BOrd.make((String)SlotPath.unescape((String)util.get(1))).relativizeToSession().normalize();
                    boolean subscribe = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"subscribe", Boolean::parseBoolean, (Object)false);
                    JSONWriter json = QuickJSONWriter.make((Appendable)writer);
                    json.object();
                    String sourceOrd = this.getSourceHistoryForSubscription(ord.toString(), subscribe, req.getSession(), cx);
                    if (sourceOrd != null) {
                        json.key("sourceOrd").value((Object)sourceOrd);
                    }
                    json.endObject();
                    break block17;
                }
                if (!util.matches(LAST_TIME_PATTERN)) break block17;
                CsrfUtil.verifyCsrfToken((HttpServletRequest)req);
                BOrd ord = BOrd.make((String)SlotPath.unescape((String)util.get(1))).relativizeToSession().normalize();
                BAbsTime lastTimestamp = BAbsTime.DEFAULT;
                BObject o = ord.get(null, cx);
                if (o instanceof BHistory) {
                    BHistory history = (BHistory)o;
                    BLocalHistoryDatabase db = new BLocalHistoryDatabase((BHistoryService)null);
                    try (HistoryDatabaseConnection conn = db.getDbConnection(cx);){
                        lastTimestamp = conn.getLastTimestamp((BIHistory)history);
                    }
                }
                JSONWriter json = QuickJSONWriter.make((Appendable)writer);
                json.object();
                json.key("lastTime").value((Object)lastTimestamp.encodeToString());
                json.endObject();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "ServletException", e);
                WebUtil.sendSafeErrorToUser((HttpServletResponse)resp, (int)400, (Throwable)e, (Context)cx);
            }
        }
    }

    private void encodeQueryData(BOrd ord, BFilterSet filterSet, int offset, int limit, String sortColumnName, boolean descending, Writer writer, Context cx) throws Exception {
        boolean filterActive;
        OrdTarget target = ord.resolve(null, cx);
        if (!target.canRead()) {
            throw new PermissionException();
        }
        BObject queryObject = target.get();
        boolean bl = filterActive = filterSet != null && filterSet.anyActive();
        if (this.isEfficientQuery(queryObject, sortColumnName, descending)) {
            this.encodeResults(writer, filterSet, offset, limit, sortColumnName, descending, cx, queryObject, filterActive);
        } else if (sortColumnName != null) {
            this.encodeSortedResults(filterSet, offset, limit, sortColumnName, descending, writer, cx, queryObject, filterActive);
        } else {
            this.encodeResults(writer, filterSet, offset, limit, null, descending, cx, queryObject, filterActive);
        }
    }

    private void encodeSortedResults(BFilterSet filterSet, int offset, int limit, String sortColumnName, boolean descending, Writer writer, Context cx, BObject queryObject, boolean filterActive) throws Exception {
        int skipped = 0;
        int writtenRecords = 0;
        int keepAmount = -1;
        if (offset > -1 && limit > -1) {
            keepAmount = offset + limit;
        }
        TreeSet set = new TreeSet(new ComplexComparator(sortColumnName, descending));
        Cursor<? extends BComplex> queryCursor = this.retrieveQueryResults(queryObject, sortColumnName, descending, cx);
        Object object = null;
        try {
            while (queryCursor.next()) {
                BComplex complex = (BComplex)queryCursor.get();
                if (filterActive && !filterSet.accept(complex)) continue;
                set.add((BComplex)complex.newCopy(true));
                if (keepAmount == -1 || set.size() <= keepAmount) continue;
                set.pollLast();
            }
        }
        catch (Throwable complex) {
            object = complex;
            throw complex;
        }
        finally {
            if (queryCursor != null) {
                if (object != null) {
                    try {
                        queryCursor.close();
                    }
                    catch (Throwable complex) {
                        ((Throwable)object).addSuppressed(complex);
                    }
                } else {
                    queryCursor.close();
                }
            }
        }
        boolean first = true;
        for (BComplex complex : set) {
            if (offset > skipped) {
                ++skipped;
                continue;
            }
            JSONWriter json = QuickJSONWriter.make((Appendable)writer);
            if (!first) {
                writer.append("\n");
            }
            first = false;
            this.encodeQueryRecord(json, complex, cx);
            ++writtenRecords;
        }
        this.encodeLastPageNumberWhenNeeded(writer, offset, limit, skipped, writtenRecords);
    }

    private void encodeLastPageNumberWhenNeeded(Writer writer, int offset, int limit, int skipped, int writtenRecords) {
        if (writtenRecords == 0 && offset > 0) {
            int lastRecord = skipped;
            if (lastRecord > 0) {
                --lastRecord;
            }
            this.encodeLastPageNumber(writer, lastRecord / limit + 1);
        }
    }

    private void encodeLastPageNumber(Writer writer, long lastPage) {
        JSONWriter json = QuickJSONWriter.make((Appendable)writer);
        json.object();
        json.key("lastPage");
        json.value(lastPage);
        json.endObject();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "no results found, sending last page number: " + lastPage);
        }
    }

    private void encodeResults(Writer writer, BFilterSet filterSet, int offset, int limit, String sortColumnName, boolean descending, Context cx, BObject queryObject, boolean filterActive) throws Exception {
        int writtenRecords = 0;
        int skipped = 0;
        try (Cursor<? extends BComplex> queryCursor = this.retrieveQueryResults(queryObject, sortColumnName, descending, cx);){
            boolean first = true;
            while (queryCursor.next() && (limit == -1 || writtenRecords < limit)) {
                BComplex o = (BComplex)queryCursor.get();
                if (filterActive && o != null && !filterSet.accept(o)) continue;
                if (offset > skipped) {
                    ++skipped;
                    continue;
                }
                JSONWriter json = QuickJSONWriter.make((Appendable)writer);
                if (!first) {
                    writer.append("\n");
                }
                first = false;
                ++writtenRecords;
                this.encodeQueryRecord(json, o, cx);
            }
        }
        this.encodeLastPageNumberWhenNeeded(writer, offset, limit, skipped, writtenRecords);
    }

    private int compareProperty(BComplex c1, BComplex c2, String propertyName) {
        Object comparable2;
        Object comparable1;
        BValue o1 = c1.get(propertyName);
        BValue o2 = c2.get(propertyName);
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            comparable1 = (Comparable)o1;
            comparable2 = (Comparable)o2;
        } else if (o1 != null && o2 != null) {
            comparable1 = o1.toString();
            comparable2 = o2.toString();
        } else {
            if (o1 != null) {
                return 1;
            }
            if (o2 != null) {
                return -1;
            }
            return 0;
        }
        return comparable1.compareTo(comparable2);
    }

    private void encodeQueryRecord(JSONWriter json, Object o, Context cx) throws Exception {
        if (!(o instanceof BValue)) {
            throw new Exception("Unsupported class in encodeQueryRecord: " + o.getClass());
        }
        BsonEncoderPlugin.DisplayEncoder encoder = new BsonEncoderPlugin.DisplayEncoder(new BsonEncoderPlugin(json), cx);
        encoder.encode((BValue)o);
        encoder.close();
    }

    private boolean isEfficientQuery(BObject object, String sortColumnName, boolean descending) {
        if (sortColumnName != null && !"timestamp".equals(sortColumnName)) {
            return false;
        }
        if (object instanceof BIHistory || object instanceof BHistoryTimeQuery) {
            return true;
        }
        return object instanceof BHistoryDeltaQuery && !descending;
    }

    private Cursor<? extends BComplex> retrieveQueryResults(BObject o, String sortColumnName, boolean descending, Context cx) throws Exception {
        boolean timestampDescending;
        boolean bl = timestampDescending = "timestamp".equals(sortColumnName) && descending;
        if (o instanceof BIHistory) {
            BLocalHistoryDatabase db = new BLocalHistoryDatabase((BHistoryService)null);
            try (HistoryDatabaseConnection conn = db.getDbConnection(cx);){
                Cursor cursor = conn.scan((BIHistory)o, timestampDescending);
                return cursor;
            }
        }
        if (o instanceof BHistoryTimeQuery) {
            BHistoryTimeQuery timeQuery = (BHistoryTimeQuery)o;
            if (timestampDescending) {
                BHistoryTimeQuery descendingTimeQuery = new BHistoryTimeQuery(timeQuery.getHistory(), timeQuery.getStartTime(), timeQuery.getEndTime(), true);
                return descendingTimeQuery.cursor();
            }
            return timeQuery.cursor();
        }
        if (o instanceof BHistoryDeltaQuery) {
            return ((BHistoryDeltaQuery)o).cursor();
        }
        if (o instanceof BITable) {
            BITable table = (BITable)o;
            return table.cursor();
        }
        throw new Exception("QueryServlet not available for type " + o.getType());
    }

    public String getSourceHistoryForSubscription(String stringOrd, boolean subscribe, HttpSession session, Context cx) {
        BHistory history;
        BComponent source;
        if (stringOrd.equals("")) {
            return null;
        }
        BOrd ord = BOrd.make((String)stringOrd);
        BObject o = ord.get(null, cx);
        if (o instanceof BHistory && (source = HistoryUtil.getSourceComponent((BIHistory)(history = (BHistory)o), (Context)cx)) != null) {
            this.updateHistorySubscriptionCount((BIHistory)history, source, session, subscribe);
            BOrd sourceOrd = source.getSlotPathOrd();
            if (sourceOrd != null) {
                return sourceOrd.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistorySubscriptionCount(BIHistory history, BComponent source, HttpSession session, boolean subscribe) {
        if (source instanceof BIPollableHistorySource) {
            ConcurrentHashMap map;
            BIPollableHistorySource pollableSource = (BIPollableHistorySource)source;
            pollableSource.updateHistorySubscriptionCount(subscribe ? 1 : -1);
            HttpSession httpSession = session;
            synchronized (httpSession) {
                map = (ConcurrentHashMap)session.getAttribute(POLLABLE_MAP_NAME);
                if (map == null) {
                    map = new ConcurrentHashMap();
                    session.setAttribute(POLLABLE_MAP_NAME, map);
                }
            }
            HistoryUtil.updateSubscriptionCounter((BInterface)history, (BComponent)source, (int)(subscribe ? 1 : -1), map, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHttpSessionDestroyed(HttpSession session) {
        Object object = MONITOR;
        synchronized (object) {
            Map map = (Map)session.getAttribute(POLLABLE_MAP_NAME);
            if (map != null) {
                map.forEach((history, info) -> {
                    BComponent source = info.getHistorySource();
                    HistoryUtil.updateSubscriptionCounter((BInterface)history, (BComponent)source, (int)(info.getCount() * -1), (Map)map, (boolean)true);
                    if (source instanceof BIPollableHistorySource) {
                        BIPollableHistorySource pollableSource = (BIPollableHistorySource)source;
                        pollableSource.updateHistorySubscriptionCount(info.getCount() * -1);
                    }
                });
                session.removeAttribute(POLLABLE_MAP_NAME);
            }
        }
    }

    @Override
    public void onBoxSessionExpired(HttpSession session) {
        this.onHttpSessionDestroyed(session);
    }

    private Writer getWriter(HttpServletResponse resp) throws IOException {
        return resp.getWriter();
    }

    private class ComplexComparator<T extends BComplex>
    implements Comparator<T> {
        private String sortColumnName;
        private boolean descending;

        ComplexComparator(String sortColumnName, boolean descending) {
            this.sortColumnName = sortColumnName;
            this.descending = descending;
        }

        @Override
        public int compare(BComplex c1, BComplex c2) {
            if (c1 == c2) {
                return 0;
            }
            int result = QueryServlet.this.compareProperty(c1, c2, this.sortColumnName);
            if (result == 0 && !"timestamp".equals(this.sortColumnName)) {
                result = QueryServlet.this.compareProperty(c1, c2, "timestamp");
            }
            if (result == 0) {
                result = 1;
            }
            if (this.descending) {
                result *= -1;
            }
            return result;
        }
    }
}

