/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxService;
import java.util.HashMap;
import java.util.Map;
import javax.baja.box.BBoxClientEnv;
import javax.baja.naming.BOrd;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;
import javax.baja.util.Version;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;

public final class BoxOp
extends BasicContext {
    private Map<Object, Object> requestMap = null;
    private BBoxClientEnv clientEnv = BBoxService.defaultClientEnv;
    private final boolean isSecure;
    private final String remoteAddr;
    public static final Version boxVersion1 = new Version("1");
    public static final Version boxVersion2 = new Version("2");
    private Version version = boxVersion1;

    public BoxOp(Context cx, boolean isSecure, String remoteAddr) {
        super(cx);
        this.isSecure = isSecure;
        this.remoteAddr = remoteAddr;
    }

    public Object get(Object key) {
        if (this.requestMap == null) {
            return null;
        }
        return this.requestMap.get(key);
    }

    public void put(Object key, Object value) {
        if (this.requestMap == null) {
            this.requestMap = new HashMap<Object, Object>();
        }
        this.requestMap.put(key, value);
    }

    public String getUsername() {
        BUser user = this.getUser();
        return user != null ? user.getUsername() : "";
    }

    public BOrd getHomePage() {
        WebOp webOp = this.getWebOp();
        BUser user = this.getUser();
        if (webOp != null) {
            IWebEnv webEnv = webOp.getWebEnv();
            if (webEnv != null) {
                return webEnv.getHomePage(webOp);
            }
        } else if (user != null) {
            return user.getHomePage();
        }
        return BOrd.NULL;
    }

    public BBoxClientEnv getClientEnv() {
        return this.clientEnv;
    }

    void setClientEnv(BBoxClientEnv clientEnv) {
        this.clientEnv = clientEnv;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isVersion2OrGreater() {
        return this.version.compareTo(boxVersion2) > -1;
    }

    void setVersion(String versionStr) {
        this.version = versionStr.equals("1") ? boxVersion1 : (versionStr.equals("2") ? boxVersion2 : new Version(versionStr));
    }

    public WebOp getWebOp() {
        Context cx;
        for (cx = this.getBase(); cx != null && !(cx instanceof WebOp); cx = cx.getBase()) {
        }
        return cx != null && cx instanceof WebOp ? (WebOp)cx : null;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getProfileTypeSpec() {
        IWebEnv webEnv;
        String profile = "";
        WebOp webOp = this.getWebOp();
        if (webOp != null && (webEnv = webOp.getWebEnv()) != null) {
            profile = webEnv.getWebProfile(webOp).getType().toString();
        }
        return profile;
    }

    public static boolean isWorkbench(BoxOp op) {
        return op.getFacets().getb("isWorkbench", false);
    }
}

