/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BOrdChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.sys.transfer.TransferResult;
import javax.baja.naming.OrdTarget;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTransferChannel
extends BBoxChannel {
    public static final Type TYPE = Sys.loadType(BTransferChannel.class);
    private static final String CHANNEL_NAME = "transfer";

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "copy": {
                BTransferChannel.doCopy((JSONObject)body, out, (Context)op);
                return true;
            }
        }
        return false;
    }

    private static void doCopy(JSONObject body, BoxWriter out, Context cx) throws Exception {
        int i;
        JSONArray sources = body.getJSONArray("sources");
        JSONObject targetObj = body.getJSONObject("target");
        String[] names = null;
        if (body.has("names")) {
            JSONArray arr = body.getJSONArray("names");
            if (arr.length() != sources.length()) {
                throw new JSONException("different number of sources and names");
            }
            names = new String[arr.length()];
            for (i = 0; i < names.length; ++i) {
                names[i] = JSONUtil.getString((JSONArray)arr, (int)i);
            }
        }
        BObject[] sourceObjects = new BObject[sources.length()];
        for (i = 0; i < sourceObjects.length; ++i) {
            OrdTarget source = BOrdChannel.resolveOrd(sources.getJSONObject(i), cx);
            sourceObjects[i] = source.get();
        }
        OrdTarget target = BOrdChannel.resolveOrd(targetObj, cx);
        BObject targetObject = target.get();
        Mark mark = names == null ? new Mark(sourceObjects) : new Mark(sourceObjects, names);
        TransferResult result = mark.copyTo(targetObject, cx);
        out.object();
        out.key("insertNames").array();
        for (String insertName : result.getInsertNames()) {
            out.value(insertName);
        }
        out.endArray();
        out.endObject();
    }

    @Override
    public String getChannelName() {
        return CHANNEL_NAME;
    }
}

