/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.box.BBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxString;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.AlarmSpaceConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.bql.BIBqlFilter;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.AbstractReverseCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraSlots
public final class BAlarmChannel
extends BBoxChannel {
    public static final Type TYPE = Sys.loadType(BAlarmChannel.class);
    private static final String TIME_RANGE_OBJECT_KEY = "t";
    private static final String TIME_RANGE_KEY = "$val";
    private static final String FILTER_SET_KEY = "f";
    private static final String ALARM_KEY = "alarm";
    private static final String NOTE_KEY = "notes";
    private static final String COUNT_KEY = "c";
    private static final String RESULTS_KEY = "r";
    private static final int MAX_LIMIT = 1000;
    private static final String ALARM_RECORD_KEY = "record";
    private static final String CONTEXT_KEY = "cx";
    private static final String IDS_KEY = "ids";
    private static final String MOST_RECENT_KEY = "mostRecent";
    private static final String SOURCES_KEY = "srcs";
    private static final String UPDATE_RECORD_KEY = "ur";
    private static final String TIMESTAMP_FILTER_KEY = "timestamp";
    private static final String FORCE_CLEARED_KEY = "forceCleared";
    public static final String DEFAULT = "default";

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getChannelName() {
        return ALARM_KEY;
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "getRecordCount": {
                this.getRecordCount((JSONObject)body, out, op);
                return true;
            }
            case "clearAllRecords": {
                this.clearAllRecords(out, op);
                return true;
            }
            case "clearOldRecords": {
                this.clearOldRecords(body.toString(), out, op);
                return true;
            }
            case "clearRecords": {
                this.clearRecords((JSONArray)body, out, op);
                return true;
            }
            case "queryAlarmDatabase": {
                this.queryAlarmDatabase((JSONObject)body, out, op);
                return true;
            }
            case "addNote": {
                this.addNote((JSONObject)body, out, op);
                return true;
            }
            case "getDisplayNamesMap": {
                this.getDisplayNamesMap(out, op);
                return true;
            }
            case "getPermissionsMap": {
                this.getPermissionsMap((JSONObject)body, out, op);
                return true;
            }
            case "getAlarmFields": {
                this.getAlarmFields(out);
                return true;
            }
            case "ackAlarms": {
                this.ackAlarms((JSONObject)body, out, (Context)op);
                return true;
            }
            case "addNoteToAlarms": {
                this.addNoteToAlarms((JSONObject)body, out, (Context)op);
                return true;
            }
            case "forceClear": {
                this.forceClear((JSONObject)body, out, (Context)op);
                return true;
            }
            case "getSingleSourceSummary": {
                this.getSingleSourceSummary((JSONObject)body, out, op);
                return true;
            }
            case "getNotes": {
                this.getNotes((JSONObject)body, out, (Context)op);
                return true;
            }
        }
        return false;
    }

    private void getRecordCount(JSONObject obj, BoxWriter out, BoxOp op) throws Exception {
        BqlQuery query = BAlarmChannel.buildQuery(BAlarmChannel.getTimeRange(obj), BAlarmChannel.getFilterSet(obj), false, TIMESTAMP_FILTER_KEY);
        try (AlarmDbConnection conn = BAlarmChannel.getAlarmDatabase().getDbConnection((Context)op);
             IterableCursor cursor = (IterableCursor)conn.doBqlQuery(query);){
            out.value(cursor.stream().count());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearAllRecords(BoxWriter out, BoxOp op) throws Exception {
        try (AlarmDbConnection conn = BAlarmChannel.getAlarmDatabase().getDbConnection((Context)op);){
            conn.clearAllRecords((Context)op);
        }
        out.value(true);
    }

    public void clearOldRecords(String encodedTime, BoxWriter out, BoxOp op) throws Exception {
        try (AlarmDbConnection conn = BAlarmChannel.getAlarmDatabase().getDbConnection((Context)op);){
            conn.clearOldRecords((BAbsTime)BAbsTime.DEFAULT.decodeFromString(encodedTime), (Context)op);
        }
        out.value(true);
    }

    private void clearRecords(JSONArray encodedUuids, BoxWriter out, BoxOp op) throws Exception {
        try (AlarmDbConnection conn = BAlarmChannel.getAlarmDatabase().getDbConnection((Context)op);){
            for (int i = 0; i < encodedUuids.length(); ++i) {
                conn.clearRecord((BUuid)BUuid.DEFAULT.decodeFromString(JSONUtil.getString((JSONArray)encodedUuids, (int)i)), (Context)op);
            }
        }
        out.value(true);
    }

    private void queryAlarmDatabase(JSONObject object, BoxWriter out, BoxOp op) throws Exception {
        int limit = object.isNull("l") ? -1 : object.getInt("l");
        int offset = object.isNull("o") ? -1 : object.getInt("o");
        boolean descending = !object.isNull("d") && object.getBoolean("d");
        String columnName = object.isNull(COUNT_KEY) ? TIMESTAMP_FILTER_KEY : JSONUtil.getString((JSONObject)object, (String)COUNT_KEY);
        try {
            BDynamicTimeRange timeRange = BAlarmChannel.getTimeRange(object);
            BFilterSet filterSet = BAlarmChannel.getFilterSet(object);
            this.doQuery(timeRange, limit, offset, filterSet, descending, columnName, out, op);
        }
        catch (Exception e) {
            this.doQuery(BDynamicTimeRange.DEFAULT, -1, -1L, null, descending, columnName, out, op);
        }
    }

    private static BDynamicTimeRange getTimeRange(JSONObject obj) throws Exception {
        BDynamicTimeRange defaultTimeRange = BDynamicTimeRange.DEFAULT;
        String encoding = null;
        JSONObject timeRangeObj = obj.optJSONObject(TIME_RANGE_OBJECT_KEY);
        if (timeRangeObj != null) {
            encoding = timeRangeObj.optString(TIME_RANGE_KEY);
        }
        return encoding == null || encoding.isEmpty() || encoding.equals("timeRange") ? defaultTimeRange : (BDynamicTimeRange)defaultTimeRange.decodeFromString(encoding);
    }

    private static BFilterSet getFilterSet(JSONObject obj) {
        JSONObject filterSetObj = obj.optJSONObject(FILTER_SET_KEY);
        try {
            return filterSetObj == null ? null : (BFilterSet)BsonDecoderPlugin.unmarshal(filterSetObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void doQuery(BDynamicTimeRange timeRange, int limit, long offset, BFilterSet filterSet, boolean descending, String sortColumnName, BoxWriter out, BoxOp op) throws Exception {
        Function<BAlarmRecord, BoxString> encodeToBson = alarm -> {
            try {
                return BAlarmChannel.encodeAlarm(alarm, (Context)op);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        };
        BqlQuery query = BAlarmChannel.buildQuery(timeRange, filterSet, descending, sortColumnName);
        try (AlarmDbConnection conn = BAlarmChannel.getAlarmDatabase().getDbConnection((Context)op);
             IterableCursor cursor = (IterableCursor)conn.doBqlQuery(query);){
            limit = limit == -1 ? 1000 : limit;
            offset = offset == -1L ? 0L : offset;
            boolean isTimestampCol = sortColumnName.equals(TIMESTAMP_FILTER_KEY);
            AtomicLong count = new AtomicLong(0L);
            if (isTimestampCol) {
                try (AlarmDbConnection sizeConn = BAlarmChannel.getAlarmDatabase().getDbConnection((Context)op);
                     IterableCursor sizeCursor = (IterableCursor)sizeConn.doBqlQuery(query);){
                    Stream<BAlarmRecord> sizeStream = sizeCursor.stream();
                    sizeStream = filterSet != null ? sizeStream.filter(arg_0 -> ((BFilterSet)filterSet).accept(arg_0)) : sizeStream;
                    count.set(sizeStream.count());
                    offset = descending ? count.get() - offset - (long)limit : offset;
                    offset = offset < 0L ? 0L : offset;
                }
            }
            Stream<BAlarmRecord> stream = cursor.stream();
            Stream<BAlarmRecord> stream2 = filterSet != null ? stream.filter(arg_0 -> ((BFilterSet)filterSet).accept(arg_0)) : (stream = stream);
            if (!isTimestampCol) {
                stream = stream.map(alarm -> {
                    count.getAndIncrement();
                    return (BAlarmRecord)alarm.newCopy();
                }).sorted(this.getComparator(sortColumnName, descending));
            }
            Object[] alarms = (BoxString[])stream.skip(offset).limit(limit).map(alarm -> (BoxString)encodeToBson.apply(isTimestampCol ? (BAlarmRecord)alarm.newCopy() : alarm)).toArray(BoxString[]::new);
            alarms = isTimestampCol && descending ? (BoxString[])new Array(alarms).reverse().trim() : alarms;
            JSONArray array = new JSONArray((Object)alarms);
            out.object().key(COUNT_KEY).value(count.get()).key(RESULTS_KEY).value((Object)array).endObject();
        }
    }

    private Comparator<BAlarmRecord> getComparator(String sortColumnName, boolean sortDescending) {
        Comparator<BAlarmRecord> comparator = Comparator.comparing(alarm -> {
            BValue value = alarm.get(sortColumnName);
            if (value == null) {
                value = alarm.getAlarmData().get(sortColumnName);
            } else if (value instanceof BOrdList) {
                value = ((BOrdList)value).get(0);
            }
            return value instanceof Comparable ? (Comparable)value : alarm.getTimestamp();
        });
        return sortDescending ? comparator.reversed() : comparator;
    }

    private static BqlQuery buildQuery(BDynamicTimeRange timeRange, BFilterSet filterSet, boolean descending, String columnName) {
        String filterQual;
        StringBuilder query = new StringBuilder("select *");
        StringBuilder predicate = new StringBuilder(64);
        if (filterSet != null && (filterQual = filterSet.getPredicate()) != null && filterQual.length() > 0) {
            if (predicate.length() != 0) {
                predicate.append(" and ");
            }
            predicate.append(filterQual);
        }
        if (timeRange != null && !timeRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            BAbsTimeFilter timeFilter = new BAbsTimeFilter();
            timeFilter.initFromDynamicTimeRange(timeRange);
            String timeRangePredicate = timeFilter.getPredicate(BAlarmRecord.timestamp.getName());
            if (predicate.length() != 0) {
                predicate.append(" and ");
            }
            predicate.append(timeRangePredicate);
        }
        if (predicate.length() != 0) {
            query.append(" where ").append(predicate.toString());
        }
        query.append(" order by ").append(columnName).append(descending ? " desc" : " asc");
        return BqlQuery.make((String)query.toString());
    }

    private void addNote(JSONObject obj, BoxWriter out, BoxOp op) throws Exception {
        BValue value;
        if (!obj.isNull(ALARM_KEY) && (value = BsonDecoderPlugin.unmarshal(JSONUtil.getString((JSONObject)obj, (String)ALARM_KEY))) instanceof BComplex) {
            try (AlarmDbConnection conn = BAlarmChannel.getAlarmDatabase().getDbConnection((Context)op);){
                BComplex decodedAlarm = value.asComplex();
                BAlarmRecord record = null;
                BUuid uuid = (BUuid)decodedAlarm.get("uuid");
                if (uuid != null) {
                    record = conn.getRecord(uuid);
                }
                if (record == null) {
                    BAlarmRecord template = new BAlarmRecord();
                    Arrays.stream(decodedAlarm.getDynamicPropertiesArray()).forEach(prop -> template.set(prop.getName(), decodedAlarm.get(prop).newCopy()));
                    record = template;
                }
                String note = !obj.isNull(NOTE_KEY) ? JSONUtil.getString((JSONObject)obj, (String)NOTE_KEY) : "";
                BFacets alarmData = record.getAlarmData();
                BString updatedNotes = BString.make((String)(alarmData.gets(NOTE_KEY, "") + note));
                record.setAlarmData(BFacets.make((BFacets)alarmData, (String)NOTE_KEY, (BIDataValue)updatedNotes));
                conn.update(record);
            }
        }
        out.value(true);
    }

    private void getDisplayNamesMap(BoxWriter out, BoxOp op) {
        out.object();
        try {
            BAlarmService alarmService = BAlarmChannel.getAlarmService();
            HashSet<String> keys = new HashSet<String>();
            for (BAlarmClass alarmClass : alarmService.getAlarmClasses()) {
                String name = alarmClass.getPropertyInParent().getName();
                if (keys.add(name)) {
                    out.key(name).value((Object)alarmService.getAlarmClassDisplayName((Object)name, (Context)op));
                    continue;
                }
                BAlarmService.logger.warning("Duplicate Alarm Classes with name '" + name + "'");
            }
        }
        catch (ServiceNotFoundException notFound) {
            BAlarmService.logger.severe("Cannot generate Alarm Class display name map - no Alarm Service found");
        }
        out.endObject();
    }

    private void getPermissionsMap(JSONObject obj, BoxWriter out, BoxOp op) throws Exception {
        if (obj != null) {
            out.object();
            try {
                String[] alarmClassNames;
                BAlarmService alarmService = BAlarmChannel.getAlarmService();
                String defaultPermissions = alarmService.getDefaultAlarmClass().getPermissions((Context)op).encodeToString();
                Map<String, String> alarmClassMap = this.getAlarmClassMap(alarmService, op);
                for (String alarmClassName : alarmClassNames = ((BString)BsonDecoderPlugin.unmarshal(obj)).getString().split(",")) {
                    String permissions = alarmClassMap.get(alarmClassName);
                    if (permissions == null) {
                        out.key(alarmClassName).value((Object)defaultPermissions);
                        continue;
                    }
                    out.key(alarmClassName).value((Object)permissions);
                }
            }
            catch (ServiceNotFoundException notFound) {
                BAlarmService.logger.severe("Cannot generate Alarm Class permissions map - no Alarm Service found");
            }
        }
        out.endObject();
    }

    private Map<String, String> getAlarmClassMap(BAlarmService alarmService, BoxOp op) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (BAlarmClass alarmClass : alarmService.getAlarmClasses()) {
            String name = alarmClass.getPropertyInParent().getName();
            if (map.get(name) == null) {
                map.put(name, alarmClass.getPermissions((Context)op).encodeToString());
                continue;
            }
            BAlarmService.logger.warning("Duplicate Alarm Classes with name '" + name + "' found when retrieving permissions map");
        }
        return map;
    }

    public void getAlarmFields(BoxWriter out) {
        out.array();
        for (String field : BAlarmRecord.getAlarmDataFields()) {
            out.value(field);
        }
        out.endArray();
    }

    public void ackAlarms(JSONObject clientParams, BoxWriter out, Context cx) throws Exception {
        BAlarmChannel.process(BAlarmChannel::ack, clientParams, out, cx);
    }

    private static void ack(Map<String, Object> params, AlarmSpaceConnection conn) {
        BAlarmService alarmService = BAlarmChannel.getAlarmService();
        BAlarmRecord alarm = (BAlarmRecord)params.get(ALARM_RECORD_KEY);
        Context cx = (Context)params.get(CONTEXT_KEY);
        String username = cx.getUser().getUsername();
        if (!alarm.isAcknowledged()) {
            if (params.containsKey(NOTE_KEY)) {
                params.put(UPDATE_RECORD_KEY, false);
                BAlarmChannel.addNoteToAlarms(params, conn);
            }
            alarm.setUser(username);
            alarm.setAckTime(BAbsTime.now());
            alarm.setAckState(BAckState.ackPending);
            alarm.setLastUpdate(BAbsTime.now());
            try {
                conn.update(alarm);
            }
            catch (IOException | AlarmException err) {
                throw new RuntimeException(err);
            }
            alarmService.ackAlarm(alarm);
        }
    }

    public void addNoteToAlarms(JSONObject clientParams, BoxWriter out, Context cx) throws Exception {
        BAlarmChannel.process(BAlarmChannel::addNoteToAlarms, clientParams, out, cx);
    }

    private static void addNoteToAlarms(Map<String, Object> params, AlarmSpaceConnection conn) {
        BAlarmService alarmService = BAlarmChannel.getAlarmService();
        BAlarmRecord alarm = (BAlarmRecord)params.get(ALARM_RECORD_KEY);
        Context cx = (Context)params.get(CONTEXT_KEY);
        String username = cx.getUser().getUsername();
        String note = params.getOrDefault(NOTE_KEY, "").toString();
        if (!note.isEmpty()) {
            note = "## " + BAbsTime.now() + " - " + username + " ##\n" + note + "\n\n";
            BFacets alarmData = alarm.getAlarmData();
            String oldNotes = alarmData.gets(NOTE_KEY, "");
            BString updatedNotes = BString.make((String)(note + oldNotes));
            alarm.setAlarmData(BFacets.make((BFacets)alarmData, (String)NOTE_KEY, (BIDataValue)updatedNotes));
            boolean update = (Boolean)params.getOrDefault(UPDATE_RECORD_KEY, true);
            if (update) {
                try {
                    alarm.setLastUpdate(BAbsTime.now());
                    alarmService.routeAlarm(alarm);
                    alarmService.doRouteToSource((BAlarmRecord)alarm.newCopy());
                }
                catch (Exception err) {
                    throw new RuntimeException(err);
                }
            }
        }
    }

    public void forceClear(JSONObject clientParams, BoxWriter out, Context cx) throws Exception {
        clientParams.put(FORCE_CLEARED_KEY, true);
        BAlarmChannel.process(BAlarmChannel::forceClear, clientParams, out, cx);
    }

    private static void forceClear(Map<String, Object> params, AlarmSpaceConnection conn) {
        BAlarmService alarmService = BAlarmChannel.getAlarmService();
        BAlarmRecord alarm = (BAlarmRecord)params.get(ALARM_RECORD_KEY);
        Context cx = (Context)params.get(CONTEXT_KEY);
        String username = cx.getUser().getUsername();
        alarm.setSourceState(BSourceState.normal);
        alarm.setAckState(BAckState.acked);
        alarm.addAlarmFacet(FORCE_CLEARED_KEY, (BIDataValue)BString.make((String)username));
        BAbsTime now = BAbsTime.now();
        if (alarm.getAckTime().equals((Object)BAbsTime.NULL)) {
            alarm.setAckTime(now);
        }
        if (alarm.getNormalTime().equals((Object)BAbsTime.NULL)) {
            alarm.setNormalTime(now);
        }
        alarm.setLastUpdate(now);
        try {
            alarmService.routeAlarm(alarm);
            alarmService.doRouteToSource((BAlarmRecord)alarm.newCopy());
            alarmService.doAuditForceClear(alarm, cx);
        }
        catch (RuntimeException err) {
            throw err;
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
    }

    public void getSingleSourceSummary(JSONObject clientParams, BoxWriter out, BoxOp op) throws Exception {
        BConsoleRecipient recipient = BAlarmChannel.decodeConsoleRecipient(clientParams, (Context)op);
        BUser user = op.getUser();
        user.check((BIProtected)recipient, BPermissions.operatorRead);
        BFilterSet filterSet = BAlarmChannel.decodeFilterSet(clientParams, (Context)op);
        int offset = clientParams.getInt("offset");
        int limit = clientParams.getInt("limit");
        String column = clientParams.has("column") ? JSONUtil.getString((JSONObject)clientParams, (String)"column") : TIMESTAMP_FILTER_KEY;
        boolean sortDesc = !clientParams.has("sortDesc") || clientParams.getBoolean("sortDesc");
        BOrdList source = BOrdList.make((String)JSONUtil.getString((JSONObject)clientParams, (String)"source"));
        BAlarmService service = BAlarmChannel.getAlarmService();
        Map<String, Set<String>> alarmClasses = BAlarmChannel.getAllSubscribedAlarmClasses((BAlarmRecipient)recipient, service, user);
        this.getSingleSourceSummary((JSONWriter)out, (Context)op, service, source, alarmClasses, offset, limit, filterSet, column, sortDesc);
    }

    public void getSingleSourceSummary(JSONWriter out, Context cx, BAlarmService service, BOrdList source, Map<String, Set<String>> alarmClasses, int offset, int limit, BFilterSet filterSet, String column, boolean sortDesc) throws IOException {
        int end = offset + limit;
        AtomicLong alarmCount = new AtomicLong();
        boolean filterActive = filterSet.getPropertyCount() > 0;
        out.object().key("records").array();
        Set allAlarmClassNames = Arrays.stream(service.getAlarmClasses()).map(BComplex::getName).collect(Collectors.toSet());
        try (AlarmSpaceConnection conn = service.getAlarmDb().getConnection(cx);
             Cursor alarmCursor = conn.getOpenAlarmsForSource(source);){
            boolean reversed = false;
            Cursor cursor = alarmCursor;
            if (alarmCursor instanceof AbstractReverseCursor) {
                cursor = ((AbstractReverseCursor)alarmCursor).getReverseCursor();
                reversed = true;
            }
            Stream<BAlarmRecord> stream = cursor instanceof IterableCursor ? ((IterableCursor)cursor).stream() : IterableCursor.stream((Cursor)cursor);
            stream = stream.filter(alarm -> BAlarmChannel.canShowAlarmRecord(alarm, alarmClasses, allAlarmClassNames)).filter(alarm -> !filterActive || filterSet.accept((BComplex)alarm)).map(alarm -> (BAlarmRecord)alarm.newCopy(true));
            if (!(sortDesc && TIMESTAMP_FILTER_KEY.equals(column) && reversed)) {
                boolean alarmDataColumn = column.startsWith("alarmData.");
                Property prop = alarmDataColumn ? null : new BAlarmRecord().getProperty(column);
                String alarmDataKey = alarmDataColumn ? column.substring("alarmData.".length(), column.length()) : "";
                Comparator comparator = (alarm1, alarm2) -> {
                    BValue val2;
                    BValue val1;
                    if (alarmDataKey.isEmpty()) {
                        val1 = prop != null ? alarm1.get(prop) : null;
                        val2 = prop != null ? alarm2.get(prop) : null;
                    } else {
                        val1 = alarm1.getAlarmData().get(alarmDataKey);
                        val2 = alarm2.getAlarmData().get(alarmDataKey);
                    }
                    return SortUtil.compare((Object)val1, (Object)val2);
                };
                if (sortDesc) {
                    comparator = comparator.reversed();
                }
                stream = stream.sorted(comparator);
            }
            stream.forEach(alarm -> {
                boolean inPage;
                boolean bl = inPage = alarmCount.get() >= (long)offset && alarmCount.get() < (long)end;
                if (inPage) {
                    try {
                        out.value((Object)BAlarmChannel.encodeAlarm(alarm, cx));
                    }
                    catch (IOException err) {
                        throw new RuntimeException(err);
                    }
                }
                alarmCount.incrementAndGet();
            });
        }
        out.endArray();
        out.key("alarmCount").value((Object)alarmCount);
        out.key("pageCount").value((long)((int)Math.ceil(alarmCount.doubleValue() / (double)limit)));
        out.endObject();
    }

    private void getNotes(JSONObject params, BoxWriter out, Context cx) throws IOException {
        BAlarmRecord record = BAlarmChannel.getAlarmSpaceConnection(cx).getRecord((BUuid)BUuid.DEFAULT.decodeFromString(JSONUtil.getString((JSONObject)params, (String)"uuid")));
        if (record == null) {
            throw new IOException("Unable to read alarm record. Alarm Record is null");
        }
        out.object();
        out.key(NOTE_KEY);
        out.value(record.getAlarmData().gets(NOTE_KEY, ""));
        out.endObject();
    }

    public static BConsoleRecipient decodeConsoleRecipient(JSONObject params, Context cx) {
        BOrd ord = BOrd.make((String)JSONUtil.getString((JSONObject)params, (String)"ord"));
        return (BConsoleRecipient)ord.resolve((BObject)BLocalHost.INSTANCE, cx).get();
    }

    public static BFilterSet decodeFilterSet(JSONObject params, Context cx) throws Exception {
        BDynamicTimeRange timeRange;
        BFilterSet filterSet = params.has("filterSet") ? (BFilterSet)BsonDecoderPlugin.unmarshal(params.getJSONObject("filterSet")) : new BFilterSet();
        BDynamicTimeRange bDynamicTimeRange = timeRange = params.has("timeRange") ? (BDynamicTimeRange)BsonDecoderPlugin.unmarshal(params.getJSONObject("timeRange")) : BDynamicTimeRange.DEFAULT;
        if (!timeRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            BAbsTimeFilter timeFilter = new BAbsTimeFilter();
            timeFilter.initFromDynamicTimeRange(timeRange);
            BFilterEntry filterEntry = new BFilterEntry(true, TIMESTAMP_FILTER_KEY, (BIBqlFilter)timeFilter);
            filterSet.add(TIMESTAMP_FILTER_KEY, (BValue)filterEntry);
        }
        for (BFilterEntry entry : (BFilterEntry[])filterSet.getChildren(BFilterEntry.class)) {
            BValue filter;
            if (entry.getName().equals(TIMESTAMP_FILTER_KEY) || !((filter = entry.getFilter()) instanceof BAbsTimeFilter)) continue;
            BAbsTimeFilter absTimeFilter = (BAbsTimeFilter)filter;
            absTimeFilter.init(null);
        }
        return filterSet;
    }

    private static void process(BiConsumer<Map<String, Object>, AlarmSpaceConnection> operation, JSONObject clientParams, BoxWriter out, Context cx) throws Exception {
        boolean mostRecent;
        BAlarmService alarmService = BAlarmChannel.getAlarmService();
        BUser user = cx.getUser();
        HashSet<String> permissionFailureClasses = new HashSet<String>();
        boolean bl = mostRecent = clientParams.has(MOST_RECENT_KEY) && clientParams.getBoolean(MOST_RECENT_KEY);
        if (user == null) {
            throw new Exception("Unable to process operation. Unauthorized user.");
        }
        try (AlarmSpaceConnection conn = BAlarmChannel.getAlarmSpaceConnection(cx);){
            int i;
            Object value;
            HashMap<String, Object> operationParams = new HashMap<String, Object>();
            operationParams.put(CONTEXT_KEY, cx);
            if (clientParams.has(NOTE_KEY)) {
                operationParams.put(NOTE_KEY, clientParams.get(NOTE_KEY));
            }
            if (clientParams.has(IDS_KEY) && (value = clientParams.get(IDS_KEY)) instanceof JSONArray) {
                JSONArray ids = (JSONArray)value;
                for (i = 0; i < ids.length(); ++i) {
                    String id = JSONUtil.getString((JSONArray)ids, (int)i);
                    BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(id);
                    BAlarmRecord alarm = conn.getRecord(uuid);
                    if (alarm == null) {
                        throw new IOException("Unable to read alarm record. Alarm Record is null");
                    }
                    String alarmClassName = alarm.getAlarmClass();
                    if (permissionFailureClasses.contains(alarmClassName)) continue;
                    BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarmClassName);
                    alarmClass = alarmClass != null ? alarmClass : alarmService.getDefaultAlarmClass();
                    try {
                        if (clientParams.has(FORCE_CLEARED_KEY)) {
                            user.check((BIProtected)alarmClass, BPermissions.adminWrite);
                        } else {
                            user.check((BIProtected)alarmClass, BPermissions.operatorWrite);
                        }
                        operationParams.put(ALARM_RECORD_KEY, alarm);
                        operation.accept(operationParams, conn);
                        continue;
                    }
                    catch (PermissionException ex) {
                        String alarmClassDisplayName = alarmService.getAlarmClassDisplayName((Object)alarmClassName, cx).getString();
                        permissionFailureClasses.add(alarmClassDisplayName);
                    }
                }
            }
            if (clientParams.has(SOURCES_KEY) && (value = clientParams.get(SOURCES_KEY)) instanceof JSONArray) {
                JSONArray sources = (JSONArray)value;
                block23: for (i = 0; i < sources.length(); ++i) {
                    String src = JSONUtil.getString((JSONArray)sources, (int)i);
                    BOrdList source = (BOrdList)BOrdList.DEFAULT.decodeFromString(src);
                    try (Cursor alarmCursor = conn.getOpenAlarmsForSource(source);){
                        Cursor cursor = alarmCursor;
                        if (alarmCursor instanceof AbstractReverseCursor) {
                            cursor = ((AbstractReverseCursor)cursor).getReverseCursor();
                        }
                        while (cursor.next()) {
                            BAlarmRecord alarm = (BAlarmRecord)((BAlarmRecord)cursor.get()).newCopy(true);
                            String alarmClassName = alarm.getAlarmClass();
                            if (permissionFailureClasses.contains(alarmClassName)) continue;
                            BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarmClassName);
                            alarmClass = alarmClass != null ? alarmClass : alarmService.getDefaultAlarmClass();
                            try {
                                if (clientParams.has(FORCE_CLEARED_KEY)) {
                                    user.check((BIProtected)alarmClass, BPermissions.adminWrite);
                                } else {
                                    user.check((BIProtected)alarmClass, BPermissions.operatorWrite);
                                }
                                operationParams.put(ALARM_RECORD_KEY, alarm);
                                operation.accept(operationParams, conn);
                                if (!mostRecent) continue;
                                continue block23;
                            }
                            catch (PermissionException ex) {
                                String alarmClassDisplayName = alarmService.getAlarmClassDisplayName((Object)alarmClassName, cx).getString();
                                permissionFailureClasses.add(alarmClassDisplayName);
                            }
                        }
                        continue;
                    }
                }
            }
        }
        out.array();
        permissionFailureClasses.forEach(arg_0 -> ((BoxWriter)out).value(arg_0));
        out.endArray();
    }

    public static Map<String, Set<String>> getAllSubscribedAlarmClasses(BAlarmRecipient recipient, BAlarmService service, BUser user) {
        HashMap<String, Set<String>> alarmClassMap = new HashMap<String, Set<String>>();
        Predicate<String> permissionCheck = className -> !user.getPermissionsFor((BIProtected)service.lookupAlarmClass(className)).hasOperatorRead();
        Set<String> subscribedAlarmClasses = Collections.emptySet();
        String[] classes = recipient.getSubscribedAlarmClasses();
        if (classes.length > 0) {
            subscribedAlarmClasses = new HashSet(classes.length);
            Collections.addAll(subscribedAlarmClasses, classes);
            subscribedAlarmClasses.removeIf(permissionCheck);
        }
        alarmClassMap.put(DEFAULT, subscribedAlarmClasses);
        Set<String> escalated1AlarmClasses = BAlarmChannel.getEscalatedAlarmClasses(1, recipient, permissionCheck, subscribedAlarmClasses);
        alarmClassMap.put("level1", escalated1AlarmClasses);
        Set<String> escalated2AlarmClasses = BAlarmChannel.getEscalatedAlarmClasses(2, recipient, permissionCheck, escalated1AlarmClasses);
        alarmClassMap.put("level2", escalated2AlarmClasses);
        Set<String> escalated3AlarmClasses = BAlarmChannel.getEscalatedAlarmClasses(3, recipient, permissionCheck, escalated2AlarmClasses);
        alarmClassMap.put("level3", escalated3AlarmClasses);
        return alarmClassMap;
    }

    private static Set<String> getEscalatedAlarmClasses(int level, BAlarmRecipient recipient, Predicate<String> permissionCheck, Collection<String> additionalAlarmClasses) {
        String[] classes = recipient.getSubscribedEscalatedAlarmClasses(level);
        if (classes.length == 0 && additionalAlarmClasses.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> alarmClasses = new HashSet<String>(classes.length + additionalAlarmClasses.size());
        Collections.addAll(alarmClasses, classes);
        alarmClasses.removeIf(permissionCheck);
        alarmClasses.addAll(additionalAlarmClasses);
        return alarmClasses;
    }

    public static boolean canShowAlarmRecord(BAlarmRecord record, Map<String, Set<String>> alarmClasses, Set<String> allKnownAlarmClassNames) {
        Set<String> classes;
        String key = record.getAlarmData().gets("escalated", "");
        if (key.isEmpty()) {
            key = DEFAULT;
        }
        if ((classes = alarmClasses.get(key)) == null) {
            return false;
        }
        if (!allKnownAlarmClassNames.contains(record.getAlarmClass()) && classes.contains("defaultAlarmClass")) {
            return true;
        }
        return classes.contains(record.getAlarmClass());
    }

    public static BoxString encodeAlarm(BAlarmRecord record, Context cx) throws IOException {
        BFacets data = record.getAlarmData();
        if (data.isEmpty()) {
            return BAlarmChannel.marshal(record, cx);
        }
        boolean modified = false;
        for (String key : data.list()) {
            BObject value = data.get(key);
            if (!(value instanceof BString)) continue;
            String newValueStr = record.getFormattedAlarmDataValue(key, cx);
            if (!newValueStr.isEmpty() && ("hyperlinkOrd".equals(key) || "icon".equals(key))) {
                try {
                    newValueStr = BOrd.make((String)newValueStr).normalize().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (value.toString().equals(newValueStr)) continue;
            data = BFacets.make((BFacets)data, (String)key, (BIDataValue)BString.make((String)newValueStr));
            modified = true;
        }
        if (modified) {
            record = (BAlarmRecord)record.newCopy(true);
            record.setAlarmData(data);
        }
        return BAlarmChannel.marshal(record, cx);
    }

    private static BoxString marshal(BAlarmRecord record, Context cx) throws IOException {
        return new BoxString(BsonEncoderPlugin.marshal((BValue)record, cx));
    }

    private static BAlarmService getAlarmService() {
        return (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    private static BAlarmDatabase getAlarmDatabase() {
        return BAlarmChannel.getAlarmService().getAlarmDb();
    }

    private static AlarmSpaceConnection getAlarmSpaceConnection(Context cx) {
        return BAlarmChannel.getAlarmService().getAlarmDb().getConnection(cx);
    }
}

