/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.util;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.FileCache;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;

public class DaemonGlob {
    public static FilePath[] expandPathString(BFileSpace space, String pathString) throws Exception {
        return DaemonGlob.expandPathString(space, pathString, null);
    }

    public static FilePath[] expandPathString(BFileSpace space, String pathString, FileCache cache) throws Exception {
        Array<FilePath> resultList = new Array<FilePath>(FilePath.class);
        try {
            FilePath temp = new FilePath(pathString);
            resultList.add((Object)temp);
        }
        catch (SyntaxException se) {
            String baseString;
            switch (pathString.charAt(0)) {
                case '!': 
                case '/': 
                case '^': {
                    if (pathString.startsWith("//")) {
                        int authEnd = pathString.substring(2).indexOf(47);
                        baseString = pathString.substring(0, authEnd + 3);
                        break;
                    }
                    baseString = pathString.substring(0, 1);
                    break;
                }
                default: {
                    throw new BajaRuntimeException(pathString + " is not an absolute FilePath or valid wildcard");
                }
            }
            resultList.add((Object)new FilePath(baseString));
            String[] names = TextUtil.split((String)pathString.substring(baseString.length()), (char)'/');
            for (int i = 0; i < names.length; ++i) {
                resultList = DaemonGlob.expandWildcard(space, resultList, names[i], i < names.length - 1, cache);
            }
        }
        return (FilePath[])resultList.trim();
    }

    public static Array<FilePath> expandWildcard(BFileSpace space, Array<FilePath> basePaths, String wildcard, boolean dirsOnly) throws Exception {
        return DaemonGlob.expandWildcard(space, basePaths, wildcard, dirsOnly, null);
    }

    public static Array<FilePath> expandWildcard(BFileSpace space, Array<FilePath> basePaths, String wildcard, boolean dirsOnly, FileCache cache) throws Exception {
        PathMatcher matcher = null;
        try {
            new FilePath(wildcard);
        }
        catch (SyntaxException se) {
            matcher = FileSystems.getDefault().getPathMatcher("glob:" + wildcard);
        }
        Array result = new Array(FilePath.class);
        for (int ixPath = 0; ixPath < basePaths.size(); ++ixPath) {
            BIFile[] kids;
            FilePath basePath = (FilePath)basePaths.get(ixPath);
            if (matcher == null) {
                BIFile file = DaemonFileUtil.findFile((BFileSpace)space, (FilePath)basePath.merge(new FilePath(wildcard)), (FileCache)cache);
                if (file == null) continue;
                result.add((Object)file.getFilePath());
                continue;
            }
            BDirectory dir = (BDirectory)DaemonFileUtil.findFile((BFileSpace)space, (FilePath)basePath, (FileCache)cache);
            if (dir == null) continue;
            for (BIFile kid : kids = dir.listFiles()) {
                String fileName = kid.getFileName();
                if (dirsOnly && !kid.isDirectory() || !matcher.matches(FileSystems.getDefault().getPath(fileName, new String[0]))) continue;
                result.add((Object)kid.getFilePath());
            }
        }
        return result;
    }

    public static String makeFilePathString(String path) {
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.indexOf(58) >= 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        return path;
    }
}

