/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStartStationCommand
extends BDaemonSessionCommand {
    public static final BStartStationCommand INSTANCE = new BStartStationCommand();
    public static final Type TYPE = Sys.loadType(BStartStationCommand.class);
    private static Logger log = Logger.getLogger("startstation");

    public Type getType() {
        return TYPE;
    }

    protected BStartStationCommand() {
    }

    public String getCommandName() {
        return "startstation";
    }

    public String getCommandDescription() {
        return "request that a Niagara Platform Daemon start a station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BStartStationCommand.println((String)"", (Object[])new Object[0]);
        BStartStationCommand.println((String)"usage:", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  plat startstation <flags> [stationname]", (Object[])new Object[0]);
        BStartStationCommand.println((String)"parameters:", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  stationname        name of the station to start.   If omitted,", (Object[])new Object[0]);
        BStartStationCommand.println((String)"                       the first/only station will be started", (Object[])new Object[0]);
        BStartStationCommand.println((String)"required flags:", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -h:<hostord>       host's ORD", (Object[])new Object[0]);
        BStartStationCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BStartStationCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BStartStationCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BStartStationCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -p:<port>          port for the host's platform daemon", (Object[])new Object[0]);
        BStartStationCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BStartStationCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BStartStationCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        String stationName;
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        if (args.parameters.length == 0) {
            BStationSurrogate[] stations = BStationSurrogate.makeAll((BDaemonSession)session);
            if (stations.length == 0) {
                log.warning("No stations on remote host");
                return 4;
            }
            stationName = stations[0].getStationName();
        } else {
            stationName = args.parameters[0];
        }
        BStationSurrogate station = BStationSurrogate.make((BDaemonSession)session, (String)stationName);
        if (station.getStationStatus() == BStationStatus.unknown) {
            log.severe("Station " + stationName + " not found");
            return 1;
        }
        if (station.getStationStatus() == BStationStatus.running || station.getStationStatus() == BStationStatus.starting || station.getStationStatus() == BStationStatus.stopping) {
            log.warning("Station " + stationName + " is already running");
            return 4;
        }
        station.startStationAsync();
        log.info("Station " + stationName + " started");
        return 0;
    }
}

