/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BListStationsCommand
extends BDaemonSessionCommand {
    public static final BListStationsCommand INSTANCE = new BListStationsCommand();
    public static final Type TYPE = Sys.loadType(BListStationsCommand.class);
    private static final int NAME_WIDTH = 19;
    private static final int STATUS_WIDTH = 8;
    private static final int FOX_PORT_WIDTH = 8;
    private static final int HTTP_PORT_WIDTH = 9;
    private static final int AUTO_START_WIDTH = 12;
    private static final int AUTO_RESTART_WIDTH = 18;

    public Type getType() {
        return TYPE;
    }

    protected BListStationsCommand() {
    }

    public String getCommandName() {
        return "liststations";
    }

    public String getCommandDescription() {
        return "list stations managed by the Niagara platform daemon";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BListStationsCommand.println((String)"", (Object[])new Object[0]);
        BListStationsCommand.println((String)"usage:", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  plat liststations <flags> [stationname]", (Object[])new Object[0]);
        BListStationsCommand.println((String)"required flags:", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -h:<hostord>       host's ORD", (Object[])new Object[0]);
        BListStationsCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BListStationsCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BListStationsCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BListStationsCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -p:<port>          port for the host's platform daemon", (Object[])new Object[0]);
        BListStationsCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -running           limit listing to running stations", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BListStationsCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BListStationsCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean filterRunning = args.hasOption("running");
        BStationSurrogate[] stations = BStationSurrogate.makeAll((BDaemonSession)session);
        this.printHeaders();
        boolean stationsPrinted = false;
        for (int i = 0; i < stations.length; ++i) {
            if (filterRunning && stations[i].getStationStatus() != BStationStatus.running) continue;
            this.printStationLine(stations[i]);
            stationsPrinted = true;
        }
        return stationsPrinted ? 0 : 4;
    }

    private void printHeaders() {
        System.out.print(TextUtil.padRight((String)"Name", (int)19));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Status", (int)8));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Fox Port", (int)8));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"HTTP Port", (int)9));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Auto-Start", (int)12));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Restart on Failure", (int)18));
        System.out.println();
        this.printDashes(19);
        System.out.print(" ");
        this.printDashes(8);
        System.out.print(" ");
        this.printDashes(8);
        System.out.print(" ");
        this.printDashes(9);
        System.out.print(" ");
        this.printDashes(12);
        System.out.print(" ");
        this.printDashes(18);
        System.out.println();
    }

    private void printStationLine(BStationSurrogate station) {
        System.out.print(TextUtil.padRight((String)station.getStationName(), (int)19));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)station.getStationStatus().getTag(), (int)8));
        System.out.print(" ");
        if (station.getFoxPort() > 0) {
            System.out.print(TextUtil.padRight((String)String.valueOf(station.getFoxPort()), (int)8));
        } else {
            System.out.print(TextUtil.padRight((String)"n/a", (int)8));
        }
        System.out.print(" ");
        if (station.getHttpPort() > 0) {
            System.out.print(TextUtil.padRight((String)String.valueOf(station.getHttpPort()), (int)9));
        } else {
            System.out.print(TextUtil.padRight((String)"n/a", (int)9));
        }
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)String.valueOf(station.getIsAutoStart()), (int)12));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)String.valueOf(station.getIsAutoRestart()), (int)18));
        System.out.println();
    }

    private void printDashes(int width) {
        for (int i = 0; i < width; ++i) {
            System.out.print('-');
        }
    }
}

