/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.install.BDependency;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModuleStatus;
import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.util.CommandLineArguments;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BJaceJarCommand
extends BAbstractPlatformCommand {
    public static final BJaceJarCommand INSTANCE = new BJaceJarCommand();
    public static final Type TYPE = Sys.loadType(BJaceJarCommand.class);
    private static Logger log = Logger.getLogger("jacejar");

    public Type getType() {
        return TYPE;
    }

    protected BJaceJarCommand() {
    }

    public String getCommandName() {
        return "jacejar";
    }

    public String getCommandDescription() {
        return "create Niagara module files that can be run on embedded hosts";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BJaceJarCommand.println((String)"", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"usage:", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  plat jacejar <flags> [modulename]", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"parameters:", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  modulename         name of a Niagara module for which a Jace-ready", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"                       file is to be created (UI entries are stripped)", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"required flags:", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  -dest:<destPath>   path of a local directory where the new file(s)", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"                       are to be created.   If \"\\\" char is used,", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"                       it must be escaped, e.g. -d:d:\\\\niagara\\\\forjace", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        String destDirName = args.getOption("dest");
        if (destDirName == null) {
            this.usage();
            return 2;
        }
        if (args.parameters.length == 0) {
            log.severe("no modules specified");
            this.usage();
            return 2;
        }
        BModuleContent moduleContent = BModuleContent.make((String)args.getOption("moduleContent", "runtime"));
        int retCode = 0;
        File destDir = new File(destDirName);
        for (int i = 0; i < args.parameters.length; ++i) {
            BModuleInstallable inst = (BModuleInstallable)LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)args.parameters[i]), null);
            if (inst != null && inst.getModulePart().getStatus() == BModuleStatus.ok) {
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(new File(destDir, args.parameters[i] + ".jar")));
                inst.getModulePart().writePackageArchive(moduleContent, true, out);
                out.closeEntry();
                out.flush();
                out.close();
                log.info("created module archive for " + args.parameters[i]);
                continue;
            }
            log.severe(args.parameters[i] + " is not a valid module JAR");
            retCode = 3;
        }
        return retCode;
    }
}

