/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.messages;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.xprotect.camera.BXProtectCamera;
import com.tridium.xprotect.camera.BXProtectCameraDeviceId;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.sys.BajaRuntimeException;

public class XProtectFocusControlReq
extends NMessage {
    BXProtectCamera camera;
    BVideoFocusEnum focusEnum;

    public XProtectFocusControlReq(BXProtectCamera camera, BVideoFocusEnum focusEnum) {
        this.camera = camera;
        this.focusEnum = focusEnum;
    }

    public boolean toOutputStream(OutputStream out) {
        PrintWriter buf = new PrintWriter(out);
        buf.write("*2");
        BXProtectCameraDeviceId cameraDeviceId = (BXProtectCameraDeviceId)this.camera.getVideoDeviceId();
        String cameraId = cameraDeviceId.getCameraId();
        int focusEnumOrdinal = this.focusEnum.getOrdinal();
        buf.write(this.getFocusCtrlCmd(focusEnumOrdinal));
        buf.flush();
        return false;
    }

    public String getFocusCtrlCmd(int focusEnum) {
        if (focusEnum >= 0 && focusEnum <= 1) {
            return "D";
        }
        if (focusEnum >= 2 && focusEnum <= 4) {
            return "7";
        }
        if (focusEnum >= 5 && focusEnum <= 7) {
            return "9";
        }
        throw new BajaRuntimeException("Unsupported BVideoFocusEnum ordinal - " + focusEnum);
    }
}

