/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.event;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.event.BVideoEventProxyExt;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.xprotect.camera.BXProtectCamera;
import com.tridium.xprotect.camera.BXProtectCameraDeviceId;
import com.tridium.xprotect.datatypes.BXProtectEventTypesEnum;
import com.tridium.xprotect.event.BXProtectEventCameraExt;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BXProtectEventProxyExt
extends BVideoEventProxyExt {
    public static final Property XprotectEventTypeEnum = BXProtectEventProxyExt.newProperty((int)1, (BValue)BXProtectEventTypesEnum.motionDetected, (BFacets)SfUtil.incl());
    public static final Type TYPE = Sys.loadType(BXProtectEventProxyExt.class);

    public BXProtectEventTypesEnum getXprotectEventTypeEnum() {
        return (BXProtectEventTypesEnum)this.get(XprotectEventTypeEnum);
    }

    public void setXprotectEventTypeEnum(BXProtectEventTypesEnum v) {
        this.set(XprotectEventTypeEnum, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BXProtectEventCameraExt.TYPE;
    }

    public BVideoEventTypesEnum getEventTypeEnum() {
        if (this.getXprotectEventTypeEnum() == BXProtectEventTypesEnum.motionDetected) {
            return BVideoEventTypesEnum.motionStarted;
        }
        if (this.getXprotectEventTypeEnum() == BXProtectEventTypesEnum.cameraFail) {
            return BVideoEventTypesEnum.fault;
        }
        return BVideoEventTypesEnum.nullEvent;
    }

    public void videoProxyExtStarted() {
        super.videoProxyExtStarted();
        BXProtectManagementServer dvr = (BXProtectManagementServer)DrUtil.getParent((BComplex)this, (Type)BXProtectManagementServer.TYPE);
        dvr.registerEventProxy(this, this.getXprotectEventTypeEnum());
    }

    public void stopped() throws Exception {
        super.stopped();
        BXProtectManagementServer dvr = (BXProtectManagementServer)DrUtil.getParent((BComplex)this, (Type)BXProtectManagementServer.TYPE);
        dvr.unregisterEventProxy(this, this.getXprotectEventTypeEnum());
    }

    protected void implEnableDetection(boolean on) throws Exception {
        if (this.getEventTypeEnum() != BVideoEventTypesEnum.motionStarted) {
            throw new BajaRuntimeException("Can only control event detection for 'motionStarted' events, not " + this.getEventTypeEnum() + ". Please have my program fixed.");
        }
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public boolean write(Context cx) throws Exception {
        throw new BajaRuntimeException("BXProtectEventProxyExt " + this.getDisplayName(cx) + " is not writeable");
    }

    public String getCameraId() throws Exception {
        BXProtectCamera cam = (BXProtectCamera)this.getVideoCamera();
        return ((BXProtectCameraDeviceId)cam.getVideoDeviceId()).getCameraId();
    }

    public void updateMotion(boolean motionDetected, BAbsTime cameraTime) {
        BVideoEvent videoEvent;
        BDynamicEnum e = BDynamicEnum.make((BEnum)BXProtectEventTypesEnum.motionDetected);
        if (motionDetected) {
            videoEvent = BVideoEvent.makeMotionStarted();
            videoEvent.setTimestamp(cameraTime);
            videoEvent.setDescription("VMD " + this.getVideoCamera().getCameraDescription());
        } else {
            videoEvent = BVideoEvent.makeMotionStopped();
            videoEvent.setMetaData(BFacets.make((String)"XprotectEventType", (BIDataValue)e));
            videoEvent.setTimestamp(cameraTime);
        }
        BVideoEventStatus eventStaus = new BVideoEventStatus(videoEvent);
        this.readOk((BStatusValue)eventStaus);
    }

    public void updateCameraFail(boolean cameraFail, BAbsTime cameraTime) {
        BDynamicEnum e;
        BVideoEvent videoEvent;
        if (cameraFail) {
            videoEvent = BVideoEvent.makeOffNormalEvent();
            videoEvent.setEventType(BVideoEventTypesEnum.fault);
            e = BDynamicEnum.make((BEnum)BXProtectEventTypesEnum.cameraFail);
            videoEvent.setMetaData(BFacets.make((String)"XprotectEventType", (BIDataValue)e));
            videoEvent.setDescription(BXProtectEventTypesEnum.cameraFail.getDisplayTag(null));
            videoEvent.setTimestamp(cameraTime);
        } else {
            videoEvent = BVideoEvent.makeNormalEvent();
            videoEvent.setEventType(BVideoEventTypesEnum.fault);
            e = BDynamicEnum.make((BEnum)BXProtectEventTypesEnum.cameraRestored);
            videoEvent.setMetaData(BFacets.make((String)"XprotectEventType", (BIDataValue)e));
            videoEvent.setDescription(BXProtectEventTypesEnum.cameraRestored.getDisplayTag(null));
            videoEvent.setTimestamp(cameraTime);
        }
        BVideoEventStatus eventStaus = new BVideoEventStatus(videoEvent);
        this.readOk((BStatusValue)eventStaus);
    }
}

