/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.datatypes;

import com.tridium.ndriver.util.SfUtil;
import com.tridium.xprotect.datatypes.BXProtectAuthType;
import javax.baja.security.BPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BXProtectAuthConfig
extends BStruct {
    public static final Property authType = BXProtectAuthConfig.newProperty((int)0, (BValue)BXProtectAuthType.basic, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property domain = BXProtectAuthConfig.newProperty((int)0, (String)"", (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property username = BXProtectAuthConfig.newProperty((int)0, (String)"", (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property password = BXProtectAuthConfig.newProperty((int)0, (BValue)BPassword.DEFAULT, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Type TYPE = Sys.loadType(BXProtectAuthConfig.class);

    public BXProtectAuthType getAuthType() {
        return (BXProtectAuthType)this.get(authType);
    }

    public void setAuthType(BXProtectAuthType v) {
        this.set(authType, (BValue)v, null);
    }

    public String getDomain() {
        return this.getString(domain);
    }

    public void setDomain(String v) {
        this.setString(domain, v, null);
    }

    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BXProtectAuthConfig makeWindows(String domain, String username, String password) {
        BXProtectAuthConfig auth = BXProtectAuthConfig.makeBasic(username, password);
        auth.setAuthType(BXProtectAuthType.windows);
        auth.setDomain(domain);
        return auth;
    }

    public static BXProtectAuthConfig makeBasic(String username, String password) {
        BXProtectAuthConfig auth = new BXProtectAuthConfig();
        auth.setUsername(username);
        auth.setPassword(BPassword.make((String)password));
        return auth;
    }
}

